/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.resolve.StylesheetFileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class StylesheetFileReferenceSet
extends FileReferenceSet {
    private static final Set<String> FONT_EXTENSIONS = Set.of("otf", "ttf", "eot", "woff", "woff2", "ufo");
    public static final Condition<PsiFileSystemItem> FONT_COMPLETION_FILTER = item -> {
        String extension = item.getVirtualFile().getExtension();
        return extension != null && FONT_EXTENSIONS.contains(extension);
    };
    public static final Condition<PsiFileSystemItem> SVG_COMPLETION_FILTER = item -> {
        VirtualFile virtualFile = item.getVirtualFile();
        return virtualFile.getFileType() == XmlFileType.INSTANCE && "svg".equals(virtualFile.getExtension());
    };
    private final boolean myIsImageReference;
    private final boolean myIsFontReference;

    public StylesheetFileReferenceSet(@NotNull PsiElement element, @NotNull String referenceText, @NotNull TextRange textRange, FileType ... suitableFileTypes) {
        if (element == null) {
            StylesheetFileReferenceSet.$$$reportNull$$$0(0);
        }
        if (referenceText == null) {
            StylesheetFileReferenceSet.$$$reportNull$$$0(1);
        }
        if (textRange == null) {
            StylesheetFileReferenceSet.$$$reportNull$$$0(2);
        }
        this(element, referenceText, textRange, false, false, suitableFileTypes);
    }

    public StylesheetFileReferenceSet(@NotNull PsiElement element, @NotNull String referenceText, @NotNull TextRange textRange, boolean isImageReference, boolean isFontReference, FileType ... suitableFileTypes) {
        if (element == null) {
            StylesheetFileReferenceSet.$$$reportNull$$$0(3);
        }
        if (referenceText == null) {
            StylesheetFileReferenceSet.$$$reportNull$$$0(4);
        }
        if (textRange == null) {
            StylesheetFileReferenceSet.$$$reportNull$$$0(5);
        }
        super(referenceText, element, textRange.getStartOffset(), null, SystemInfo.isFileSystemCaseSensitive, false, suitableFileTypes);
        this.myIsImageReference = isImageReference;
        this.myIsFontReference = isFontReference;
    }

    public boolean isAbsolutePathReference() {
        String path = this.getPathString();
        return SystemInfo.isWindows && OSAgnosticPathUtil.isAbsoluteDosPath((String)path) || path.startsWith("/");
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        LinkedHashSet<PsiFileSystemItem> result = new LinkedHashSet<PsiFileSystemItem>();
        Collection defaultContexts = super.computeDefaultContexts();
        if (this.isAbsolutePathReference()) {
            result.addAll(this.toFileSystemItems(ManagingFS.getInstance().getLocalRoots()));
        } else {
            Collection parentDirectoryContexts = this.getParentDirectoryContext();
            PsiFileSystemItem parentDirectoryContext = (PsiFileSystemItem)ContainerUtil.getFirstItem((Collection)parentDirectoryContexts);
            if (parentDirectoryContext != null) {
                boolean parentDirectoryAdded = false;
                for (PsiFileSystemItem defaultContext : defaultContexts) {
                    if (!Comparing.equal((Object)defaultContext.getVirtualFile(), (Object)parentDirectoryContext.getVirtualFile())) continue;
                    parentDirectoryAdded = true;
                }
                if (!parentDirectoryAdded) {
                    result.add(parentDirectoryContext);
                }
            }
        }
        result.addAll(defaultContexts);
        ContainerUtil.addAllNotNull(result, this.getJavaResourceRoots());
        LinkedHashSet<PsiFileSystemItem> linkedHashSet = result;
        if (linkedHashSet == null) {
            StylesheetFileReferenceSet.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    @NotNull
    private @Unmodifiable Collection<PsiFileSystemItem> getJavaResourceRoots() {
        if (!PlatformUtils.isIdeaUltimate()) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                StylesheetFileReferenceSet.$$$reportNull$$$0(7);
            }
            return list;
        }
        PsiElement element = this.getElement();
        if (!element.isValid()) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                StylesheetFileReferenceSet.$$$reportNull$$$0(8);
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                StylesheetFileReferenceSet.$$$reportNull$$$0(9);
            }
            return list;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        List list = ContainerUtil.map((Collection)moduleRootManager.getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE), file -> FileReferenceHelper.getPsiFileSystemItem((PsiManager)element.getManager(), (VirtualFile)file));
        if (list == null) {
            StylesheetFileReferenceSet.$$$reportNull$$$0(10);
        }
        return list;
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return StylesheetFileReferenceSet.createCompletionFilter(this.getElement(), this.myIsImageReference, this.myIsFontReference, this.getSuitableFileTypes());
    }

    @NotNull
    private static Condition<PsiFileSystemItem> createCompletionFilter(@NotNull PsiElement element, boolean isImageReference, boolean isFontReference, FileType @Nullable [] fileType) {
        if (element == null) {
            StylesheetFileReferenceSet.$$$reportNull$$$0(11);
        }
        if (isFontReference) {
            Condition<PsiFileSystemItem> condition = FONT_COMPLETION_FILTER;
            if (condition == null) {
                StylesheetFileReferenceSet.$$$reportNull$$$0(12);
            }
            return condition;
        }
        StylesheetFileTypeCompletionFilter condition = new StylesheetFileTypeCompletionFilter(element, fileType);
        if (isImageReference) {
            condition = Conditions.or((Condition)condition, SVG_COMPLETION_FILTER);
        }
        StylesheetFileTypeCompletionFilter stylesheetFileTypeCompletionFilter = condition;
        if (stylesheetFileTypeCompletionFilter == null) {
            StylesheetFileReferenceSet.$$$reportNull$$$0(13);
        }
        return stylesheetFileTypeCompletionFilter;
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        return new StylesheetFileReference(this, range, index, text);
    }

    protected boolean useIncludingFileAsContext() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/resolve/StylesheetFileReferenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/resolve/StylesheetFileReferenceSet";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaResourceRoots";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionFilter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 12, 13 -> new IllegalStateException(string);
        };
    }

    public static final class StylesheetFileTypeCompletionFilter
    implements Condition<PsiFileSystemItem> {
        private final PsiElement myElement;
        private final FileType @NotNull [] myFileTypes;

        public StylesheetFileTypeCompletionFilter(@NotNull PsiElement element, FileType ... fileTypes) {
            if (element == null) {
                StylesheetFileTypeCompletionFilter.$$$reportNull$$$0(0);
            }
            this.myElement = element;
            this.myFileTypes = (FileType[])ObjectUtils.coalesce((Object)fileTypes, (Object)FileType.EMPTY_ARRAY);
        }

        public boolean value(PsiFileSystemItem item) {
            if (item.isDirectory()) {
                return true;
            }
            if (!this.myElement.isValid() || item.equals((Object)this.myElement.getContainingFile().getOriginalFile())) {
                return false;
            }
            if (this.myFileTypes.length == 0) {
                return item instanceof StylesheetFile;
            }
            VirtualFile virtualFile = item.getVirtualFile();
            return ArrayUtil.contains((Object)virtualFile.getFileType(), (Object[])this.myFileTypes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/resolve/StylesheetFileReferenceSet$StylesheetFileTypeCompletionFilter", "<init>"));
        }
    }
}

