/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.xml.impl.converters;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jpa.model.xml.converters.PersistentUnitFileConverter;
import com.intellij.jpa.model.xml.persistence.mapping.EntityMappings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ModuleContextProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentUnitFileConverterImpl
extends PersistentUnitFileConverter
implements CustomReferenceConverter {
    public PsiFile fromString(String s, @NotNull ConvertContext context) {
        if (context == null) {
            PersistentUnitFileConverterImpl.$$$reportNull$$$0(0);
        }
        if (s == null) {
            return null;
        }
        PsiReference[] references = this.createReferences((GenericDomValue)context.getInvocationElement(), (PsiElement)context.getReferenceXmlElement(), context);
        if (references.length == 0) {
            return null;
        }
        PsiElement element = references[references.length - 1].resolve();
        return element instanceof PsiFile ? (PsiFile)element : null;
    }

    public String toString(PsiFile t, @NotNull ConvertContext context) {
        if (context == null) {
            PersistentUnitFileConverterImpl.$$$reportNull$$$0(1);
        }
        if (t == null) {
            return null;
        }
        VirtualFile virtualFile = t.getVirtualFile();
        DomElement element = context.getInvocationElement();
        XmlFile persistenceXml = DomUtil.getFile((DomElement)element);
        return PersistentUnitFileConverterImpl.getUnitRootRelativePath(virtualFile, persistenceXml);
    }

    @NotNull
    public Collection<? extends PsiFile> getVariants(@NotNull ConvertContext context) {
        if (context == null) {
            PersistentUnitFileConverterImpl.$$$reportNull$$$0(2);
        }
        List list = Collections.emptyList();
        if (list == null) {
            PersistentUnitFileConverterImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    public PsiElement resolve(PsiFile o, @NotNull ConvertContext context) {
        if (context == null) {
            PersistentUnitFileConverterImpl.$$$reportNull$$$0(4);
        }
        return PersistentUnitFileConverterImpl.isFileAccepted(o) ? super.resolve((Object)o, context) : null;
    }

    @Nullable
    public static EntityMappings findEntityMappings(String mappingName, VirtualFile persistenceXmlVf, PsiManager psiManager, @Nullable Module module) {
        PsiFile psiFile;
        VirtualFile mappingFile = PersistentUnitFileConverterImpl.findUnitRootRelativeFile(mappingName, persistenceXmlVf, module);
        if (mappingFile != null && (psiFile = psiManager.findFile(mappingFile)) instanceof XmlFile) {
            XmlFile xmlFile = (XmlFile)psiFile;
            return (EntityMappings)JamCommonUtil.getRootElement((PsiFile)xmlFile, EntityMappings.class);
        }
        return null;
    }

    @Nullable
    public static VirtualFile findUnitRootRelativeFile(String mappingName, VirtualFile persistenceXmlVf, Module module) {
        VirtualFile mappingFile;
        block1: {
            PsiFileSystemItem root;
            VirtualFile file;
            VirtualFile metaInf = persistenceXmlVf == null ? null : persistenceXmlVf.getParent();
            VirtualFile persistenceUnitRootVf = metaInf == null ? null : metaInf.getParent();
            mappingFile = null;
            if (persistenceUnitRootVf == null || (mappingFile = persistenceUnitRootVf.findFileByRelativePath(mappingName)) != null || module == null) break block1;
            Iterator<PsiFileSystemItem> iterator = PersistentUnitFileConverterImpl.addDefaultRoots(new HashSet<PsiFileSystemItem>(), module.getProject(), module).iterator();
            while (iterator.hasNext() && (mappingFile = (file = (root = iterator.next()).getVirtualFile()) == null ? null : file.findFileByRelativePath(mappingName)) == null) {
            }
        }
        return mappingFile;
    }

    @Nullable
    public static String getUnitRootRelativePath(VirtualFile virtualFile, XmlFile persistenceXml) {
        if (virtualFile == null) {
            return null;
        }
        if (persistenceXml == null) {
            return virtualFile.getName();
        }
        XmlFile xmlFile = (XmlFile)persistenceXml.getOriginalFile();
        VirtualFile persistenceXmlVf = xmlFile.getVirtualFile();
        if (persistenceXmlVf == null) {
            return virtualFile.getName();
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)persistenceXml.getProject()).getFileIndex();
        VirtualFile sourceRootForFile = index.getSourceRootForFile(virtualFile);
        VirtualFile sourceRootForPersistenceXml = index.getSourceRootForFile(persistenceXmlVf);
        VirtualFile persistenceUnitRootVf = persistenceXmlVf.getParent() == null ? null : persistenceXmlVf.getParent().getParent();
        VirtualFile realRoot = sourceRootForFile == null || Comparing.equal((Object)sourceRootForPersistenceXml, (Object)sourceRootForFile) ? persistenceUnitRootVf : sourceRootForFile;
        return VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)(realRoot == null ? index.getContentRootForFile(virtualFile) : realRoot), (char)'/');
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        String s = genericDomValue.getStringValue();
        if (s == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                PersistentUnitFileConverterImpl.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        int offset = ElementManipulators.getOffsetInElement((PsiElement)element);
        FileReferenceSet set = PersistentUnitFileConverterImpl.createUnitRelativeFileReferenceSet(context, s, element, offset, (Condition<? super PsiFile>)((Condition)psiFile -> PersistentUnitFileConverterImpl.isFileAccepted(psiFile)));
        FileReference[] fileReferenceArray = set.getAllReferences();
        if (fileReferenceArray == null) {
            PersistentUnitFileConverterImpl.$$$reportNull$$$0(6);
        }
        return fileReferenceArray;
    }

    private static boolean isFileAccepted(PsiFile file) {
        return file instanceof XmlFile && DomManager.getDomManager((Project)file.getProject()).getFileElement((XmlFile)file, EntityMappings.class) != null;
    }

    public static FileReferenceSet createUnitRelativeFileReferenceSet(final ConvertContext context, String text, final @NotNull PsiElement element, int startInElement, final Condition<? super PsiFile> fileFilter) {
        if (element == null) {
            PersistentUnitFileConverterImpl.$$$reportNull$$$0(7);
        }
        return new FileReferenceSet(text, element, startInElement, null, true){

            protected boolean isSoft() {
                return true;
            }

            @NotNull
            public Collection<PsiFileSystemItem> computeDefaultContexts() {
                PsiFile containingFile = element.getContainingFile().getOriginalFile();
                VirtualFile virtualFile = containingFile.getVirtualFile();
                VirtualFile metaInf = virtualFile == null ? null : virtualFile.getParent();
                VirtualFile persistenceUnitRootVf = metaInf == null ? null : metaInf.getParent();
                HashSet<PsiFileSystemItem> result = new HashSet<PsiFileSystemItem>();
                Project project = element.getProject();
                if (persistenceUnitRootVf != null) {
                    ContainerUtil.addIfNotNull(result, (Object)PsiManager.getInstance((Project)project).findDirectory(persistenceUnitRootVf));
                }
                Collection<PsiFileSystemItem> collection = PersistentUnitFileConverterImpl.addDefaultRoots(result, context.getProject(), ModuleContextProvider.getModules((PsiFile)context.getFile()));
                if (collection == null) {
                    1.$$$reportNull$$$0(0);
                }
                return collection;
            }

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return element1 -> {
                    boolean isFile = element1 instanceof PsiFile;
                    return isFile && fileFilter.value((Object)((PsiFile)element1));
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/PersistentUnitFileConverterImpl$1", "computeDefaultContexts"));
            }
        };
    }

    private static Collection<PsiFileSystemItem> addDefaultRoots(Collection<PsiFileSystemItem> result, @NotNull Project project, Module ... modules) {
        if (project == null) {
            PersistentUnitFileConverterImpl.$$$reportNull$$$0(8);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (Module module : modules) {
            HashSet dependentModules = new HashSet();
            ModuleUtilCore.getDependencies((Module)module, dependentModules);
            for (Module dependency : dependentModules) {
                PersistentUnitFileConverterImpl.addModuleDefaultRoots(result, dependency, psiManager);
            }
        }
        return result;
    }

    private static void addModuleDefaultRoots(Collection<? super PsiFileSystemItem> result, Module module, PsiManager psiManager) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        for (VirtualFile root : rootManager.getSourceRoots()) {
            ContainerUtil.addIfNotNull(result, (Object)psiManager.findDirectory(root));
        }
        for (VirtualFile root : rootManager.getContentRoots()) {
            ContainerUtil.addIfNotNull(result, (Object)psiManager.findDirectory(root));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/model/xml/impl/converters/PersistentUnitFileConverterImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/model/xml/impl/converters/PersistentUnitFileConverterImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createUnitRelativeFileReferenceSet";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

