/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.annotations.mapping;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.javaee.constants.JpaAnnotationConstants;
import com.intellij.jpa.PersistenceAttributesProvider;
import com.intellij.jpa.model.annotations.mapping.AttributeBaseImpl;
import com.intellij.jpa.model.annotations.mapping.EmbeddableImpl;
import com.intellij.jpa.model.annotations.mapping.EntityImpl;
import com.intellij.jpa.model.annotations.mapping.EntityListenerImpl;
import com.intellij.jpa.model.annotations.mapping.EntityListenerMethodImpl;
import com.intellij.jpa.model.annotations.mapping.JamAttributeBase;
import com.intellij.jpa.model.annotations.mapping.MappedSuperclassImpl;
import com.intellij.jpa.model.common.persistence.mapping.AttributeBase;
import com.intellij.jpa.model.common.persistence.mapping.AttributeType;
import com.intellij.jpa.model.common.persistence.mapping.JpaAttributeType;
import com.intellij.jpa.model.xml.persistence.mapping.Entity;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMemberPattern;
import com.intellij.persistence.util.JavaTypeInfo;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.XmlConfigurationLightweightAccessorKt;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemRegistrar;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JpaJamContributor
extends SemContributor {
    JpaJamContributor() {
    }

    protected boolean isAvailable(@NotNull Project project) {
        if (project == null) {
            JpaJamContributor.$$$reportNull$$$0(0);
        }
        return JpaUtil.isJpaAvailable(project);
    }

    public void registerSemProviders(@NotNull SemRegistrar registrar, @NotNull Project project) {
        if (registrar == null) {
            JpaJamContributor.$$$reportNull$$$0(1);
        }
        if (project == null) {
            JpaJamContributor.$$$reportNull$$$0(2);
        }
        JpaAttributeType.BASIC.getAttributeClass();
        EntityImpl.ENTITY_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotations(JpaAnnotationConstants.ENTITY_ANNO.all()));
        EmbeddableImpl.EMBEDDABLE_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotations(JpaAnnotationConstants.EMBEDDABLE_ANNO.all()));
        MappedSuperclassImpl.MAPPED_SUPERCLASS_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotations(JpaAnnotationConstants.MAPPED_SUPERCLASS_ANNO.all()));
        EntityListenerImpl.ENTITY_LISTENER_META.register(registrar, JpaJamContributor.createEntityListenerPattern());
        AttributeBaseImpl.TRANSIENT_ATTR_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotations(JpaAnnotationConstants.TRANSIENT_ANNO.all()));
        AttributeBaseImpl.BASIC_ATTR_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotations(JpaAnnotationConstants.BASIC_ANNO.all()));
        AttributeBaseImpl.ID_ATTR_META.register(registrar, (ElementPattern)((PsiMemberPattern.Capture)((PsiMemberPattern.Capture)PsiJavaPatterns.psiMember().withAnnotations(JpaAnnotationConstants.ID_ANNO.all())).andNot((ElementPattern)JpaJamContributor.createHasEmbeddableTargetPattern())).andNot((ElementPattern)PsiJavaPatterns.psiMember().withAnnotations(new String[]{JpaAnnotationConstants.ONE_TO_ONE_ANNO.javax(), JpaAnnotationConstants.ONE_TO_ONE_ANNO.jakarta(), JpaAnnotationConstants.MANY_TO_ONE_ANNO.javax(), JpaAnnotationConstants.MANY_TO_ONE_ANNO.jakarta()})));
        AttributeBaseImpl.VERSION_ATTR_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotations(JpaAnnotationConstants.VERSION_ANNO.all()));
        AttributeBaseImpl.EMBEDDED_ATTR_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotations(JpaAnnotationConstants.EMBEDDED_ANNO.all()));
        AttributeBaseImpl.EMBEDDED_ID_ATTR_META.register(registrar, PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiMember().withAnnotations(JpaAnnotationConstants.EMBEDDED_ID_ANNO.all()), ((PsiMemberPattern.Capture)PsiJavaPatterns.psiMember().withAnnotations(JpaAnnotationConstants.ID_ANNO.all())).and((ElementPattern)JpaJamContributor.createHasEmbeddableTargetPattern())}));
        AttributeBaseImpl.MANY_TO_ONE_ATTR_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotations(JpaAnnotationConstants.MANY_TO_ONE_ANNO.all()));
        AttributeBaseImpl.MANY_TO_MANY_ATTR_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotations(JpaAnnotationConstants.MANY_TO_MANY_ANNO.all()));
        AttributeBaseImpl.ONE_TO_ONE_ATTR_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotations(JpaAnnotationConstants.ONE_TO_ONE_ANNO.all()));
        AttributeBaseImpl.ONE_TO_MANY_ATTR_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMember().withAnnotations(JpaAnnotationConstants.ONE_TO_MANY_ANNO.all()));
        AttributeBaseImpl.BASIC_COLLECTION_ATTR_META.register(registrar, (ElementPattern)((PsiMemberPattern.Capture)PsiJavaPatterns.psiMember().withAnnotations(JpaAnnotationConstants.ELEMENT_COLLECTION_ANNO.all())).andNot((ElementPattern)JpaJamContributor.createHasEmbeddableTargetPattern()));
        AttributeBaseImpl.EMBEDDED_COLLECTION_ATTR_META.register(registrar, (ElementPattern)((PsiMemberPattern.Capture)PsiJavaPatterns.psiMember().withAnnotations(JpaAnnotationConstants.ELEMENT_COLLECTION_ANNO.all())).and((ElementPattern)JpaJamContributor.createHasEmbeddableTargetPattern()));
        for (JamMemberMeta<PsiMember, ? extends JamAttributeBase> meta : PersistenceAttributesProvider.getAllJamMetas()) {
            meta.register(registrar, (ElementPattern)JpaJamContributor.createNotAnnotatedPattern(meta));
        }
        EntityListenerMethodImpl.METHOD_META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotations(new String[]{JpaAnnotationConstants.POST_LOAD_ANNO.javax(), JpaAnnotationConstants.POST_PERSIST_ANNO.javax(), JpaAnnotationConstants.POST_REMOVE_ANNO.javax(), JpaAnnotationConstants.POST_UPDATE_ANNO.javax(), JpaAnnotationConstants.PRE_PERSIST_ANNO.javax(), JpaAnnotationConstants.PRE_REMOVE_ANNO.javax(), JpaAnnotationConstants.PRE_UPDATE_ANNO.javax(), JpaAnnotationConstants.POST_LOAD_ANNO.jakarta(), JpaAnnotationConstants.POST_PERSIST_ANNO.jakarta(), JpaAnnotationConstants.POST_REMOVE_ANNO.jakarta(), JpaAnnotationConstants.POST_UPDATE_ANNO.jakarta(), JpaAnnotationConstants.PRE_PERSIST_ANNO.jakarta(), JpaAnnotationConstants.PRE_REMOVE_ANNO.jakarta(), JpaAnnotationConstants.PRE_UPDATE_ANNO.jakarta()}));
    }

    private static PsiMemberPattern.Capture createHasEmbeddableTargetPattern() {
        return (PsiMemberPattern.Capture)PsiJavaPatterns.psiMember().with((PatternCondition)new PatternCondition<PsiMember>("hasEmbeddableTarget"){

            public boolean accepts(@NotNull PsiMember psiMember, ProcessingContext context) {
                if (psiMember == null) {
                    1.$$$reportNull$$$0(0);
                }
                return JpaJamContributor.hasEmbeddableTarget(psiMember);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMember", "com/intellij/jpa/model/annotations/mapping/JpaJamContributor$1", "accepts"));
            }
        });
    }

    private static boolean hasEmbeddableTarget(PsiMember member) {
        JavaTypeInfo typeInfo = PersistenceCommonUtil.getTypeInfo((PsiType)PropertyUtilBase.getPropertyType((PsiMember)member));
        PsiType memberType = typeInfo.getValueType();
        if (!(memberType instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolvedMemberClass = ((PsiClassType)memberType).resolveGenerics().getElement();
        if (resolvedMemberClass == null) {
            return false;
        }
        return ContainerUtil.exists((Object[])JpaAnnotationConstants.EMBEDDABLE_ANNO.all(), it -> resolvedMemberClass.hasAnnotation(it));
    }

    private static PsiMemberPattern.Capture createNotAnnotatedPattern(final JamMemberMeta<PsiMember, ? extends JamAttributeBase> meta) {
        return (PsiMemberPattern.Capture)PsiJavaPatterns.psiMember().with((PatternCondition)new PatternCondition<PsiMember>("notAnnotatedAttribute"){

            public boolean accepts(@NotNull PsiMember member, ProcessingContext context) {
                if (member == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!JpaJamContributor.isAcceptableMember(member)) {
                    return false;
                }
                AttributeBase attribute = JpaJamContributor.xmlConfigurationFor(member);
                if (attribute != null && JpaJamContributor.xmlAttributeCorrespondsToGivenMeta(meta, attribute)) {
                    return true;
                }
                JamMemberMeta memberMeta = (JamMemberMeta)CachedValuesManager.getCachedValue((PsiElement)member, () -> new CachedValueProvider.Result(JpaJamContributor.guessMetaForNotAnnotatedMember(member), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
                return memberMeta == meta;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/jpa/model/annotations/mapping/JpaJamContributor$2", "accepts"));
            }
        });
    }

    private static boolean xmlAttributeCorrespondsToGivenMeta(JamMemberMeta<?, ?> meta, AttributeBase attribute) {
        return ArrayUtil.contains(meta, (Object[])AttributeType.getAttributeType(attribute).getJamMetas());
    }

    private static boolean isAcceptableMember(PsiMember member) {
        PsiField counterPart;
        if (!(member instanceof PsiField) && !(member instanceof PsiMethod)) {
            return false;
        }
        if (member.getContainingClass() == null) {
            return false;
        }
        if (member.hasModifierProperty("static") || member.hasModifierProperty("transient")) {
            return false;
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        if (member instanceof PsiMethod && PropertyUtilBase.isSimplePropertyGetter((PsiMethod)((PsiMethod)member))) {
            counterPart = containingClass.findFieldByName(PropertyUtilBase.getPropertyNameByGetter((PsiMethod)((PsiMethod)member)), false);
        } else if (member instanceof PsiField) {
            String fieldName = member.getName();
            counterPart = fieldName == null ? null : PropertyUtilBase.findPropertyGetter((PsiClass)containingClass, (String)fieldName, (boolean)false, (boolean)false);
        } else {
            return false;
        }
        Set<String> attributeAnnotations = PersistenceAttributesProvider.getAttributeAnnotations();
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)member, attributeAnnotations) == null && AnnotationUtil.findAnnotation((PsiModifierListOwner)counterPart, attributeAnnotations) == null;
    }

    @Nullable
    private static JamMemberMeta<?, ?> guessMetaForNotAnnotatedMember(PsiMember member) {
        PropertyMemberType propertyMemberType = JpaUtil.computeAccessType(member);
        if (!JpaJamContributor.shouldCheckMemberConsideringAccessType(member, propertyMemberType)) {
            return null;
        }
        if (JpaJamContributor.hasEmbeddableTarget(member)) {
            return AttributeBaseImpl.EMBEDDED_ATTR_META;
        }
        return AttributeBaseImpl.BASIC_ATTR_META;
    }

    private static boolean shouldCheckMemberConsideringAccessType(PsiMember member, PropertyMemberType propertyMemberType) {
        return propertyMemberType == PropertyMemberType.FIELD && member instanceof PsiField || propertyMemberType == PropertyMemberType.GETTER && member instanceof PsiMethod;
    }

    @Nullable
    private static AttributeBase xmlConfigurationFor(PsiMember member) {
        PropertyMemberType propertyMemberType;
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        Entity mapping = (Entity)CachedValuesManager.getCachedValue((PsiElement)member, () -> new CachedValueProvider.Result((Object)XmlConfigurationLightweightAccessorKt.findMappingInXmlConfigurationFile(containingClass), new Object[]{PsiModificationTracker.getInstance((Project)member.getProject()).forLanguage((Language)XMLLanguage.INSTANCE)}));
        if (mapping == null) {
            return null;
        }
        AttributeBase attributeDefinitionInXmlConfigurationFile = XmlConfigurationLightweightAccessorKt.findAttributeDefinitionInXmlConfigurationFile(member, mapping);
        if (attributeDefinitionInXmlConfigurationFile == null) {
            return null;
        }
        boolean fieldAccessConfigured = attributeDefinitionInXmlConfigurationFile.getAttributeModelHelper().isFieldAccess();
        PropertyMemberType propertyMemberType2 = propertyMemberType = fieldAccessConfigured ? PropertyMemberType.FIELD : mapping.getObjectModelHelper().getDefaultAccessMode();
        if (!JpaJamContributor.shouldCheckMemberConsideringAccessType(member, propertyMemberType)) {
            return null;
        }
        return attributeDefinitionInXmlConfigurationFile;
    }

    private static ElementPattern<? extends PsiClass> createEntityListenerPattern() {
        return PsiJavaPatterns.psiClass().with((PatternCondition)new PatternCondition<PsiClass>("isInEntityListenersAnnotation"){

            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    3.$$$reportNull$$$0(0);
                }
                return JpaUtil.getEntityListenerClasses(psiClass).contains(psiClass);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/jpa/model/annotations/mapping/JpaJamContributor$3", "accepts"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/model/annotations/mapping/JpaJamContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerSemProviders";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

