/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.blocking;

import com.intellij.codeInspection.blockingCallsDetection.BlockingMethodChecker;
import com.intellij.codeInspection.blockingCallsDetection.MethodContext;
import com.intellij.javaee.constants.JpaAnnotationConstants;
import com.intellij.jpa.model.common.persistence.JavaeePersistenceConstants;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jpa/blocking/JpaBlockingMethodChecker;", "Lcom/intellij/codeInspection/blockingCallsDetection/BlockingMethodChecker;", "<init>", "()V", "BLOCKING_ENTITYMANAGER_METHODS", "", "", "BLOCKING_QUERY_METHODS", "isApplicable", "", "file", "Lcom/intellij/psi/PsiFile;", "isMethodBlocking", "context", "Lcom/intellij/codeInspection/blockingCallsDetection/MethodContext;", "intellij.javaee.jpa.impl"})
public final class JpaBlockingMethodChecker
implements BlockingMethodChecker {
    @NotNull
    private final List<String> BLOCKING_ENTITYMANAGER_METHODS;
    @NotNull
    private final List<String> BLOCKING_QUERY_METHODS;

    public JpaBlockingMethodChecker() {
        Object[] objectArray = new String[]{"find", "flush", "refresh"};
        this.BLOCKING_ENTITYMANAGER_METHODS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"getResultList", "getResultStream", "getSingleResult", "getSingleResult", "executeUpdate"};
        this.BLOCKING_QUERY_METHODS = CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean isApplicable(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JavaeePersistenceConstants.PERSISTENCE_CONTEXT_CLASS.isAvailable(file.getProject(), file.getResolveScope());
    }

    public boolean isMethodBlocking(@NotNull MethodContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiMethod method = context.getElement();
        String string = context.getElement().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String methodName = string;
        return this.BLOCKING_ENTITYMANAGER_METHODS.contains(methodName) && JavaeePersistenceConstants.PERSISTENCE_CONTEXT_CLASS.isClass(method.getContainingClass()) || this.BLOCKING_QUERY_METHODS.contains(methodName) && JpaAnnotationConstants.QUERY_CLASS.isClass(method.getContainingClass());
    }
}

