/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.chat.completion;

import com.intellij.ml.inline.completion.impl.MLCompletionParameters;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionSkipLocationSupporter;
import com.intellij.ml.inline.completion.impl.kit.SkipLocationReason;
import com.intellij.ml.llm.chatInputLanguage.psi.ChatInputTypes;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000eH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/chat/completion/ChatInputSkipLocationSupporter;", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionSkipLocationSupporter;", "<init>", "()V", "skipVeryShortInputAndAfterPunctuation", "", "getSkipVeryShortInputAndAfterPunctuation", "()Z", "getReasonOrNull", "Lcom/intellij/ml/inline/completion/impl/kit/SkipLocationReason;", "parameters", "Lcom/intellij/ml/inline/completion/impl/MLCompletionParameters;", "hasPunctuationShortBeforeOffset", "offset", "", "text", "", "takeLastNonWhitespaceReversed", "n", "Companion", "intellij.ml.llm.chat.completion"})
@SourceDebugExtension(value={"SMAP\nChatInputSkipLocationSupporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatInputSkipLocationSupporter.kt\ncom/intellij/ml/llm/chat/completion/ChatInputSkipLocationSupporter\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,64:1\n1088#2,2:65\n*S KotlinDebug\n*F\n+ 1 ChatInputSkipLocationSupporter.kt\ncom/intellij/ml/llm/chat/completion/ChatInputSkipLocationSupporter\n*L\n36#1:65,2\n*E\n"})
public final class ChatInputSkipLocationSupporter
implements MLCompletionSkipLocationSupporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<Character> PUNCTUATION_SIGNS;
    private static final int MINIMUM_CARET_DISTANCE_FROM_START_FOR_COMPLETION = 15;
    private static final int MINIMUM_SENTENCE_LENGTH_FOR_COMPLETION_AFTER_PUNCTUATION = 5;

    private final boolean getSkipVeryShortInputAndAfterPunctuation() {
        return Boolean.parseBoolean(Registry.Companion.get("completion.cloud.chat.skipVeryShortInputAndAfterPunctuation").asString());
    }

    @Nullable
    public SkipLocationReason getReasonOrNull(@NotNull MLCompletionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        if (this.getSkipVeryShortInputAndAfterPunctuation() && parameters.getOffset() < 15) {
            return SkipLocationReason.CHAT_INPUT_NOT_SUPPORTED_FOR_VERY_SHORT_INPUT;
        }
        if (this.getSkipVeryShortInputAndAfterPunctuation()) {
            int n = parameters.getOffset();
            String string = parameters.getEditor().getDocument().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (this.hasPunctuationShortBeforeOffset(n, string)) {
                return SkipLocationReason.CHAT_INPUT_NOT_SUPPORTED_SHORT_AFTER_PUNCTUATION;
            }
        }
        PsiElement element = parameters.getPosition();
        PsiElement parent = element.getParent();
        if (ChatInputTypes.PLAINTEXT_TOKENS.contains(PsiTreeUtilKt.getElementType((PsiElement)element)) && Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)parent), (Object)ChatInputTypes.PLAINTEXT_SEGMENT)) {
            return null;
        }
        return SkipLocationReason.CHAT_INPUT_CODE_BLOCK_NOT_SUPPORTED;
    }

    private final boolean hasPunctuationShortBeforeOffset(int offset, String text) {
        boolean bl;
        block1: {
            String string = text.substring(0, offset);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            CharSequence $this$any$iv = this.takeLastNonWhitespaceReversed(string, 5);
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl2 = false;
                if (!PUNCTUATION_SIGNS.contains(Character.valueOf(it))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final String takeLastNonWhitespaceReversed(String $this$takeLastNonWhitespaceReversed, int n) {
        StringBuilder stringBuilder;
        StringBuilder $this$takeLastNonWhitespaceReversed_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int nonWhitespaceCharsFound = 0;
        for (int currentIndex = $this$takeLastNonWhitespaceReversed.length() - 1; nonWhitespaceCharsFound < n && currentIndex >= 0; --currentIndex) {
            char currentChar = $this$takeLastNonWhitespaceReversed.charAt(currentIndex);
            if (CharsKt.isWhitespace((char)currentChar)) continue;
            $this$takeLastNonWhitespaceReversed_u24lambda_u240.append(currentChar);
            ++nonWhitespaceCharsFound;
        }
        return stringBuilder.toString();
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('.'), Character.valueOf('?'), Character.valueOf(';'), Character.valueOf('!')};
        PUNCTUATION_SIGNS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/chat/completion/ChatInputSkipLocationSupporter$Companion;", "", "<init>", "()V", "PUNCTUATION_SIGNS", "", "", "getPUNCTUATION_SIGNS$intellij_ml_llm_chat_completion", "()Ljava/util/Set;", "MINIMUM_CARET_DISTANCE_FROM_START_FOR_COMPLETION", "", "MINIMUM_SENTENCE_LENGTH_FOR_COMPLETION_AFTER_PUNCTUATION", "intellij.ml.llm.chat.completion"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Character> getPUNCTUATION_SIGNS$intellij_ml_llm_chat_completion() {
            return PUNCTUATION_SIGNS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

