/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;

public final class TypesDistinctProver {
    public static final Set<String> ARRAY_SUPER_CLASSES = new HashSet<String>();

    private TypesDistinctProver() {
    }

    public static boolean provablyDistinct(PsiType type1, PsiType type2) {
        return TypesDistinctProver.provablyDistinct(type1, type2, 0);
    }

    static boolean provablyDistinct(PsiType type1, PsiType type2, int level) {
        if (type1 instanceof PsiWildcardType) {
            if (type2 instanceof PsiWildcardType) {
                return TypesDistinctProver.provablyDistinct((PsiWildcardType)type1, (PsiWildcardType)type2, true, level);
            }
            if (level > 1) {
                return true;
            }
            if (type2 instanceof PsiCapturedWildcardType) {
                return TypesDistinctProver.provablyDistinct((PsiWildcardType)type1, ((PsiCapturedWildcardType)type2).getWildcard(), false, level);
            }
            if (type2 instanceof PsiClassType) {
                PsiClass psiClass2 = PsiUtil.resolveClassInType(type2);
                if (psiClass2 == null) {
                    return false;
                }
                if (((PsiWildcardType)type1).isExtends()) {
                    PsiType extendsBound = ((PsiWildcardType)type1).getExtendsBound();
                    if (extendsBound instanceof PsiArrayType && TypesDistinctProver.proveArrayTypeDistinct((PsiArrayType)extendsBound, type2)) {
                        return true;
                    }
                    PsiClass boundClass1 = PsiUtil.resolveClassInType(extendsBound);
                    if (boundClass1 == null) {
                        return false;
                    }
                    if ("java.lang.Object".equals(psiClass2.getQualifiedName()) && !(boundClass1 instanceof PsiTypeParameter)) {
                        return !"java.lang.Object".equals(boundClass1.getQualifiedName());
                    }
                    return TypesDistinctProver.proveExtendsBoundsDistinct(type1, type2, boundClass1, psiClass2);
                }
                if (((PsiWildcardType)type1).isSuper()) {
                    PsiType superBound = ((PsiWildcardType)type1).getSuperBound();
                    if (superBound instanceof PsiArrayType && TypesDistinctProver.proveArrayTypeDistinct((PsiArrayType)superBound, type2)) {
                        return true;
                    }
                    PsiClass boundClass1 = PsiUtil.resolveClassInType(superBound);
                    if (boundClass1 == null) {
                        return false;
                    }
                    if (boundClass1 instanceof PsiTypeParameter) {
                        PsiClassType[] extendsListTypes;
                        for (PsiClassType classType : extendsListTypes = boundClass1.getExtendsListTypes()) {
                            PsiClass psiClass = classType.resolve();
                            if (!InheritanceUtil.isInheritorOrSelf(psiClass, psiClass2, true) && !InheritanceUtil.isInheritorOrSelf(psiClass2, psiClass, true)) continue;
                            return false;
                        }
                        return extendsListTypes.length > 0;
                    }
                    return !InheritanceUtil.isInheritorOrSelf(boundClass1, psiClass2, true);
                }
                PsiType bound = ((PsiWildcardType)type1).getBound();
                return bound != null && !bound.equals(type2);
            }
            if (type2 instanceof PsiArrayType) {
                return TypesDistinctProver.proveArrayTypeDistinct((PsiArrayType)type2, type1);
            }
        } else {
            if (type2 instanceof PsiWildcardType) {
                return TypesDistinctProver.provablyDistinct(type2, type1, level);
            }
            if (type1 instanceof PsiCapturedWildcardType) {
                return TypesDistinctProver.provablyDistinct(((PsiCapturedWildcardType)type1).getWildcard(), type2, level);
            }
            if (type2 instanceof PsiCapturedWildcardType) {
                return TypesDistinctProver.provablyDistinct(type2, type1, level);
            }
        }
        PsiClassType.ClassResolveResult classResolveResult1 = PsiUtil.resolveGenericsClassInType(type1);
        PsiClassType.ClassResolveResult classResolveResult2 = PsiUtil.resolveGenericsClassInType(type2);
        PsiClass boundClass1 = classResolveResult1.getElement();
        PsiClass boundClass2 = classResolveResult2.getElement();
        if (boundClass1 instanceof PsiTypeParameter && level < 2 && !TypesDistinctProver.distinguishFromTypeParam((PsiTypeParameter)boundClass1, type1, type2)) {
            return false;
        }
        if (boundClass2 instanceof PsiTypeParameter && level < 2 && !TypesDistinctProver.distinguishFromTypeParam((PsiTypeParameter)boundClass2, type2, type1)) {
            return false;
        }
        if (Comparing.equal((Object)TypeConversionUtil.erasure(type1), (Object)TypeConversionUtil.erasure(type2)) && !(boundClass1 instanceof PsiTypeParameter) && !(boundClass2 instanceof PsiTypeParameter)) {
            PsiSubstitutor substitutor1 = classResolveResult1.getSubstitutor();
            PsiSubstitutor substitutor2 = classResolveResult2.getSubstitutor();
            for (PsiTypeParameter parameter : substitutor1.getSubstitutionMap().keySet()) {
                PsiType substitutedType1 = substitutor1.substitute(parameter);
                PsiType substitutedType2 = substitutor2.substitute(parameter);
                if (substitutedType1 == null && substitutedType2 == null || !(substitutedType1 == null ? type2 instanceof PsiClassType && ((PsiClassType)type2).hasParameters() : (substitutedType2 == null ? type1 instanceof PsiClassType && ((PsiClassType)type1).hasParameters() : TypesDistinctProver.provablyDistinct(substitutedType1, substitutedType2, level + 1)))) continue;
                return true;
            }
            if (level < 2) {
                return false;
            }
        }
        if (boundClass1 == null || boundClass2 == null) {
            return type1 != null && type2 != null && !type1.equals(type2);
        }
        return !(type2 == null || type1 == null || type1.equals(type2) || level == 0 && boundClass1.isInterface() && boundClass2.isInterface() || InheritanceUtil.isInheritorOrSelf(boundClass1, boundClass2, true) && InheritanceUtil.isInheritorOrSelf(boundClass2, boundClass1, true));
    }

    private static boolean distinguishFromTypeParam(PsiTypeParameter typeParam, PsiType type1, PsiType type2) {
        Object[] paramBounds = typeParam.getExtendsListTypes();
        if (paramBounds.length == 0) {
            return !(type1 instanceof PsiClassType);
        }
        return ContainerUtil.exists((Object[])paramBounds, paramBound -> !TypeConversionUtil.isAssignable(paramBound.rawType(), type2));
    }

    public static boolean provablyDistinct(PsiWildcardType type1, PsiWildcardType type2, boolean rejectInconsistentRaw, int level) {
        if (type1.isSuper() && type2.isSuper()) {
            return false;
        }
        if (type1.isExtends() && type2.isExtends()) {
            PsiType extendsBound1 = type1.getExtendsBound();
            PsiType extendsBound2 = type2.getExtendsBound();
            if (extendsBound1 instanceof PsiArrayType && TypesDistinctProver.proveArrayTypeDistinct((PsiArrayType)extendsBound1, extendsBound2) || extendsBound2 instanceof PsiArrayType && TypesDistinctProver.proveArrayTypeDistinct((PsiArrayType)extendsBound2, extendsBound1)) {
                return true;
            }
            PsiClass boundClass1 = PsiUtil.resolveClassInType(extendsBound1);
            PsiClass boundClass2 = PsiUtil.resolveClassInType(extendsBound2);
            if (boundClass1 != null && boundClass2 != null) {
                if (rejectInconsistentRaw && level > 0 && extendsBound1 instanceof PsiClassType && extendsBound2 instanceof PsiClassType && ((PsiClassType)extendsBound1).isRaw() ^ ((PsiClassType)extendsBound2).isRaw()) {
                    return true;
                }
                if (type1.equals(type2)) {
                    return false;
                }
                if (level > 1) {
                    return true;
                }
                return TypesDistinctProver.proveExtendsBoundsDistinct(type1, type2, boundClass1, boundClass2);
            }
            return TypesDistinctProver.provablyDistinct(extendsBound1, extendsBound2, 1);
        }
        if (type2.isExtends()) {
            return TypesDistinctProver.provablyDistinct(type2, type1, rejectInconsistentRaw, level);
        }
        if (type1.isExtends() && !type2.isBounded() && level > 1) {
            PsiType bound = type1.getExtendsBound();
            return bound instanceof PsiClassType || bound instanceof PsiArrayType;
        }
        if (type1.isExtends() && type2.isSuper()) {
            PsiType extendsBound = type1.getExtendsBound();
            PsiType superBound = type2.getSuperBound();
            if (extendsBound instanceof PsiArrayType && TypesDistinctProver.proveArrayTypeDistinct((PsiArrayType)extendsBound, superBound) || superBound instanceof PsiArrayType && TypesDistinctProver.proveArrayTypeDistinct((PsiArrayType)superBound, extendsBound)) {
                return true;
            }
            PsiClass extendsBoundClass = PsiUtil.resolveClassInType(extendsBound);
            PsiClass superBoundClass = PsiUtil.resolveClassInType(superBound);
            if (extendsBoundClass != null && superBoundClass != null) {
                if (extendsBoundClass instanceof PsiTypeParameter) {
                    return TypesDistinctProver.try2ProveTypeParameterDistinct(type2, extendsBoundClass);
                }
                if (superBoundClass instanceof PsiTypeParameter) {
                    return false;
                }
                return !InheritanceUtil.isInheritorOrSelf(superBoundClass, extendsBoundClass, true);
            }
            return TypesDistinctProver.provablyDistinct(extendsBound, superBound);
        }
        if (!type1.isBounded() || !type2.isBounded()) {
            return false;
        }
        return !type1.equals(type2);
    }

    public static boolean proveExtendsBoundsDistinct(PsiType type1, PsiType type2, PsiClass boundClass1, PsiClass boundClass2) {
        if (boundClass1 == null || boundClass2 == null) {
            return false;
        }
        if (boundClass1.isInterface() && boundClass2.isInterface()) {
            return false;
        }
        if (boundClass1.isInterface()) {
            return boundClass2.hasModifierProperty("final") && !InheritanceUtil.isInheritorOrSelf(boundClass2, boundClass1, true);
        }
        if (boundClass2.isInterface()) {
            return boundClass1.hasModifierProperty("final") && !InheritanceUtil.isInheritorOrSelf(boundClass1, boundClass2, true);
        }
        if (boundClass1 instanceof PsiTypeParameter) {
            return TypesDistinctProver.try2ProveTypeParameterDistinct(type2, boundClass1);
        }
        if (boundClass2 instanceof PsiTypeParameter) {
            return TypesDistinctProver.try2ProveTypeParameterDistinct(type1, boundClass2);
        }
        return !InheritanceUtil.isInheritorOrSelf(boundClass1, boundClass2, true) && !InheritanceUtil.isInheritorOrSelf(boundClass2, boundClass1, true);
    }

    public static boolean try2ProveTypeParameterDistinct(PsiType type, PsiClass typeParameter) {
        PsiClassType[] types = typeParameter.getExtendsListTypes();
        if (types.length == 0) {
            return false;
        }
        return TypesDistinctProver.provablyDistinct(PsiWildcardType.createExtends(typeParameter.getManager(), types[0]), type);
    }

    public static boolean proveArrayTypeDistinct(PsiArrayType type, PsiType bound) {
        if (type.getArrayDimensions() == bound.getArrayDimensions()) {
            PsiType componentType = type.getComponentType();
            PsiType boundComponentType = ((PsiArrayType)bound).getComponentType();
            if (boundComponentType instanceof PsiClassType && componentType instanceof PsiClassType) {
                return TypesDistinctProver.proveExtendsBoundsDistinct(boundComponentType, componentType, ((PsiClassType)boundComponentType).resolve(), ((PsiClassType)componentType).resolve());
            }
            return !bound.equals(type);
        }
        if (bound.getArrayDimensions() + 1 == type.getArrayDimensions() && bound.getDeepComponentType() instanceof PsiClassType) {
            return !TypesDistinctProver.isSuperClassOfArrayType(((PsiClassType)bound.getDeepComponentType()).resolve());
        }
        if (bound.getArrayDimensions() == type.getArrayDimensions() + 1 && type.getDeepComponentType() instanceof PsiClassType) {
            return !TypesDistinctProver.isSuperClassOfArrayType(((PsiClassType)type.getDeepComponentType()).resolve());
        }
        if (bound instanceof PsiClassType) {
            return !TypesDistinctProver.isSuperClassOfArrayType(((PsiClassType)bound).resolve());
        }
        if (bound instanceof PsiWildcardType) {
            PsiType boundBound = ((PsiWildcardType)bound).getBound();
            if (boundBound != null && !boundBound.equals(type)) {
                if (boundBound instanceof PsiArrayType && !((PsiWildcardType)bound).isSuper()) {
                    return TypesDistinctProver.proveArrayTypeDistinct(type, boundBound);
                }
                PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(boundBound);
                if (psiClass == null) {
                    return true;
                }
                if (psiClass instanceof PsiTypeParameter) {
                    return TypesDistinctProver.try2ProveTypeParameterDistinct(type, psiClass);
                }
                return !((PsiWildcardType)bound).isExtends() || !TypesDistinctProver.isSuperClassOfArrayType(psiClass);
            }
            return false;
        }
        if (bound instanceof PsiIntersectionType) {
            for (PsiType conjunctBound : ((PsiIntersectionType)bound).getConjuncts()) {
                if (TypesDistinctProver.proveArrayTypeDistinct(type, conjunctBound)) continue;
                return false;
            }
        } else if (bound instanceof PsiCapturedWildcardType) {
            return TypesDistinctProver.proveArrayTypeDistinct(type, ((PsiCapturedWildcardType)bound).getWildcard());
        }
        return true;
    }

    private static boolean isSuperClassOfArrayType(PsiClass psiClass) {
        if (psiClass != null) {
            String qualifiedName = psiClass.getQualifiedName();
            return qualifiedName != null && ARRAY_SUPER_CLASSES.contains(qualifiedName);
        }
        return false;
    }

    static {
        ARRAY_SUPER_CLASSES.add("java.io.Serializable");
        ARRAY_SUPER_CLASSES.add("java.lang.Cloneable");
        ARRAY_SUPER_CLASSES.add("java.lang.Object");
    }
}

