/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebRoot
implements Disposable {
    private final String myRelativePath;
    private final VirtualFilePointer myVirtualFilePointer;

    public WebRoot(@NotNull String url, String relativePath) {
        if (url == null) {
            WebRoot.$$$reportNull$$$0(0);
        }
        this.myRelativePath = WebRoot.normalize(relativePath);
        this.myVirtualFilePointer = VirtualFilePointerManager.getInstance().create(url, (Disposable)this, null);
    }

    public String getRelativePath() {
        return this.myRelativePath;
    }

    public String getDirectoryUrl() {
        return this.myVirtualFilePointer.getUrl();
    }

    @NlsSafe
    public String getPresentableUrl() {
        return this.myVirtualFilePointer.getPresentableUrl();
    }

    public void dispose() {
    }

    @Nullable
    public VirtualFile getFile() {
        return (VirtualFile)ReadAction.compute(() -> ((VirtualFilePointer)this.myVirtualFilePointer).getFile());
    }

    @Deprecated(forRemoval=true)
    public String getURI() {
        return this.myRelativePath;
    }

    private static String normalize(String relativePath) {
        if ((relativePath = FileUtil.toCanonicalPath((String)relativePath)) == null) {
            relativePath = "";
        }
        if (!StringUtil.startsWithChar((CharSequence)(relativePath = StringUtil.trimTrailing((String)relativePath, (char)'/')), (char)'/')) {
            relativePath = "/" + (String)relativePath;
        }
        return relativePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebRoot)) {
            return false;
        }
        WebRoot webRoot = (WebRoot)o;
        return Objects.equals(this.getFile(), webRoot.getFile()) && Objects.equals(this.myRelativePath, webRoot.myRelativePath);
    }

    public int hashCode() {
        VirtualFile file = this.getFile();
        int result = file != null ? file.hashCode() : 0;
        result = 29 * result + (this.myRelativePath != null ? this.myRelativePath.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "WebRoot: ('" + this.myVirtualFilePointer.getPresentableUrl() + "' -> '" + this.myRelativePath + "')";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javaee/web/WebRoot", "<init>"));
    }
}

