/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.dbimport;

import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.remote.dbimport.ExecuteBatchQuery;
import com.intellij.database.remote.dbimport.PreparedBatchQuery;
import com.intellij.database.remote.dbimport.PreparedQuery;
import com.intellij.database.remote.dbimport.Query;
import com.intellij.database.remote.dbimport.QueryWithParameters;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatementImpl;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class ImportQueryGenerator {
    private final List<ColumnInfo> myInfos;
    private final RemoteBatchPreparedStatementImpl myStatement;
    private final RemotePreparedStatement myOneLineStatement;
    private final int myLinesPerStatement;
    private List<ErrorRecord> myErrorRecords;
    private List<PreparedBatchQuery> myBatchQueries;
    private final Consumer<ErrorRecord> myConsumer;
    private final boolean myBatchSupported;

    public ImportQueryGenerator(@NotNull RemoteBatchPreparedStatementImpl statement, @NotNull RemotePreparedStatement oneLineStatement, @NotNull List<ColumnInfo> infos, boolean batchSupported, int linesPerStatement) {
        if (statement == null) {
            ImportQueryGenerator.$$$reportNull$$$0(0);
        }
        if (oneLineStatement == null) {
            ImportQueryGenerator.$$$reportNull$$$0(1);
        }
        if (infos == null) {
            ImportQueryGenerator.$$$reportNull$$$0(2);
        }
        this.myInfos = infos;
        this.myLinesPerStatement = linesPerStatement;
        this.myStatement = statement;
        this.myOneLineStatement = oneLineStatement;
        this.myBatchSupported = batchSupported;
        this.myBatchQueries = new ArrayList<PreparedBatchQuery>();
        this.myErrorRecords = new ArrayList<ErrorRecord>();
        this.myConsumer = record -> this.myErrorRecords.add((ErrorRecord)record);
    }

    @NotNull
    public List<Query> generate(@NotNull String lastSql, @NotNull BatchRecords records) throws SQLException, RemoteException {
        BatchRecords last;
        if (lastSql == null) {
            ImportQueryGenerator.$$$reportNull$$$0(3);
        }
        if (records == null) {
            ImportQueryGenerator.$$$reportNull$$$0(4);
        }
        ArrayList<Query> result = new ArrayList<Query>();
        List<BatchRecords> splitted = records.split(this.myLinesPerStatement);
        for (int i = 0; i < splitted.size() - 1; ++i) {
            this.flush(splitted.get(i), result);
        }
        BatchRecords batchRecords = last = splitted.isEmpty() ? null : splitted.get(splitted.size() - 1);
        if (last == null) {
            throw new IllegalArgumentException("empty records");
        }
        List<Query> list = this.generateLastQueries(result, last, lastSql);
        if (list == null) {
            ImportQueryGenerator.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<ErrorRecord> getErrors() {
        List<ErrorRecord> records = this.myErrorRecords;
        this.myErrorRecords = new ArrayList<ErrorRecord>();
        List<ErrorRecord> list = records;
        if (list == null) {
            ImportQueryGenerator.$$$reportNull$$$0(6);
        }
        return list;
    }

    private void flush(BatchRecords parameters, List<Query> result) {
        if (this.myBatchSupported) {
            PreparedBatchQuery query = (PreparedBatchQuery)this.getQuery(parameters);
            result.add(query);
            this.myBatchQueries.add(query);
            return;
        }
        result.add(this.getQuery(parameters));
    }

    private QueryWithParameters getQuery(BatchRecords currentQueryParameters) {
        return this.myBatchSupported ? new PreparedBatchQuery(currentQueryParameters, this.myStatement, this.myOneLineStatement, this.myConsumer, this.myInfos, this.myBatchQueries) : new PreparedQuery(currentQueryParameters, this.myStatement, this.myOneLineStatement, this.myInfos, this.myConsumer);
    }

    private List<Query> generateLastQueries(@NotNull List<Query> result, @NotNull BatchRecords batch, @NotNull String lastSql) throws SQLException, RemoteException {
        if (result == null) {
            ImportQueryGenerator.$$$reportNull$$$0(7);
        }
        if (batch == null) {
            ImportQueryGenerator.$$$reportNull$$$0(8);
        }
        if (lastSql == null) {
            ImportQueryGenerator.$$$reportNull$$$0(9);
        }
        this.lastBatchQueries(result);
        if (batch.isEmpty()) {
            return result;
        }
        final RemotePreparedStatement statement = this.myStatement.withLines(lastSql, batch.getLinesCount());
        result.add(new PreparedQuery(batch, statement, this.myOneLineStatement, this.myInfos, this.myConsumer){

            @Override
            protected void statementCompleted() throws RemoteException, SQLException {
                super.statementCompleted();
                JdbcNativeUtil.closeRemoteStatementSafe(statement);
            }
        });
        return result;
    }

    private List<Query> lastBatchQueries(List<Query> result) {
        if (this.myBatchQueries.isEmpty()) {
            return result;
        }
        result.add(new ExecuteBatchQuery(this.myBatchQueries, this.myStatement));
        this.myBatchQueries = new ArrayList<PreparedBatchQuery>();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oneLineStatement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastSql";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "records";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/dbimport/ImportQueryGenerator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "batch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/dbimport/ImportQueryGenerator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generateLastQueries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

