/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.intelliLang.inject;

import com.intellij.openapi.util.text.StringUtil;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class JSInjection
extends BaseInjection {
    private boolean myIsFormattable;
    private boolean mySupportsConcatenation;
    private boolean mySuppressAllErrors;
    private Priority myPriority;

    public JSInjection(@NotNull String id) {
        if (id == null) {
            JSInjection.$$$reportNull$$$0(0);
        }
        super(id);
        this.myIsFormattable = true;
        this.myPriority = Priority.Normal;
    }

    public boolean canReformat() {
        return this.myIsFormattable;
    }

    public void setCanReformat(boolean value) {
        this.myIsFormattable = value;
    }

    public Priority getPriority() {
        return this.myPriority;
    }

    public boolean supportsConcatenation() {
        return this.mySupportsConcatenation;
    }

    public void setSupportsConcatenation(boolean value) {
        this.mySupportsConcatenation = value;
    }

    public boolean suppressAllErrors() {
        return this.mySuppressAllErrors;
    }

    protected void readExternalImpl(Element e) {
        String shouldReformatStr;
        String suppressErrorsStr;
        super.readExternalImpl(e);
        String supportsConcatenationStr = e.getAttributeValue("supports-concatenation");
        if (StringUtil.isNotEmpty((String)supportsConcatenationStr)) {
            this.mySupportsConcatenation = Boolean.parseBoolean(supportsConcatenationStr);
        }
        if (StringUtil.isNotEmpty((String)(suppressErrorsStr = e.getAttributeValue("suppress-all-errors")))) {
            this.mySuppressAllErrors = Boolean.parseBoolean(suppressErrorsStr);
        }
        if (StringUtil.isNotEmpty((String)(shouldReformatStr = e.getAttributeValue("is-formattable")))) {
            this.myIsFormattable = Boolean.parseBoolean(shouldReformatStr);
        }
        this.myPriority = (Priority)StringUtil.parseEnum((String)StringUtil.notNullize((String)e.getAttributeValue("priority")), (Enum)Priority.Normal, Priority.class);
    }

    public JSInjection copy() {
        return new JSInjection(this.getSupportId()).copyFrom(this);
    }

    public JSInjection copyFrom(@NotNull BaseInjection other) {
        JSInjection otherJsInjection;
        if (other == null) {
            JSInjection.$$$reportNull$$$0(1);
        }
        super.copyFrom(other);
        JSInjection jSInjection = otherJsInjection = other instanceof JSInjection ? (JSInjection)other : null;
        if (otherJsInjection != null) {
            this.myIsFormattable = otherJsInjection.myIsFormattable;
            this.mySupportsConcatenation = otherJsInjection.mySupportsConcatenation;
            this.mySuppressAllErrors = otherJsInjection.mySuppressAllErrors;
        }
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        objectArray2[1] = "com/intellij/plugins/intelliLang/inject/JSInjection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "copyFrom";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @ApiStatus.Internal
    public static enum Priority {
        Normal,
        Low;

    }
}

