/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.rename;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.refactoring.rename.JSInplaceRenameHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessorBase;
import com.intellij.refactoring.rename.RenameRefactoringDialog;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J$\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/lang/javascript/refactoring/rename/JSShorthandPropertyRenameHandler;", "Lcom/intellij/refactoring/rename/inplace/VariableInplaceRenameHandler;", "<init>", "()V", "isAvailable", "", "element", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "performDialogRename", "", "elementToRename", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "doRename", "Lcom/intellij/refactoring/rename/inplace/InplaceRefactoring;", "intellij.javascript.backend"})
public final class JSShorthandPropertyRenameHandler
extends VariableInplaceRenameHandler {
    protected boolean isAvailable(@Nullable PsiElement element2, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return editor.getSettings().isVariableInplaceRenameEnabled() && element2 instanceof JSProperty && ((JSProperty)element2).isShorthanded() && JSInplaceRenameHandler.isValidContext(editor, file);
    }

    private final void performDialogRename(PsiElement elementToRename, Editor editor, DataContext dataContext) {
        Object suggestedNames;
        PsiFile topLevelFile;
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)elementToRename.getProject());
        PsiElement psiElement = injectedLanguageManager.findInjectedElementAt(topLevelFile = injectedLanguageManager.getTopLevelFile((PsiElement)elementToRename.getContainingFile()), editor.getCaretModel().getOffset());
        if (psiElement == null) {
            psiElement = elementToRename;
        }
        PsiElement nameSuggestionContext = psiElement;
        RenamePsiElementProcessorBase renamePsiElementProcessorBase = RenamePsiElementProcessorBase.forPsiElement((PsiElement)elementToRename);
        Intrinsics.checkNotNullExpressionValue((Object)renamePsiElementProcessorBase, (String)"forPsiElement(...)");
        RenamePsiElementProcessorBase processor = renamePsiElementProcessorBase;
        RenameRefactoringDialog dialog = processor.createDialog(elementToRename.getProject(), elementToRename, nameSuggestionContext, editor);
        Object object = dataContext;
        if (object == null || (object = (List)object.getData(PsiElementRenameHandler.NAME_SUGGESTIONS)) == null) {
            object = suggestedNames = CollectionsKt.emptyList();
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String newName;
            DataContext dataContext2 = dataContext;
            String string = newName = dataContext2 != null ? (String)dataContext2.getData(PsiElementRenameHandler.DEFAULT_NAME) : null;
            if (newName == null) {
                dialog.close();
                return;
            }
            dialog.performRename(newName);
            return;
        }
        dialog.addSuggestedNames((Collection)suggestedNames);
        dialog.show();
    }

    @Nullable
    public InplaceRefactoring doRename(@NotNull PsiElement elementToRename, @NotNull Editor editor, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)elementToRename, (String)"elementToRename");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        RenamePsiElementProcessor renamePsiElementProcessor = RenamePsiElementProcessor.forElement((PsiElement)elementToRename);
        Intrinsics.checkNotNullExpressionValue((Object)renamePsiElementProcessor, (String)"forElement(...)");
        RenamePsiElementProcessor processor = renamePsiElementProcessor;
        Pass pass = Pass.create(arg_0 -> JSShorthandPropertyRenameHandler.doRename$lambda$1(arg_0 -> JSShorthandPropertyRenameHandler.doRename$lambda$0(this, editor, dataContext, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)pass, (String)"create(...)");
        Pass renameCallback = pass;
        processor.substituteElementToRename(elementToRename, editor, renameCallback);
        return null;
    }

    private static final Unit doRename$lambda$0(JSShorthandPropertyRenameHandler this$0, Editor $editor, DataContext $dataContext, PsiElement substituted) {
        if (substituted != null) {
            this$0.performDialogRename(substituted, $editor, $dataContext);
        }
        return Unit.INSTANCE;
    }

    private static final void doRename$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

