/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.javascript.nodejs.ForRequireModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.JSNodeModuleStructure;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.Comparator;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeModuleUtil {
    @NonNls
    public static final String NODE_MODULES = "node_modules";
    public static final Comparator<VirtualFile> VIRTUAL_FILE_COMPARATOR = (o1, o2) -> {
        int cnt2;
        String path1 = o1.getPath();
        String path2 = o2.getPath();
        int cnt1 = StringUtil.countChars((CharSequence)path1, (char)'/');
        if (cnt1 != (cnt2 = StringUtil.countChars((CharSequence)path2, (char)'/'))) {
            return cnt1 - cnt2;
        }
        return path1.compareTo(path2);
    };
    private static final Key<CachedValue<VirtualFile>> ourModuleRoot = Key.create((String)"NodeJs.Current.Module.Root");

    @Nullable
    public static ForRequireModuleInfo getRequireModuleInfo(@NotNull Project project, @NotNull VirtualFile mainModuleRoot, @NotNull VirtualFile targetFile) {
        VirtualFile current;
        if (project == null) {
            NodeModuleUtil.$$$reportNull$$$0(0);
        }
        if (mainModuleRoot == null) {
            NodeModuleUtil.$$$reportNull$$$0(1);
        }
        if (targetFile == null) {
            NodeModuleUtil.$$$reportNull$$$0(2);
        }
        if (VfsUtilCore.isAncestor((VirtualFile)mainModuleRoot, (VirtualFile)targetFile, (boolean)true)) {
            JSNodeModuleStructure structure = JSNodeModuleStructure.getStructure(project, targetFile);
            if (structure == null) {
                Pair<Boolean, NodeModuleSearchUtil.ModuleMainFiles> info = NodeModuleSearchUtil.findMainModuleInPackage(mainModuleRoot);
                return new ForRequireModuleInfo(targetFile, (NodeModuleSearchUtil.ModuleMainFiles)info.getSecond(), ModuleType.EXACT_PATH);
            }
            return NodeModuleUtil.addFromChildModule(targetFile, structure.moduleDirectory);
        }
        VirtualFile baseDir = project.getBaseDir();
        VirtualFile moduleRoot = NodeModuleUtil.findModuleRoot(baseDir, current = targetFile.getParent());
        if (moduleRoot == null) {
            return null;
        }
        return NodeModuleUtil.addFromChildModule(targetFile, moduleRoot);
    }

    @NotNull
    private static ForRequireModuleInfo addFromChildModule(VirtualFile targetFile, VirtualFile moduleRoot) {
        Pair<Boolean, NodeModuleSearchUtil.ModuleMainFiles> info = NodeModuleSearchUtil.findMainModuleInPackage(moduleRoot);
        return new ForRequireModuleInfo(targetFile, (NodeModuleSearchUtil.ModuleMainFiles)info.getSecond(), ModuleType.NODE_MODULES_DIR);
    }

    @Nullable
    private static VirtualFile findModuleRoot(@NotNull VirtualFile baseDir, @Nullable VirtualFile current) {
        if (baseDir == null) {
            NodeModuleUtil.$$$reportNull$$$0(3);
        }
        VirtualFile moduleRoot = null;
        while (current != null && !baseDir.equals(current)) {
            if (current.getParent() != null && NODE_MODULES.equals(current.getParent().getName())) {
                moduleRoot = current;
                break;
            }
            current = current.getParent();
        }
        return moduleRoot;
    }

    @Nullable
    public static VirtualFile getMainModuleRoot(@NotNull PsiElement context2) {
        PsiFile file;
        if (context2 == null) {
            NodeModuleUtil.$$$reportNull$$$0(4);
        }
        if ((file = JSResolveUtil.getOriginalFile((PsiElement)context2)) == null) {
            return null;
        }
        return (VirtualFile)CachedValuesManager.getCachedValue((PsiElement)file, ourModuleRoot, () -> CachedValueProvider.Result.create((Object)NodeModuleUtil.findMainModuleRoot(file.getProject(), file.getVirtualFile()), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    public static VirtualFile findMainModuleRoot(Project project, VirtualFile file) {
        if (file == null) {
            return null;
        }
        VirtualFile contentRoot = JSLibraryUtil.getContentRootForFile((Project)project, (VirtualFile)file);
        if (contentRoot == null) {
            return null;
        }
        VirtualFile packageJson = JSLibraryUtil.findConfigFile((VirtualFile)file, (String)"package.json");
        return packageJson != null ? packageJson.getParent() : (VirtualFile)ObjectUtils.coalesce((Object)contentRoot, (Object)project.getBaseDir());
    }

    @Nullable
    public static VirtualFile findParentContentRoot(Project project, VirtualFile file) {
        return ProjectFileIndex.getInstance((Project)project).getContentRootForFile(file);
    }

    public static boolean isWrappedInAmdDefinition(@NotNull PsiElement element2) {
        if (element2 == null) {
            NodeModuleUtil.$$$reportNull$$$0(5);
        }
        return JSAmdUtil.getCachedWrappingAmdDefinition(element2) != null;
    }

    public static boolean isResolvedGloballyCommonJS(@NotNull ResolveResult result2, @NotNull Set<VirtualFile> predefinedFiles) {
        if (result2 == null) {
            NodeModuleUtil.$$$reportNull$$$0(6);
        }
        if (predefinedFiles == null) {
            NodeModuleUtil.$$$reportNull$$$0(7);
        }
        if (!result2.isValidResult()) {
            return false;
        }
        PsiElement element2 = result2.getElement();
        if (element2 == null) {
            return false;
        }
        PsiFile file = element2.getContainingFile();
        if (file == null) {
            return true;
        }
        PsiElement module = ES6PsiUtil.findExternalModule((PsiElement)element2);
        if (module == null && file instanceof JSModuleStatusOwner && ((JSModuleStatusOwner)file).getModuleStatus() == JSModuleStatusOwner.ModuleStatus.NONE) {
            return true;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element2);
        return predefinedFiles.contains(virtualFile) || NodeModuleUtil.isResolvedGloballyForNode(result2) || NodeModuleUtil.isResolvedGloballyForFlowOrTypeScript(result2);
    }

    public static boolean isResolvedGloballyForNode(@NotNull ResolveResult result2) {
        JSQualifiedName qualifier;
        if (result2 == null) {
            NodeModuleUtil.$$$reportNull$$$0(8);
        }
        return result2.getElement() != null && result2.getElement() instanceof JSDefinitionExpression && (qualifier = ((JSDefinitionExpression)result2.getElement()).getNamespace()) != null && "global".equals(qualifier.getName());
    }

    private static boolean isResolvedGloballyForFlowOrTypeScript(@NotNull ResolveResult result2) {
        JSAttributeList attributeList;
        DialectOptionHolder holder;
        PsiElement element2;
        if (result2 == null) {
            NodeModuleUtil.$$$reportNull$$$0(9);
        }
        return (element2 = result2.getElement()) instanceof JSAttributeListOwner && (holder = DialectDetector.dialectOfElement((PsiElement)element2)) != null && (holder.isFlow || holder.isTypeScript) && JSUseScopeProvider.getLexicalScopeOrFile((PsiElement)element2) instanceof JSFile && (attributeList = ((JSAttributeListOwner)element2).getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.DECLARE);
    }

    public static boolean hasNodeModulesInPath(@NotNull PsiElement element2) {
        VirtualFile file;
        if (element2 == null) {
            NodeModuleUtil.$$$reportNull$$$0(10);
        }
        return (file = PsiUtilCore.getVirtualFile((PsiElement)element2)) != null && NodeModuleUtil.hasNodeModulesDirInPath(file, null);
    }

    public static boolean hasNodeModulesDirInPath(@NotNull VirtualFile file, @Nullable VirtualFile fileToStop) {
        if (file == null) {
            NodeModuleUtil.$$$reportNull$$$0(11);
        }
        return JSLibraryUtil.hasDirectoryInPath((VirtualFile)file, (String)NODE_MODULES, (VirtualFile)fileToStop);
    }

    @Nullable
    public static VirtualFile findNodeModulesByPackageJson(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            NodeModuleUtil.$$$reportNull$$$0(12);
        }
        return NodeModuleUtil.findChildNodeModulesDir(packageJson.isDirectory() ? null : packageJson.getParent());
    }

    @Contract(value="null -> null")
    @Nullable
    public static VirtualFile findChildNodeModulesDir(@Nullable VirtualFile parent) {
        VirtualFile nodeModulesDir;
        if (parent != null && parent.isDirectory() && parent.isValid() && (nodeModulesDir = parent.findChild(NODE_MODULES)) != null && nodeModulesDir.isDirectory() && nodeModulesDir.isValid()) {
            return nodeModulesDir;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static VirtualFile findPackageJsonByNodeModules(@Nullable VirtualFile nodeModulesDir) {
        VirtualFile parent;
        VirtualFile virtualFile = parent = nodeModulesDir != null && nodeModulesDir.isDirectory() ? nodeModulesDir.getParent() : null;
        if (parent != null) {
            return PackageJsonUtil.findChildPackageJsonFile(parent);
        }
        return null;
    }

    @Nullable
    public static VirtualFile findUpClosestNodeModulesResolveRoot(@NotNull VirtualFile file) {
        if (file == null) {
            NodeModuleUtil.$$$reportNull$$$0(13);
        }
        return JSLibraryUtil.findUpClosestNodeModulesResolveRoot((VirtualFile)file);
    }

    public static boolean moduleNotInPackageJson(@NotNull String name, @NotNull VirtualFile packageJsonFile) {
        PackageJsonData data2;
        if (name == null) {
            NodeModuleUtil.$$$reportNull$$$0(14);
        }
        if (packageJsonFile == null) {
            NodeModuleUtil.$$$reportNull$$$0(15);
        }
        return !(data2 = PackageJsonData.getOrCreate(packageJsonFile)).isDependencyOfAnyType(name);
    }

    @Nullable
    public static String inferNodeModulePackageName(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            NodeModuleUtil.$$$reportNull$$$0(16);
        }
        VirtualFile parent = packageJson.getParent();
        Object packageName = null;
        for (int depth = 0; depth < 3 && parent != null && !NodeModulesDirectoryManager.isNodeModulesDir(parent); parent = parent.getParent(), ++depth) {
            if (depth == 0) {
                packageName = parent.getName();
                continue;
            }
            if (depth == 1 && NodeModuleSearchUtil.isScopeDir(parent)) {
                packageName = parent.getName() + "/" + (String)packageName;
                continue;
            }
            return null;
        }
        return parent != null ? packageName : null;
    }

    @Contract(value="null -> false")
    public static boolean isTypesDir(@Nullable VirtualFile dir) {
        return dir != null && dir.isDirectory() && StringUtil.equals((CharSequence)"@types", (CharSequence)dir.getNameSequence());
    }

    @Contract(value="null -> false")
    public static boolean isNodeModules(@Nullable VirtualFile dir) {
        return dir != null && dir.isDirectory() && StringUtil.equals((CharSequence)NODE_MODULES, (CharSequence)dir.getNameSequence());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainModuleRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedFiles";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/modules/NodeModuleUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRequireModuleInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findModuleRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getMainModuleRoot";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isWrappedInAmdDefinition";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isResolvedGloballyCommonJS";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isResolvedGloballyForNode";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isResolvedGloballyForFlowOrTypeScript";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNodeModulesInPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNodeModulesDirInPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "findNodeModulesByPackageJson";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "findUpClosestNodeModulesResolveRoot";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "moduleNotInPackageJson";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "inferNodeModulePackageName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

