/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.git4idea.PackageJsonGitService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\b\u0002\u0010\u0015\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0018\u00010\u0016H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/lang/javascript/buildTools/npm/PackageJsonFileTemplate;", "", "<init>", "()V", "TEMPLATE_NAME", "", "DEFAULT_PACKAGE_MAIN", "FALLBACK_PACKAGE_MAIN", "suggestPackageName", "dir", "Lcom/intellij/openapi/vfs/VirtualFile;", "suggestPackageMain", "suggestGitRepositoryOriginUrl", "project", "Lcom/intellij/openapi/project/Project;", "create", "", "psiDir", "Lcom/intellij/psi/PsiDirectory;", "openFile", "", "consumer", "Ljava/util/function/Consumer;", "Lcom/intellij/psi/PsiFile;", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nPackageJsonFileTemplate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageJsonFileTemplate.kt\ncom/intellij/lang/javascript/buildTools/npm/PackageJsonFileTemplate\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,124:1\n183#2,2:125\n*S KotlinDebug\n*F\n+ 1 PackageJsonFileTemplate.kt\ncom/intellij/lang/javascript/buildTools/npm/PackageJsonFileTemplate\n*L\n50#1:125,2\n*E\n"})
public final class PackageJsonFileTemplate {
    @NotNull
    public static final PackageJsonFileTemplate INSTANCE = new PackageJsonFileTemplate();
    @NotNull
    private static final String TEMPLATE_NAME = "package.json";
    @NotNull
    private static final String DEFAULT_PACKAGE_MAIN = "index.js";
    @NotNull
    private static final String FALLBACK_PACKAGE_MAIN = "main.js";

    private PackageJsonFileTemplate() {
    }

    private final String suggestPackageName(VirtualFile dir) {
        String string = dir.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex("^node-|[.-]js$");
        String string2 = "";
        charSequence = regex.replace(charSequence, string2);
        regex = new Regex("\\s+");
        string2 = "-";
        String string3 = regex.replace(charSequence, string2).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return string3;
    }

    private final String suggestPackageMain(VirtualFile dir) {
        String firstJsFileName;
        String string;
        Object v1;
        block5: {
            if (dir.findChild(DEFAULT_PACKAGE_MAIN) != null) {
                return DEFAULT_PACKAGE_MAIN;
            }
            if (dir.findChild(FALLBACK_PACKAGE_MAIN) != null) {
                return FALLBACK_PACKAGE_MAIN;
            }
            String basenameMain = dir.getName() + ".js";
            if (dir.findChild(basenameMain) != null) {
                return basenameMain;
            }
            VirtualFile[] virtualFileArray = dir.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])virtualFileArray), PackageJsonFileTemplate::suggestPackageMain$lambda$0);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!StringsKt.endsWith$default((String)it, (String)".js", (boolean)false, (int)2, null)) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        if ((string = (firstJsFileName = (String)v1)) == null) {
            string = DEFAULT_PACKAGE_MAIN;
        }
        return string;
    }

    private final String suggestGitRepositoryOriginUrl(Project project, VirtualFile dir) {
        String string;
        String originUrl = null;
        PackageJsonGitService service = (PackageJsonGitService)ApplicationManager.getApplication().getService(PackageJsonGitService.class);
        if (service != null) {
            originUrl = service.getDirOriginUrl(project, dir);
        }
        String string2 = originUrl;
        if (string2 != null) {
            CharSequence charSequence = string2;
            Regex regex = new Regex("^" + Regex.Companion.escape("git@github.com:"));
            String string3 = "https://github.com/";
            string = regex.replaceFirst(charSequence, string3);
        } else {
            string = null;
        }
        return string;
    }

    @JvmStatic
    @JvmOverloads
    public static final void create(@NotNull PsiDirectory psiDir, boolean openFile, @Nullable Consumer<PsiFile> consumer) {
        Intrinsics.checkNotNullParameter((Object)psiDir, (String)"psiDir");
        VirtualFile virtualFile = psiDir.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        VirtualFile dir = virtualFile;
        Project project = psiDir.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> PackageJsonFileTemplate.create$lambda$0(dir, project2, psiDir, openFile, consumer), JavaScriptBundle.message((String)"action.NewPackageJsonFile.text", (Object[])new Object[0]), true, psiDir.getProject());
    }

    public static /* synthetic */ void create$default(PsiDirectory psiDirectory, boolean bl, Consumer consumer, int n, Object object) {
        if ((n & 4) != 0) {
            consumer = null;
        }
        PackageJsonFileTemplate.create(psiDirectory, bl, consumer);
    }

    @JvmStatic
    @JvmOverloads
    public static final void create(@NotNull PsiDirectory psiDir, boolean openFile) {
        Intrinsics.checkNotNullParameter((Object)psiDir, (String)"psiDir");
        PackageJsonFileTemplate.create$default(psiDir, openFile, null, 4, null);
    }

    private static final String suggestPackageMain$lambda$0(VirtualFile it) {
        return it.getName();
    }

    private static final void create$lambda$0(VirtualFile $dir, Project $project, PsiDirectory $psiDir, boolean $openFile, Consumer $consumer) {
        Map map2;
        Map map3;
        String packageName = INSTANCE.suggestPackageName($dir);
        String packageMain = INSTANCE.suggestPackageMain($dir);
        String gitRepositoryUrl = INSTANCE.suggestGitRepositoryOriginUrl($project, $dir);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)packageName), TuplesKt.to((Object)"version", (Object)"1.0.0"), TuplesKt.to((Object)"main", (Object)packageMain)};
        Map liveTemplateValues = MapsKt.mapOf((Pair[])pairArray);
        String string = gitRepositoryUrl;
        if (string != null) {
            String it = string;
            boolean bl = false;
            map3 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"GIT_REPOSITORY_URL", (Object)gitRepositoryUrl));
        } else {
            map3 = map2 = null;
        }
        if (map3 == null) {
            map2 = MapsKt.emptyMap();
        }
        Map extraTemplateProperties = map2;
        ProgressManager.checkCanceled();
        ApplicationManager.getApplication().invokeLater(() -> PackageJsonFileTemplate.create$lambda$0$1($psiDir, $openFile, liveTemplateValues, extraTemplateProperties, $consumer), ModalityState.nonModal());
    }

    private static final void create$lambda$0$1(PsiDirectory $psiDir, boolean $openFile, Map $liveTemplateValues, Map $extraTemplateProperties, Consumer $consumer) {
        block2: {
            FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)$psiDir.getProject()).getInternalTemplate(TEMPLATE_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getInternalTemplate(...)");
            FileTemplate template = fileTemplate;
            if (!$openFile) {
                String string = template.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String text = string;
                for (Map.Entry entry : $liveTemplateValues.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    text = StringsKt.replace$default((String)text, (String)("#[[$" + key + "$]]#"), (String)value, (boolean)false, (int)4, null);
                }
                FileTemplate fileTemplate2 = template.clone();
                Intrinsics.checkNotNullExpressionValue((Object)fileTemplate2, (String)"clone(...)");
                template = fileTemplate2;
                template.setText(StringsKt.replace$default((String)text, (String)"#[[$END$]]#", (String)"", (boolean)false, (int)4, null));
            }
            PsiFile json = CreateFileFromTemplateAction.createFileFromTemplate((String)TEMPLATE_NAME, (FileTemplate)template, (PsiDirectory)$psiDir, null, (boolean)$openFile, (Map)$liveTemplateValues, (Map)$extraTemplateProperties);
            Consumer consumer = $consumer;
            if (consumer == null) break block2;
            consumer.accept(json);
        }
    }
}

