/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.ProjectFileIndexSupport;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.CompositeRootCollection;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleJdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J>\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u001c2\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u001cH\u0016J%\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/lang/javascript/BackendProjectFileIndexSupport;", "Lcom/intellij/lang/javascript/ProjectFileIndexSupport;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "isInContent", "", "fileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "isInSource", "isInLibrary", "isInLibrarySource", "isInLibraryClasses", "isInSourceContent", "getSourceRootForFile", "file", "getContentRootForFile", "honorExclusion", "findLibraryName", "Lcom/intellij/lang/javascript/ProjectFileIndexSupport$LibraryNameResult;", "findNavigatableElementForLibraryClass", "Lcom/intellij/psi/PsiElement;", "jsClass", "Lcom/intellij/lang/javascript/psi/ecmal4/JSQualifiedNamedElement;", "pathHandler", "Lkotlin/Function1;", "fallbackPathHandler", "getSourceRoots", "", "orderEntry", "Lcom/intellij/openapi/roots/OrderEntry;", "vFile", "(Lcom/intellij/openapi/roots/OrderEntry;Lcom/intellij/openapi/vfs/VirtualFile;)[Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.javascript.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nBackendProjectFileIndexSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendProjectFileIndexSupport.kt\ncom/intellij/lang/javascript/BackendProjectFileIndexSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1#2:134\n*E\n"})
public final class BackendProjectFileIndexSupport
implements ProjectFileIndexSupport {
    @NotNull
    private final ProjectFileIndex fileIndex;

    public BackendProjectFileIndexSupport(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        this.fileIndex = projectFileIndex;
    }

    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        return this.fileIndex.isInContent(fileOrDir);
    }

    public boolean isInSource(@NotNull VirtualFile fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        return this.fileIndex.isInSource(fileOrDir);
    }

    public boolean isInLibrary(@NotNull VirtualFile fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        return this.fileIndex.isInLibrary(fileOrDir);
    }

    public boolean isInLibrarySource(@NotNull VirtualFile fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        return this.fileIndex.isInLibrarySource(fileOrDir);
    }

    public boolean isInLibraryClasses(@NotNull VirtualFile fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        return this.fileIndex.isInLibraryClasses(fileOrDir);
    }

    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        return this.fileIndex.isInSourceContent(fileOrDir);
    }

    @Nullable
    public VirtualFile getSourceRootForFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.fileIndex.getSourceRootForFile(file);
    }

    @Nullable
    public VirtualFile getContentRootForFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.fileIndex.getContentRootForFile(file);
    }

    @Nullable
    public VirtualFile getContentRootForFile(@NotNull VirtualFile file, boolean honorExclusion) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.fileIndex.getContentRootForFile(file, honorExclusion);
    }

    @NotNull
    public ProjectFileIndexSupport.LibraryNameResult findLibraryName(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile file2 = file;
        boolean isFromLibrary = false;
        if (this.fileIndex.isInLibrary(file2)) {
            List list = this.fileIndex.getOrderEntriesForFile(file2);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOrderEntriesForFile(...)");
            List entriesForFile = list;
            int n = ((Collection)entriesForFile).size();
            for (int i = 0; i < n; ++i) {
                OrderEntry entry = (OrderEntry)entriesForFile.get(i);
                String s = null;
                OrderEntry orderEntry = entry;
                if (orderEntry instanceof LibraryOrderEntry) {
                    s = ((LibraryOrderEntry)entry).getPresentableName();
                    int lastSlash = StringsKt.lastIndexOf$default((CharSequence)s, (char)File.separatorChar, (int)0, (boolean)false, (int)6, null);
                    if (lastSlash != -1) {
                        String string = s.substring(lastSlash + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        s = string;
                    }
                } else if (orderEntry instanceof JdkOrderEntry) {
                    Sdk sdk = ((JdkOrderEntry)entry).getJdk();
                    String string = s = sdk instanceof CompositeRootCollection ? ((CompositeRootCollection)sdk).getName(file2) : ((JdkOrderEntry)entry).getJdkName();
                }
                if (s == null) continue;
                return new ProjectFileIndexSupport.LibraryNameResult(s, null, false);
            }
            VirtualFile virtualFile = JSItemPresentation.getNameOfPhysicalFile((VirtualFile)file2);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getNameOfPhysicalFile(...)");
            file2 = virtualFile;
            isFromLibrary = true;
        }
        return new ProjectFileIndexSupport.LibraryNameResult(null, file2, isFromLibrary);
    }

    @Nullable
    public PsiElement findNavigatableElementForLibraryClass(@NotNull JSQualifiedNamedElement jsClass, @NotNull Function1<? super VirtualFile, ? extends PsiElement> pathHandler, @NotNull Function1<? super VirtualFile, ? extends PsiElement> fallbackPathHandler) {
        Intrinsics.checkNotNullParameter((Object)jsClass, (String)"jsClass");
        Intrinsics.checkNotNullParameter(pathHandler, (String)"pathHandler");
        Intrinsics.checkNotNullParameter(fallbackPathHandler, (String)"fallbackPathHandler");
        PsiFile psiFile = jsClass.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        PsiFile containingFile = psiFile;
        VirtualFile vFile = containingFile.getVirtualFile();
        if (vFile == null || this.fileIndex.getClassRootForFile(vFile) == null) {
            return null;
        }
        List list = this.fileIndex.getOrderEntriesForFile(vFile);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOrderEntriesForFile(...)");
        List orderEntries = list;
        String qName = jsClass.getQualifiedName();
        String baseSourceName = jsClass.getName();
        String string = qName;
        String packageName = string == null ? null : StringUtil.getPackageName((String)string);
        CharSequence charSequence = packageName;
        Object relativeFilePath = charSequence == null || charSequence.length() == 0 ? baseSourceName : StringsKt.replace$default((String)packageName, (char)'.', (char)'/', (boolean)false, (int)4, null) + "/" + baseSourceName;
        String relativeFilePath2 = (String)relativeFilePath + ".mxml";
        String relativeFilePath4 = (String)relativeFilePath + ".fxg";
        relativeFilePath = (String)relativeFilePath + ".as";
        for (OrderEntry orderEntry : orderEntries) {
            Intrinsics.checkNotNull((Object)orderEntry);
            for (VirtualFile file : this.getSourceRoots(orderEntry, vFile)) {
                PsiElement psiElement;
                VirtualFile source = file.findFileByRelativePath((String)relativeFilePath);
                if (source != null) {
                    psiElement = (PsiElement)pathHandler.invoke((Object)source);
                    if (psiElement == null) continue;
                    PsiElement it = psiElement;
                    boolean bl = false;
                    return it;
                }
                VirtualFile virtualFile = file.findFileByRelativePath(relativeFilePath2);
                if (virtualFile == null) {
                    virtualFile = file.findFileByRelativePath(relativeFilePath4);
                }
                if ((source = virtualFile) == null || (psiElement = (PsiElement)fallbackPathHandler.invoke((Object)source)) == null) continue;
                PsiElement it = psiElement;
                boolean bl = false;
                return it;
            }
        }
        return null;
    }

    private final VirtualFile[] getSourceRoots(OrderEntry orderEntry, VirtualFile vFile) {
        if (orderEntry instanceof ModuleJdkOrderEntry) {
            Sdk sdk = ((ModuleJdkOrderEntry)orderEntry).getJdk();
            if (sdk == null) {
                Intrinsics.checkNotNullExpressionValue((Object)VirtualFile.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return VirtualFile.EMPTY_ARRAY;
            }
            if (sdk instanceof CompositeRootCollection) {
                VirtualFile[] virtualFileArray = ((CompositeRootCollection)sdk).getFiles(OrderRootType.SOURCES, vFile);
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
                return virtualFileArray;
            }
        }
        VirtualFile[] virtualFileArray = orderEntry.getFiles(OrderRootType.SOURCES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        return virtualFileArray;
    }
}

