/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.fus;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.fus.NodeInterpreterAndPackageManagerStateUsagesCollectorKt;
import com.intellij.javascript.nodejs.interpreter.fus.NodeInterpreterTypeValidator;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/javascript/nodejs/interpreter/fus/NodeInterpreterAndPackageManagerCounterUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "interpreterTypeField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "interpreterEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "", "Lcom/intellij/openapi/util/Version;", "nvmrcEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "packageManagerNameField", "packageManagerResolvedField", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "packageManagerEvent", "getGroup", "triggerOnProjectStartup", "", "project", "Lcom/intellij/openapi/project/Project;", "hasYarnLock", "intellij.javascript.backend"})
public final class NodeInterpreterAndPackageManagerCounterUsagesCollector
extends CounterUsagesCollector {
    @NotNull
    public static final NodeInterpreterAndPackageManagerCounterUsagesCollector INSTANCE = new NodeInterpreterAndPackageManagerCounterUsagesCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("node.js.interpreter.and.package.manager.on.startup", 2, null, 4, null);
    @NotNull
    private static final StringEventField interpreterTypeField = EventFields.StringValidatedByCustomRule((String)"type", NodeInterpreterTypeValidator.class);
    @NotNull
    private static final EventId3<Boolean, String, Version> interpreterEvent = GROUP.registerEvent("interpreter", (EventField)EventFields.Boolean((String)"is_node_from_path"), (EventField)interpreterTypeField, (EventField)EventFields.VersionByObject);
    @NotNull
    private static final EventId1<Boolean> nvmrcEvent = GROUP.registerEvent("nvmrc", (EventField)EventFields.Boolean((String)"nvmrc_version_installed"));
    @NotNull
    private static final StringEventField packageManagerNameField = EventFields.String((String)"name", NodeInterpreterAndPackageManagerStateUsagesCollectorKt.getPACKAGE_MANAGERS());
    @NotNull
    private static final BooleanEventField packageManagerResolvedField = EventFields.Boolean((String)"resolved");
    @NotNull
    private static final EventId3<String, Boolean, Boolean> packageManagerEvent = GROUP.registerEvent("package.manager", (EventField)packageManagerNameField, (EventField)packageManagerResolvedField, (EventField)EventFields.Boolean((String)"yarn_lock"));

    private NodeInterpreterAndPackageManagerCounterUsagesCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    public final void triggerOnProjectStartup(@NotNull Project project) {
        NodeJsInterpreter interpreter2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterManager.getInstance(project).getInterpreterRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreterRef, (String)"getInterpreterRef(...)");
        NodeJsInterpreterRef interpreterRef = nodeJsInterpreterRef;
        NodeJsInterpreter nodeJsInterpreter = interpreter2 = interpreterRef.resolve(project);
        SemVer interpreterVersion = nodeJsInterpreter != null ? NodeInterpreterAndPackageManagerStateUsagesCollectorKt.getVersionSync(nodeJsInterpreter, project) : null;
        interpreterEvent.log(project, (Object)NodeJsLocalInterpreterType.isNodeFromPathRef(interpreterRef), (Object)NodeInterpreterAndPackageManagerStateUsagesCollectorKt.getTypeId(interpreter2), (Object)NodeInterpreterAndPackageManagerStateUsagesCollectorKt.toVersion(interpreterVersion));
        NodeJsLocalInterpreterManager.NodeVersionFileInfo nvmrcFileInfo = NodeJsLocalInterpreterManager.findNodeVersionFileInfo(project);
        if (nvmrcFileInfo != null) {
            NodeJsLocalInterpreter nvmrcInterpreter = NodeJsLocalInterpreterManager.resolveNvmRcInterpreter(nvmrcFileInfo.getFileContent(), 0);
            nvmrcEvent.log(project, (Object)(nvmrcInterpreter != null ? 1 : 0));
        }
        NpmManager npmManager = NpmManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)npmManager, (String)"getInstance(...)");
        NpmManager npmManager2 = npmManager;
        NodePackageRef nodePackageRef = npmManager2.getPackageRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodePackageRef, (String)"getPackageRef(...)");
        String packageManagerName = NodeInterpreterAndPackageManagerStateUsagesCollectorKt.getPackageManagerName(nodePackageRef);
        NodePackage packageManagerPkg = npmManager2.getPackage(interpreter2);
        boolean yarnLock = this.hasYarnLock(project);
        packageManagerEvent.log(project, (Object)packageManagerName, (Object)(packageManagerPkg != null ? 1 : 0), (Object)yarnLock);
    }

    private final boolean hasYarnLock(Project project) {
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile projectDir = virtualFile;
        VirtualFile yarnLockFile = projectDir.findChild("yarn.lock");
        return yarnLockFile != null && !yarnLockFile.isDirectory();
    }
}

