/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aqua.runners.cypress;

import com.intellij.aqua.runners.cypress.CypressRunConfiguration;
import com.intellij.aqua.runners.cypress.CypressRunSettings;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.testing.JsTestConfigurationUtil;
import com.intellij.javascript.testing.runScope.JsTestRunScope;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/aqua/runners/cypress/CypressUtil;", "", "<init>", "()V", "PKG_DESCRIPTOR", "Lcom/intellij/javascript/nodejs/util/NodePackageDescriptor;", "getPKG_DESCRIPTOR", "()Lcom/intellij/javascript/nodejs/util/NodePackageDescriptor;", "writeXml", "", "element", "Lorg/jdom/Element;", "settings", "Lcom/intellij/aqua/runners/cypress/CypressRunSettings;", "readXml", "checkRunConfiguration", "configuration", "Lcom/intellij/aqua/runners/cypress/CypressRunConfiguration;", "getCypressMainJsFile", "Ljava/nio/file/Path;", "pkg", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "TAG__CONFIG_FILE", "", "TAG__NODE_INTERPRETER", "TAG__NODE_OPTIONS", "TAG__VITEST_PACKAGE", "TAG__WORKING_DIR", "TAG__CLI_OPTIONS", "intellij.aqua.runners.cypress"})
public final class CypressUtil {
    @NotNull
    public static final CypressUtil INSTANCE = new CypressUtil();
    @NotNull
    private static final NodePackageDescriptor PKG_DESCRIPTOR = new NodePackageDescriptor("cypress");
    @NotNull
    private static final String TAG__CONFIG_FILE = "config";
    @NotNull
    private static final String TAG__NODE_INTERPRETER = "node-interpreter";
    @NotNull
    private static final String TAG__NODE_OPTIONS = "node-options";
    @NotNull
    private static final String TAG__VITEST_PACKAGE = "cypress-package";
    @NotNull
    private static final String TAG__WORKING_DIR = "working-dir";
    @NotNull
    private static final String TAG__CLI_OPTIONS = "cypress-options";

    private CypressUtil() {
    }

    @NotNull
    public final NodePackageDescriptor getPKG_DESCRIPTOR() {
        return PKG_DESCRIPTOR;
    }

    public final void writeXml(@NotNull Element element2, @NotNull CypressRunSettings settings) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (((CharSequence)settings.getConfigFilePath()).length() > 0) {
            JsTestConfigurationUtil.INSTANCE.writeValue(element2, TAG__CONFIG_FILE, FileUtil.toSystemIndependentName((String)settings.getConfigFilePath()));
        }
        JsTestConfigurationUtil.INSTANCE.writeValue(element2, TAG__NODE_INTERPRETER, settings.getInterpreterRef().getReferenceName());
        JsTestConfigurationUtil.INSTANCE.writeValue(element2, TAG__NODE_OPTIONS, settings.getNodeOptions());
        NodePackage nodePackage = settings.getFrameworkPackage();
        if (nodePackage != null) {
            NodePackage it = nodePackage;
            boolean bl = false;
            JsTestConfigurationUtil.INSTANCE.writeValue(element2, TAG__VITEST_PACKAGE, it.getSystemIndependentPath());
        }
        JsTestConfigurationUtil.INSTANCE.writeValue(element2, TAG__WORKING_DIR, FileUtil.toSystemIndependentName((String)settings.getWorkingDir()));
        if (((CharSequence)settings.getCliOptions()).length() > 0) {
            JsTestConfigurationUtil.INSTANCE.writeValue(element2, TAG__CLI_OPTIONS, settings.getCliOptions());
        }
        settings.getEnvData().writeExternal(element2);
        settings.getScope().writeExternal(element2);
    }

    @NotNull
    public final CypressRunSettings readXml(@NotNull Element element2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        CypressRunSettings.Builder builder2 = new CypressRunSettings.Builder();
        String string2 = JsTestConfigurationUtil.INSTANCE.readValue(element2, TAG__CONFIG_FILE);
        if (string2 == null) {
            string2 = "";
        }
        builder2.setConfigFilePath(string2);
        NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.create(JsTestConfigurationUtil.INSTANCE.readValue(element2, TAG__NODE_INTERPRETER));
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreterRef, (String)"create(...)");
        builder2.setInterpreterRef(nodeJsInterpreterRef);
        String string3 = JsTestConfigurationUtil.INSTANCE.readValue(element2, TAG__NODE_OPTIONS);
        if (string3 == null) {
            string3 = "";
        }
        builder2.setNodeOptions(string3);
        String string4 = JDOMExternalizerUtil.readCustomField((Element)element2, (String)TAG__VITEST_PACKAGE);
        if (string4 != null) {
            String it = string4;
            boolean bl = false;
            builder2.setFrameworkPackage(PKG_DESCRIPTOR.createPackage(it));
        }
        if ((string = JsTestConfigurationUtil.INSTANCE.readValue(element2, TAG__WORKING_DIR)) == null) {
            string = "";
        }
        builder2.setWorkingDir(string);
        String string5 = JsTestConfigurationUtil.INSTANCE.readValue(element2, TAG__CLI_OPTIONS);
        if (string5 == null) {
            string5 = "";
        }
        builder2.setCliOptions(string5);
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.readExternal((Element)element2);
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"readExternal(...)");
        builder2.setEnvData(environmentVariablesData);
        builder2.setScope(JsTestRunScope.Companion.readExternal(element2));
        return builder2.build();
    }

    public final void checkRunConfiguration(@NotNull CypressRunConfiguration configuration) throws RuntimeConfigurationException {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        CypressRunSettings settings = configuration.getSettings();
        if (((CharSequence)settings.getConfigFilePath()).length() > 0) {
            JsTestConfigurationUtil.INSTANCE.validatePath(false, "configuration file", settings.getConfigFilePath());
        }
        JsTestConfigurationUtil.INSTANCE.validatePath(true, "working directory", settings.getWorkingDir());
        NodeInterpreterUtil.checkForRunConfiguration(settings.getInterpreterRef().resolve(configuration.getProject()));
        configuration.getOrDetectPackage().validateForRunConfiguration("cypress");
        settings.getScope().validateForRunConfiguration(false);
    }

    @NotNull
    public final Path getCypressMainJsFile(@NotNull NodePackage pkg) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        String string = PackageJsonUtil.guessDefaultBinaryNameOfDependency(pkg);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"guessDefaultBinaryNameOfDependency(...)");
        String binaryName = string;
        Path path2 = NodePackage.findBinFilePath$default(pkg, binaryName, "./index.mjs", null, 4, null);
        if (path2 != null) {
            Path it = path2;
            boolean bl = false;
            return it;
        }
        Object[] objectArray = new Object[]{pkg.getName()};
        throw new ExecutionException(JavaScriptBundle.message((String)"node.package.cannot.find.bin.file.dialog.message", (Object[])objectArray));
    }
}

