/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.impl;

import com.intellij.facet.FacetFinder;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.lang.OuterModelsModificationTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.impl.CallExpressionModificationTracker;
import com.intellij.spring.impl.SpringEndpointsModificationTracker;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class SpringModificationTrackersManagerImpl
extends SpringModificationTrackersManager
implements Disposable {
    @NotNull
    private final Project myProject;
    private final SimpleModificationTracker myProfilesModificationTracker;
    private final SimpleModificationTracker myMultipleContextsModificationTracker;
    private final SimpleModificationTracker myCustomBeanParserModificationTracker;
    private final ModificationTracker myOuterModelsModificationTracker;
    private final SpringEndpointsModificationTracker myEndpointsModificationTracker;
    private final ModificationTracker myCallExpressionModificationTracker;

    public SpringModificationTrackersManagerImpl(@NotNull Project project) {
        if (project == null) {
            SpringModificationTrackersManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProfilesModificationTracker = new SimpleModificationTracker();
        this.myMultipleContextsModificationTracker = new SimpleModificationTracker();
        this.myCustomBeanParserModificationTracker = new SimpleModificationTracker();
        this.myProject = project;
        this.myOuterModelsModificationTracker = new OuterModelsModificationTracker(project, (Disposable)this, true, true);
        this.myEndpointsModificationTracker = new SpringEndpointsModificationTracker(this.myProject, this.myOuterModelsModificationTracker);
        this.myCallExpressionModificationTracker = new CallExpressionModificationTracker(this.myProject, this);
    }

    public ModificationTracker getProfilesModificationTracker() {
        return this.myProfilesModificationTracker;
    }

    public ModificationTracker getMultipleContextsModificationTracker() {
        return this.myMultipleContextsModificationTracker;
    }

    public ModificationTracker getOuterModelsModificationTracker() {
        return this.myOuterModelsModificationTracker;
    }

    public ModificationTracker getCustomBeanParserModificationTracker() {
        return this.myCustomBeanParserModificationTracker;
    }

    public ModificationTracker getEndpointsModificationTracker() {
        return this.myEndpointsModificationTracker;
    }

    public ModificationTracker getCallExpressionModificationTracker() {
        return this.myCallExpressionModificationTracker;
    }

    public void fireActiveProfilesChanged() {
        this.myProfilesModificationTracker.incModificationCount();
    }

    public void fireMultipleContextsChanged() {
        this.myMultipleContextsModificationTracker.incModificationCount();
    }

    public void fireCustomBeanParserChanged() {
        this.myCustomBeanParserModificationTracker.incModificationCount();
    }

    public Object[] getOuterModelsDependencies() {
        ArrayList<ModificationTracker> dependencies = new ArrayList<ModificationTracker>();
        dependencies.add(this.getOuterModelsModificationTracker());
        dependencies.add(this.getProfilesModificationTracker());
        dependencies.add(this.getMultipleContextsModificationTracker());
        dependencies.add(JavaLibraryModificationTracker.getInstance((Project)this.myProject));
        dependencies.add(FacetFinder.getInstance((Project)this.myProject).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID));
        dependencies.add(DumbService.getInstance((Project)this.myProject).getModificationTracker());
        return ArrayUtil.toObjectArray(dependencies);
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/impl/SpringModificationTrackersManagerImpl", "<init>"));
    }
}

