/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.editor;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiFile;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.config.ConfigFilesTreeBuilder;
import java.util.HashSet;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;

class SpringFilesTree
extends CheckboxTreeBase {
    SpringFilesTree() {
        super(new CheckboxTreeBase.CheckboxTreeCellRendererBase(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                ConfigFilesTreeBuilder.renderNode((Object)value, (boolean)expanded, (ColoredTreeCellRenderer)this.getTextRenderer());
            }
        }, null);
        ConfigFilesTreeBuilder.installSearch((JTree)((Object)this));
    }

    public void updateFileSet(SpringFileSet fileSet) {
        VirtualFilePointer[] pointers;
        HashSet configured = new HashSet();
        TreeUtil.traverse((TreeNode)((TreeNode)this.getModel().getRoot()), node -> {
            CheckedTreeNode checkedTreeNode = (CheckedTreeNode)node;
            if (!checkedTreeNode.isChecked()) {
                return true;
            }
            Object object = checkedTreeNode.getUserObject();
            VirtualFile virtualFile = null;
            if (object instanceof PsiFile) {
                virtualFile = ((PsiFile)object).getVirtualFile();
            } else if (object instanceof VirtualFile) {
                virtualFile = (VirtualFile)object;
            }
            if (virtualFile != null) {
                if (!fileSet.hasFile(virtualFile)) {
                    fileSet.addFile(virtualFile);
                }
                configured.add(virtualFile);
            }
            return true;
        });
        List files = fileSet.getFiles();
        for (VirtualFilePointer pointer : pointers = files.toArray(VirtualFilePointer.EMPTY_ARRAY)) {
            VirtualFile file = pointer.getFile();
            if (file != null && configured.contains(file)) continue;
            fileSet.removeFile(pointer);
        }
    }
}

