/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.utils.model;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.data.commons.model.jam.SpringRepositoryDefinition;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.jam.stereotype.SpringRepository;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class RepositoriesSearchUtil {
    public static List<CommonSpringBean> getAllRepositories(@NotNull Module module, boolean includeTests) {
        if (module == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(0);
        }
        if (module.isDisposed()) {
            return Collections.emptyList();
        }
        if (includeTests) {
            return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create(RepositoriesSearchUtil.getAllRepositories(SpringGlobalSearchScopes.runtime((Module)module, (boolean)true), module, "org.springframework.data.repository.Repository"), (Object[])new Object[]{UastModificationTracker.getInstance((Project)module.getProject())}));
        }
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create(RepositoriesSearchUtil.getAllRepositories(SpringGlobalSearchScopes.runtime((Module)module, (boolean)false), module, "org.springframework.data.repository.Repository"), (Object[])new Object[]{UastModificationTracker.getInstance((Project)module.getProject())}));
    }

    public static List<CommonSpringBean> getAllRepositories(@NotNull GlobalSearchScope scope, @NotNull Module module, @NotNull String repositoryBaseClassName) {
        PsiClass repositoryClass;
        if (scope == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(1);
        }
        if (module == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(2);
        }
        if (repositoryBaseClassName == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(3);
        }
        return (repositoryClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(repositoryBaseClassName, SpringGlobalSearchScopes.runtime((Module)module, (boolean)true))) == null ? Collections.emptyList() : RepositoriesSearchUtil.getRepositoriesCustomBeans(scope, repositoryClass, module.getProject());
    }

    private static List<CommonSpringBean> getRepositoriesCustomBeans(@NotNull GlobalSearchScope scope, @NotNull PsiClass repositoryClass, @NotNull Project project) {
        if (scope == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(4);
        }
        if (repositoryClass == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(5);
        }
        if (project == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(6);
        }
        ArrayList<CommonSpringBean> beans = new ArrayList<CommonSpringBean>();
        beans.addAll(RepositoriesSearchUtil.getRepositoryInterfaceInheritors(scope, repositoryClass));
        beans.addAll(RepositoriesSearchUtil.getRepositoryDefinitions(scope, project));
        return beans;
    }

    public static List<CommonSpringBean> getRepositoryInterfaceInheritors(@NotNull Module module) {
        if (module == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(7);
        }
        if (module.isDisposed()) {
            return Collections.emptyList();
        }
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            GlobalSearchScope searchScope = SpringGlobalSearchScopes.runtime((Module)module, (boolean)true);
            PsiClass repositoryClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("org.springframework.data.repository.Repository", searchScope);
            return CachedValueProvider.Result.create(RepositoriesSearchUtil.getRepositoryInterfaceInheritors(searchScope, repositoryClass, psiClass -> !AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"org.springframework.data.repository.NoRepositoryBean", (int)0)), (Object[])new Object[]{UastModificationTracker.getInstance((Project)module.getProject())});
        });
    }

    private static List<CommonSpringBean> getRepositoryInterfaceInheritors(GlobalSearchScope scope, PsiClass repositoryClass) {
        return RepositoriesSearchUtil.getRepositoryInterfaceInheritors(scope, repositoryClass, psiClass -> !AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"org.springframework.data.repository.NoRepositoryBean", (int)0) && !SpringCommonUtils.isStereotypeComponentOrMeta((PsiClass)psiClass));
    }

    private static List<CommonSpringBean> getRepositoryInterfaceInheritors(GlobalSearchScope scope, PsiClass repositoryClass, final Condition<PsiClass> ... conditions) {
        CommonProcessors.CollectProcessor<PsiClass> collectProcessor = new CommonProcessors.CollectProcessor<PsiClass>(){

            protected boolean accept(PsiClass psiClass) {
                for (Condition condition : conditions) {
                    if (condition.value((Object)psiClass)) continue;
                    return false;
                }
                return true;
            }
        };
        ClassInheritorsSearch.search((PsiClass)repositoryClass, (SearchScope)scope, (boolean)true, (boolean)true, (boolean)false).forEach((Processor)collectProcessor);
        Collection repositories = collectProcessor.getResults();
        HashSet<PsiClass> all = new HashSet<PsiClass>();
        all.addAll(repositories);
        all.addAll(RepositoriesSearchUtil.getCustomRepositoryImpls(repositoryClass, repositories));
        return ContainerUtil.map(all, SpringRepository::new);
    }

    @NotNull
    private static Set<PsiClass> getCustomRepositoryImpls(@NotNull PsiClass repositoryBaseClass, @NotNull Collection<PsiClass> repositories) {
        if (repositoryBaseClass == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(8);
        }
        if (repositories == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(9);
        }
        HashSet<PsiClass> customRepositoryImpls = new HashSet<PsiClass>();
        for (PsiClass repository : repositories) {
            if (!repository.isInterface()) continue;
            for (PsiClass customRepositoryInterface : repository.getSupers()) {
                if (!customRepositoryInterface.isInterface() || repositories.contains(customRepositoryInterface) || InheritanceUtil.isInheritorOrSelf((PsiClass)customRepositoryInterface, (PsiClass)repositoryBaseClass, (boolean)true)) continue;
                for (PsiClass customInterfaceImpl : ClassInheritorsSearch.search((PsiClass)customRepositoryInterface).findAll()) {
                    String customInterfaceImplName = customInterfaceImpl.getName();
                    String repositoryName = repository.getName();
                    if (customInterfaceImplName == null || repositoryName == null || !customInterfaceImplName.startsWith(repositoryName) || InheritanceUtil.isInheritorOrSelf((PsiClass)customInterfaceImpl, (PsiClass)repositoryBaseClass, (boolean)true)) continue;
                    customRepositoryImpls.add(customInterfaceImpl);
                }
            }
        }
        HashSet<PsiClass> hashSet = customRepositoryImpls;
        if (hashSet == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @NotNull
    public static List<SpringRepositoryDefinition> getRepositoryDefinitions(@NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (scope == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(11);
        }
        if (project == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(12);
        }
        JamService service = JamService.getJamService((Project)project);
        List list = service.getJamClassElements(SpringRepositoryDefinition.META, "org.springframework.data.repository.RepositoryDefinition", scope);
        if (list == null) {
            RepositoriesSearchUtil.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryBaseClassName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryClass";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryBaseClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/utils/model/RepositoriesSearchUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/utils/model/RepositoriesSearchUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomRepositoryImpls";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryDefinitions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllRepositories";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoriesCustomBeans";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryInterfaceInheritors";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCustomRepositoryImpls";
                break;
            }
            case 10: 
            case 13: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryDefinitions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 13 -> new IllegalStateException(string);
        };
    }
}

