/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.conversions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.j2k.ConverterContext;
import org.jetbrains.kotlin.nj2k.ExpressionsKt;
import org.jetbrains.kotlin.nj2k.RecursiveConversion;
import org.jetbrains.kotlin.nj2k.symbols.JKSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKUniverseClassSymbol;
import org.jetbrains.kotlin.nj2k.symbols.UtilsKt;
import org.jetbrains.kotlin.nj2k.tree.FormattingKt;
import org.jetbrains.kotlin.nj2k.tree.JKCallExpression;
import org.jetbrains.kotlin.nj2k.tree.JKClassAccessExpression;
import org.jetbrains.kotlin.nj2k.tree.JKExpression;
import org.jetbrains.kotlin.nj2k.tree.JKFieldAccessExpression;
import org.jetbrains.kotlin.nj2k.tree.JKFormattingOwner;
import org.jetbrains.kotlin.nj2k.tree.JKQualifiedExpression;
import org.jetbrains.kotlin.nj2k.tree.JKThisExpression;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\f\u0010\t\u001a\u00020\n*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/nj2k/conversions/RemoveRedundantQualifiersForCallsConversion;", "Lorg/jetbrains/kotlin/nj2k/RecursiveConversion;", "context", "Lorg/jetbrains/kotlin/j2k/ConverterContext;", "<init>", "(Lorg/jetbrains/kotlin/j2k/ConverterContext;)V", "applyToElement", "Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "element", "receiverExpression", "Lorg/jetbrains/kotlin/nj2k/tree/JKExpression;", "kotlin.j2k.shared"})
public final class RemoveRedundantQualifiersForCallsConversion
extends RecursiveConversion {
    public RemoveRedundantQualifiersForCallsConversion(@NotNull ConverterContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
    }

    @Override
    @NotNull
    public JKTreeElement applyToElement(@NotNull JKTreeElement element) {
        boolean needRemoveQualifier;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof JKQualifiedExpression)) {
            return this.recurse(element);
        }
        JKExpression receiver2 = this.receiverExpression(((JKQualifiedExpression)element).getReceiver());
        if (receiver2 instanceof JKClassAccessExpression) {
            v0 = ((JKClassAccessExpression)receiver2).getIdentifier() instanceof JKUniverseClassSymbol;
        } else if (receiver2 instanceof JKFieldAccessExpression || receiver2 instanceof JKCallExpression || receiver2 instanceof JKThisExpression) {
            JKSymbol jKSymbol = ExpressionsKt.getIdentifier(((JKQualifiedExpression)element).getSelector());
            v0 = jKSymbol != null ? UtilsKt.isStaticMember(jKSymbol) : false;
        } else {
            v0 = needRemoveQualifier = false;
        }
        if (needRemoveQualifier) {
            element.invalidate();
            return this.recurse((JKTreeElement)FormattingKt.withFormattingFrom(FormattingKt.withFormattingFrom((JKFormattingOwner)((JKQualifiedExpression)element).getSelector(), (JKFormattingOwner)((JKQualifiedExpression)element).getReceiver()), (JKFormattingOwner)element));
        }
        return this.recurse(element);
    }

    private final JKExpression receiverExpression(JKExpression $this$receiverExpression) {
        return $this$receiverExpression instanceof JKQualifiedExpression ? ((JKQualifiedExpression)$this$receiverExpression).getSelector() : $this$receiverExpression;
    }
}

