/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.ultimate.wasm.debugger.formatters;

import com.intellij.icons.AllIcons;
import com.intellij.util.Function;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentConsumer;
import org.jetbrains.concurrency.ObsolescentFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.concurrency.ValueNodeAsyncFunction;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.LazyVariablesGroupKt;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.VariablesHost;
import org.jetbrains.debugger.VariablesKt;
import org.jetbrains.debugger.values.IndexedVariablesConsumer;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.debugger.values.ValueType;
import org.jetbrains.kotlin.idea.ultimate.wasm.debugger.formatters.StructFormatter;
import org.jetbrains.kotlin.idea.ultimate.wasm.debugger.formatters.TypeNameAssociatedCustomFormatter;
import org.jetbrains.kotlin.idea.ultimate.wasm.debugger.utils.WasmTypeUtilsKt;
import org.jetbrains.kotlin.idea.ultimate.wasm.debugger.utils.WasmValueDebuggerView;
import org.jetbrains.wip.WipObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u00012\u00020\u0002:\u0001)B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J0\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u000f*\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u000f2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u000f2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J$\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u000f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00112\u0006\u0010'\u001a\u00020(H\u0016R\u0014\u0010\u0005\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u0006\u0012\u0002\b\u00030\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u000f*\u0006\u0012\u0002\b\u00030\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/ultimate/wasm/debugger/formatters/ContainerFormatter;", "Lorg/jetbrains/kotlin/idea/ultimate/wasm/debugger/formatters/TypeNameAssociatedCustomFormatter;", "Lorg/jetbrains/kotlin/idea/ultimate/wasm/debugger/formatters/StructFormatter;", "typeName", "", "sizePropertyName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getSizePropertyName", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "size", "Lorg/jetbrains/concurrency/Promise;", "", "Lorg/jetbrains/kotlin/idea/ultimate/wasm/debugger/utils/WasmValueDebuggerView;", "getSize", "(Lorg/jetbrains/kotlin/idea/ultimate/wasm/debugger/utils/WasmValueDebuggerView;)Lorg/jetbrains/concurrency/Promise;", "storage", "Lorg/jetbrains/wip/WipObject;", "getStorage", "getElementsInRange", "", "Lorg/jetbrains/debugger/Variable;", "range", "Lkotlin/ranges/IntRange;", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "shouldBeApplied", "", "view", "formatClassHeader", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation;", "formatBody", "", "context", "Lorg/jetbrains/debugger/VariableContext;", "WipIndexedObject", "kotlin-ultimate.wasm.debugger"})
@SourceDebugExtension(value={"SMAP\nContainerFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContainerFormatter.kt\norg/jetbrains/kotlin/idea/ultimate/wasm/debugger/formatters/ContainerFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n*L\n1#1,127:1\n1563#2:128\n1634#2,3:129\n103#3,5:132\n131#3,3:137\n*S KotlinDebug\n*F\n+ 1 ContainerFormatter.kt\norg/jetbrains/kotlin/idea/ultimate/wasm/debugger/formatters/ContainerFormatter\n*L\n46#1:128\n46#1:129,3\n53#1:132,5\n65#1:137,3\n*E\n"})
public abstract class ContainerFormatter
extends TypeNameAssociatedCustomFormatter
implements StructFormatter {
    @NotNull
    private final String sizePropertyName;
    @NotNull
    private final Icon icon;

    public ContainerFormatter(@NotNull String typeName, @NotNull String sizePropertyName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)sizePropertyName, (String)"sizePropertyName");
        super(typeName);
        this.sizePropertyName = sizePropertyName;
        Icon icon2 = AllIcons.Debugger.Db_array;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Db_array");
        this.icon = icon2;
    }

    @NotNull
    protected final String getSizePropertyName() {
        return this.sizePropertyName;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public abstract Promise<Integer> getSize(@NotNull WasmValueDebuggerView<?> var1);

    @NotNull
    public abstract Promise<WipObject> getStorage(@NotNull WasmValueDebuggerView<?> var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Promise<List<Variable>> getElementsInRange(@NotNull WipObject $this$getElementsInRange, @NotNull IntRange range2, @NotNull EvaluateContext evaluateContext, @NotNull XCompositeNode node) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getElementsInRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        Intrinsics.checkNotNullParameter((Object)evaluateContext, (String)"evaluateContext");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Iterable iterable = (Iterable)range2;
        WipObject wipObject = $this$getElementsInRange;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void p0;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(String.valueOf((int)p0));
        }
        return wipObject.getProperties((List)destination$iv$iv, evaluateContext, (Obsolescent)node);
    }

    @Override
    @NotNull
    public Promise<Boolean> shouldBeApplied(@NotNull WasmValueDebuggerView<?> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        return super.shouldBeApplied(view);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Promise<XValuePresentation> formatClassHeader(@NotNull WasmValueDebuggerView<?> view) {
        void $this$then$iv;
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Promise<Integer> promise = this.getSize(view);
        Object obsolescent$iv = view.getNode();
        boolean $i$f$then = false;
        Promise promise2 = $this$then$iv.then((Function)new ObsolescentFunction<Integer, XValuePresentation>(obsolescent$iv, this){
            final /* synthetic */ Obsolescent $obsolescent;
            final /* synthetic */ ContainerFormatter this$0;
            {
                this.$obsolescent = $obsolescent;
                this.this$0 = containerFormatter;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public Object fun(Object param) {
                int size = ((Number)param).intValue();
                boolean bl = false;
                return new XValuePresentation(this.this$0, size){
                    final /* synthetic */ ContainerFormatter this$0;
                    final /* synthetic */ int $size;
                    {
                        this.this$0 = $receiver;
                        this.$size = $size;
                    }

                    public void renderValue(XValuePresentation.XValueTextRenderer renderer2) {
                        Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
                        renderer2.renderComment("{");
                        renderer2.renderComment(WasmTypeUtilsKt.getClassNameFrom(this.this$0.getTypeName()));
                        renderer2.renderComment("}");
                        renderer2.renderValue(" " + this.$size + " value" + (this.$size == 1 ? "" : "s"));
                    }
                };
            }

            public boolean isObsolete() {
                return this.$obsolescent.isObsolete();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Promise<Unit> formatBody(@NotNull WasmValueDebuggerView<? extends XCompositeNode> view, @NotNull VariableContext context2) {
        void $this$thenAsync$iv;
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Promise<WipObject> promise = this.getStorage(view);
        XCompositeNode node$iv = view.getNode();
        boolean $i$f$thenAsync = false;
        Promise promise2 = $this$thenAsync$iv.thenAsync((Function)new ValueNodeAsyncFunction<WipObject, Unit>((Obsolescent)node$iv, this, view, context2){
            final /* synthetic */ ContainerFormatter this$0;
            final /* synthetic */ WasmValueDebuggerView $view$inlined;
            final /* synthetic */ VariableContext $context$inlined;
            {
                this.this$0 = containerFormatter;
                this.$view$inlined = wasmValueDebuggerView;
                this.$context$inlined = variableContext;
                super($node);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Promise fun(Object param) {
                void $this$thenAsync$iv;
                WipObject storage = (WipObject)param;
                boolean bl = false;
                Promise<Integer> promise = this.this$0.getSize(this.$view$inlined);
                T node$iv = this.$view$inlined.getNode();
                boolean $i$f$thenAsync = false;
                Promise promise2 = $this$thenAsync$iv.thenAsync((Function)new ValueNodeAsyncFunction<Integer, Unit>(node$iv, this.this$0, storage, this.$view$inlined, this.$context$inlined){
                    final /* synthetic */ ContainerFormatter this$0;
                    final /* synthetic */ WipObject $storage$inlined;
                    final /* synthetic */ WasmValueDebuggerView $view$inlined;
                    final /* synthetic */ VariableContext $context$inlined;
                    {
                        this.this$0 = containerFormatter;
                        this.$storage$inlined = wipObject;
                        this.$view$inlined = wasmValueDebuggerView;
                        this.$context$inlined = variableContext;
                        super($node);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     * WARNING - void declaration
                     */
                    public Promise fun(Object param) {
                        void $this$then$iv;
                        XValueChildrenList xValueChildrenList;
                        int size = ((Number)param).intValue();
                        boolean bl = false;
                        int bucketThreshold = 100;
                        WipObject wipObject = this.$storage$inlined;
                        Intrinsics.checkNotNull((Object)wipObject);
                        WipIndexedObject wrappedStorage = this.this$0.new WipIndexedObject(wipObject, (XCompositeNode)this.$view$inlined.getNode(), this.$context$inlined);
                        XValueChildrenList $this$formatBody_u24lambda_u240_u240_u240 = xValueChildrenList = new XValueChildrenList(1);
                        boolean bl2 = false;
                        $this$formatBody_u24lambda_u240_u240_u240.add((XNamedValue)new VariableView((Variable)new VariableImpl(this.this$0.getSizePropertyName(), (Value)new PrimitiveValue(ValueType.NUMBER, size)), this.$context$inlined));
                        XValueChildrenList lengthChild = xValueChildrenList;
                        ((XCompositeNode)this.$view$inlined.getNode()).setAlreadySorted(true);
                        ((XCompositeNode)this.$view$inlined.getNode()).addChildren(lengthChild, size == 0);
                        xValueChildrenList = (XCompositeNode)this.$view$inlined.getNode();
                        xValueChildrenList = ObjectValue.getIndexedProperties$default((ObjectValue)wrappedStorage, (int)0, (int)size, (int)bucketThreshold, (IndexedVariablesConsumer)((IndexedVariablesConsumer)new VariableView.ObsolescentIndexedVariablesConsumer(wrappedStorage, this.$context$inlined, (XCompositeNode)xValueChildrenList){
                            final /* synthetic */ WipIndexedObject $wrappedStorage;
                            final /* synthetic */ VariableContext $context;
                            {
                                this.$wrappedStorage = $wrappedStorage;
                                this.$context = $context;
                                super($super_call_param$1);
                            }

                            public void consumeRanges(int[] ranges) {
                                ObjectValue objectValue = this.$wrappedStorage;
                                Intrinsics.checkNotNull((Object)ranges);
                                LazyVariablesGroupKt.addRanges((ObjectValue)objectValue, (int[])ranges, (XCompositeNode)this.getNode(), (VariableContext)this.$context, (boolean)true);
                            }

                            public void consumeVariables(List<? extends Variable> variables) {
                                Intrinsics.checkNotNullParameter(variables, (String)"variables");
                                this.getNode().addChildren(VariablesKt.createVariablesList(variables, (VariableContext)this.$context, null), true);
                            }
                        }), null, (int)16, null);
                        T obsolescent$iv = this.$view$inlined.getNode();
                        boolean $i$f$then = false;
                        Promise promise = $this$then$iv.then((Function)new ObsolescentFunction<Object, Unit>(obsolescent$iv){
                            final /* synthetic */ Obsolescent $obsolescent;
                            {
                                this.$obsolescent = $obsolescent;
                            }

                            public Unit fun(Object param) {
                                Object it = param;
                                boolean bl = false;
                                return Unit.INSTANCE;
                            }

                            public boolean isObsolete() {
                                return this.$obsolescent.isObsolete();
                            }
                        });
                        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
                        return promise;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"thenAsync(...)");
                return promise2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"thenAsync(...)");
        return promise2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ6\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J3\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0096\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u0096\u0001J\t\u0010\u001f\u001a\u00020\u001eH\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u0004\u0018\u00010\u0018X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001e\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010$R\u0012\u0010%\u001a\u00020\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u0004\u0018\u00010\u0018X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b)\u0010\"R\u0018\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/idea/ultimate/wasm/debugger/formatters/ContainerFormatter$WipIndexedObject;", "Lorg/jetbrains/debugger/values/ObjectValue;", "wrappedObject", "Lorg/jetbrains/wip/WipObject;", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "context", "Lorg/jetbrains/debugger/VariableContext;", "<init>", "(Lorg/jetbrains/kotlin/idea/ultimate/wasm/debugger/formatters/ContainerFormatter;Lorg/jetbrains/wip/WipObject;Lcom/intellij/xdebugger/frame/XCompositeNode;Lorg/jetbrains/debugger/VariableContext;)V", "getIndexedProperties", "Lorg/jetbrains/concurrency/Promise;", "from", "", "to", "bucketThreshold", "consumer", "Lorg/jetbrains/debugger/values/IndexedVariablesConsumer;", "componentType", "Lorg/jetbrains/debugger/values/ValueType;", "getProperties", "", "Lorg/jetbrains/debugger/Variable;", "names", "", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "obsolescent", "Lorg/jetbrains/concurrency/Obsolescent;", "hasIndexedProperties", "Lcom/intellij/util/ThreeState;", "hasProperties", "className", "getClassName", "()Ljava/lang/String;", "properties", "()Lorg/jetbrains/concurrency/Promise;", "type", "getType", "()Lorg/jetbrains/debugger/values/ValueType;", "valueString", "getValueString", "variablesHost", "Lorg/jetbrains/debugger/VariablesHost;", "Lorg/jetbrains/debugger/values/ValueManager;", "getVariablesHost", "()Lorg/jetbrains/debugger/VariablesHost;", "kotlin-ultimate.wasm.debugger"})
    @SourceDebugExtension(value={"SMAP\nContainerFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContainerFormatter.kt\norg/jetbrains/kotlin/idea/ultimate/wasm/debugger/formatters/ContainerFormatter$WipIndexedObject\n+ 2 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n*L\n1#1,127:1\n110#2,3:128\n*S KotlinDebug\n*F\n+ 1 ContainerFormatter.kt\norg/jetbrains/kotlin/idea/ultimate/wasm/debugger/formatters/ContainerFormatter$WipIndexedObject\n*L\n120#1:128,3\n*E\n"})
    private final class WipIndexedObject
    implements ObjectValue {
        @NotNull
        private final WipObject wrappedObject;
        @NotNull
        private final XCompositeNode node;
        @NotNull
        private final VariableContext context;

        public WipIndexedObject(@NotNull WipObject wrappedObject, @NotNull XCompositeNode node, VariableContext context2) {
            Intrinsics.checkNotNullParameter((Object)wrappedObject, (String)"wrappedObject");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.wrappedObject = wrappedObject;
            this.node = node;
            this.context = context2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Promise<?> getIndexedProperties(int from, int to2, int bucketThreshold, @NotNull IndexedVariablesConsumer consumer, @Nullable ValueType componentType) {
            Promise promise;
            Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
            int length = to2 - from;
            double foldsDepth = Math.ceil(Math.log(length) / Math.log(bucketThreshold)) - 1.0;
            int bucketSize = (int)Math.pow(bucketThreshold, foldsDepth);
            int numberOfBuckets = (int)Math.ceil((double)length / (double)bucketSize);
            if (bucketSize > 1 && numberOfBuckets > 1) {
                List list2;
                List $this$getIndexedProperties_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
                boolean bl = false;
                int n = 0;
                while (n < numberOfBuckets) {
                    int it = n++;
                    boolean bl2 = false;
                    int start2 = from + it * bucketSize;
                    int end = start2 + bucketSize - 1;
                    $this$getIndexedProperties_u24lambda_u240.add(start2);
                    $this$getIndexedProperties_u24lambda_u240.add(end);
                }
                $this$getIndexedProperties_u24lambda_u240.set(CollectionsKt.getLastIndex((List)$this$getIndexedProperties_u24lambda_u240), Math.min(((Number)CollectionsKt.last((List)$this$getIndexedProperties_u24lambda_u240)).intValue(), to2));
                List ranges = CollectionsKt.build((List)list2);
                consumer.consumeRanges(CollectionsKt.toIntArray((Collection)ranges));
                promise = Promises.resolvedPromise((Object)Unit.INSTANCE);
            } else {
                void $this$onSuccess$iv;
                Promise<List<Variable>> ranges = ContainerFormatter.this.getElementsInRange(this.wrappedObject, RangesKt.until((int)from, (int)to2), this.context.getEvaluateContext(), this.node);
                Obsolescent node$iv = (Obsolescent)this.node;
                boolean $i$f$onSuccess = false;
                Promise promise2 = $this$onSuccess$iv.onSuccess((Consumer)new ObsolescentConsumer<List<? extends Variable>>(node$iv, consumer){
                    final /* synthetic */ IndexedVariablesConsumer $consumer$inlined;
                    {
                        this.$consumer$inlined = indexedVariablesConsumer;
                        super($node);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public void accept(Object param) {
                        List variables = (List)param;
                        boolean bl = false;
                        Iterable $this$sortedBy$iv = variables;
                        boolean $i$f$sortedBy = false;
                        this.$consumer$inlined.consumeVariables(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                            public final int compare(T a, T b) {
                                Variable it = (Variable)a;
                                boolean bl = false;
                                String string = it.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                                it = (Variable)b;
                                Comparable comparable = Integer.valueOf(Integer.parseInt(string));
                                bl = false;
                                String string2 = it.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(Integer.parseInt(string2)));
                            }
                        }));
                    }
                });
                promise = promise2;
                Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"onSuccess(...)");
            }
            return promise;
        }

        @NotNull
        public Promise<List<Variable>> getProperties(@NotNull List<String> names, @NotNull EvaluateContext evaluateContext, @NotNull Obsolescent obsolescent) {
            Intrinsics.checkNotNullParameter(names, (String)"names");
            Intrinsics.checkNotNullParameter((Object)evaluateContext, (String)"evaluateContext");
            Intrinsics.checkNotNullParameter((Object)obsolescent, (String)"obsolescent");
            return this.wrappedObject.getProperties(names, evaluateContext, obsolescent);
        }

        @NotNull
        public ThreeState hasProperties() {
            return this.wrappedObject.hasProperties();
        }

        @NotNull
        public ThreeState hasIndexedProperties() {
            return this.wrappedObject.hasIndexedProperties();
        }

        @Nullable
        public String getClassName() {
            return this.wrappedObject.getClassName();
        }

        @NotNull
        public Promise<List<Variable>> getProperties() {
            return this.wrappedObject.getProperties();
        }

        @NotNull
        public VariablesHost<ValueManager> getVariablesHost() {
            return this.wrappedObject.getVariablesHost();
        }

        @NotNull
        public ValueType getType() {
            return this.wrappedObject.getType();
        }

        @Nullable
        public String getValueString() {
            return this.wrappedObject.getValueString();
        }
    }
}

