/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighting.visitor;

import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.analysis.KotlinIdeInjectedFilesAnalysisPromoterKt;
import org.jetbrains.kotlin.idea.highlighting.KotlinUnusedHighlightingProcessor;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0001H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/highlighting/visitor/KotlinUnusedDeclarationHighlightingVisitor;", "Lcom/intellij/codeInsight/daemon/impl/HighlightVisitor;", "<init>", "()V", "suitableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "visit", "", "element", "Lcom/intellij/psi/PsiElement;", "analyze", "updateWholeFile", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "action", "Ljava/lang/Runnable;", "clone", "intellij.kotlin.highlighting"})
public final class KotlinUnusedDeclarationHighlightingVisitor
implements HighlightVisitor {
    public boolean suitableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof KtFile) || ((KtFile)file).isCompiled()) {
            return false;
        }
        HighlightingLevelManager highlightingLevelManager = HighlightingLevelManager.getInstance((Project)((KtFile)file).getProject());
        if (!highlightingLevelManager.shouldInspect((PsiElement)file)) {
            return false;
        }
        FileViewProvider fileViewProvider = ((KtFile)file).getViewProvider();
        Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"getViewProvider(...)");
        FileViewProvider viewProvider = fileViewProvider;
        boolean isInjection = InjectedLanguageManager.getInstance((Project)((KtFile)file).getProject()).isInjectedViewProvider(viewProvider);
        if (isInjection && !KotlinIdeInjectedFilesAnalysisPromoterKt.isInjectedFileShouldBeAnalyzed(viewProvider)) {
            return false;
        }
        HighlightingLevelManager highlightingManager = HighlightingLevelManager.getInstance((Project)((KtFile)file).getProject());
        return !highlightingManager.runEssentialHighlightingOnly((PsiElement)file);
    }

    public void visit(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
    }

    public boolean analyze(@NotNull PsiFile file, boolean updateWholeFile, @NotNull HighlightInfoHolder holder2, @NotNull Runnable action2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        if (!(file instanceof KtFile)) {
            return true;
        }
        new KotlinUnusedHighlightingProcessor((KtFile)file).collectHighlights$intellij_kotlin_highlighting(holder2);
        return true;
    }

    @NotNull
    public HighlightVisitor clone() {
        return new KotlinUnusedDeclarationHighlightingVisitor();
    }
}

