/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.locationResolving;

import com.intellij.javascript.debugger.locationResolving.SearchAccuracy;
import com.intellij.javascript.debugger.locationResolving.SearchResultNode;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Url;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\b\u0002\u0018\u00002\u00020\u0001B-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bB;\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\n\u0010\u0012J\u0006\u0010\u001f\u001a\u00020\u0000J\u0016\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\""}, d2={"Lcom/intellij/javascript/debugger/locationResolving/FileUrlMapping;", "", "url", "Lcom/intellij/util/Url;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "accuracy", "Lcom/intellij/javascript/debugger/locationResolving/SearchAccuracy;", "sourceContent", "", "<init>", "(Lcom/intellij/util/Url;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/javascript/debugger/locationResolving/SearchAccuracy;Ljava/lang/String;)V", "fileOrFsModificationStamp", "", "resolvedWithContent", "", "contentHashCode", "", "(Lcom/intellij/util/Url;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/javascript/debugger/locationResolving/SearchAccuracy;JZI)V", "getUrl", "()Lcom/intellij/util/Url;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getAccuracy", "()Lcom/intellij/javascript/debugger/locationResolving/SearchAccuracy;", "getFileOrFsModificationStamp", "()J", "getResolvedWithContent", "()Z", "getContentHashCode", "()I", "copyWithNoFile", "dominates", "fileFound", "intellij.javascript.debugger.backend"})
final class FileUrlMapping {
    @NotNull
    private final Url url;
    @Nullable
    private final VirtualFile file;
    @NotNull
    private final SearchAccuracy accuracy;
    private final long fileOrFsModificationStamp;
    private final boolean resolvedWithContent;
    private final int contentHashCode;

    @NotNull
    public final Url getUrl() {
        return this.url;
    }

    @Nullable
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final SearchAccuracy getAccuracy() {
        return this.accuracy;
    }

    public final long getFileOrFsModificationStamp() {
        return this.fileOrFsModificationStamp;
    }

    public final boolean getResolvedWithContent() {
        return this.resolvedWithContent;
    }

    public final int getContentHashCode() {
        return this.contentHashCode;
    }

    public FileUrlMapping(@NotNull Url url, @Nullable VirtualFile file, @NotNull SearchAccuracy accuracy, @Nullable String sourceContent) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)((Object)accuracy), (String)"accuracy");
        VirtualFile virtualFile = file;
        String string = sourceContent;
        this(url, file, accuracy, virtualFile != null ? virtualFile.getModificationStamp() : VirtualFileManager.getInstance().getStructureModificationCount(), sourceContent != null, string != null ? string.hashCode() : 0);
    }

    private FileUrlMapping(Url url, VirtualFile file, SearchAccuracy accuracy, long fileOrFsModificationStamp, boolean resolvedWithContent, int contentHashCode) {
        this.url = url;
        this.file = file;
        this.accuracy = accuracy;
        this.fileOrFsModificationStamp = fileOrFsModificationStamp;
        this.resolvedWithContent = resolvedWithContent;
        this.contentHashCode = contentHashCode;
    }

    @NotNull
    public final FileUrlMapping copyWithNoFile() {
        return new FileUrlMapping(this.url, null, this.accuracy, 0L, this.resolvedWithContent, this.contentHashCode);
    }

    public final boolean dominates(boolean fileFound, @NotNull SearchAccuracy accuracy) {
        Intrinsics.checkNotNullParameter((Object)((Object)accuracy), (String)"accuracy");
        return new SearchResultNode(this.file != null, this.accuracy).dominates(new SearchResultNode(fileFound, accuracy));
    }
}

