/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.modulith.highlighting;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.spring.modulith.SpringModulithBundle;
import com.intellij.spring.modulith.SpringModulithLibraryUtilsKt;
import com.intellij.spring.modulith.SpringModulithUtilsKt;
import com.intellij.spring.modulith.highlighting.quickFix.SpringModulithAddAllowedDependencyFix;
import com.intellij.spring.modulith.highlighting.quickFix.SpringModulithMakeModuleOpenFix;
import com.intellij.spring.modulith.highlighting.quickFix.SpringModulithMarkClassNamedInterfaceFix;
import com.intellij.spring.modulith.highlighting.quickFix.SpringModulithMoveClassToBasePackageFix;
import com.intellij.spring.modulith.model.ApplicationModule;
import com.intellij.spring.modulith.model.ModulithDependency;
import com.intellij.spring.modulith.model.NamedInterface;
import com.intellij.spring.modulith.model.SpringModulithModelService;
import com.intellij.spring.modulith.verification.AccessErrorType;
import com.intellij.spring.modulith.verification.SpringModulithVerificationKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J?\u0010\n\u001a\u001b\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000eH\u0002J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/spring/modulith/highlighting/SpringModulithApiUsageInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkApiUsage", "Lkotlin/Pair;", "", "Lorg/jetbrains/annotations/Nls;", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "sourcePsiClass", "Lcom/intellij/psi/PsiClass;", "targetPsiClass", "appModules", "Lcom/intellij/spring/modulith/model/ApplicationModule;", "isInProjectSourceFiles", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectFileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "intellij.spring.modulith"})
@SourceDebugExtension(value={"SMAP\nSpringModulithApiUsageInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringModulithApiUsageInspection.kt\ncom/intellij/spring/modulith/highlighting/SpringModulithApiUsageInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n295#2,2:125\n*S KotlinDebug\n*F\n+ 1 SpringModulithApiUsageInspection.kt\ncom/intellij/spring/modulith/highlighting/SpringModulithApiUsageInspection\n*L\n98#1:125,2\n*E\n"})
public final class SpringModulithApiUsageInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile());
        if (module == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Module module2 = module;
        if (!SpringModulithLibraryUtilsKt.hasModulithLibrary(module2)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List<ApplicationModule> appModules = SpringModulithModelService.Companion.getInstance$intellij_spring_modulith(project).getModel$intellij_spring_modulith(module2);
        if (appModules.isEmpty()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)module2.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        return new PsiElementVisitor(this, projectFileIndex2, appModules, holder){
            final /* synthetic */ SpringModulithApiUsageInspection this$0;
            final /* synthetic */ ProjectFileIndex $projectFileIndex;
            final /* synthetic */ List<ApplicationModule> $appModules;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$projectFileIndex = $projectFileIndex;
                this.$appModules = $appModules;
                this.$holder = $holder;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                ProgressIndicatorProvider.checkCanceled();
                UReferenceExpression uReferenceExpression = (UReferenceExpression)UastContextKt.toUElement((PsiElement)element, UReferenceExpression.class);
                if (uReferenceExpression == null) {
                    return;
                }
                UReferenceExpression uReferenceExpression2 = uReferenceExpression;
                UClass uClass = (UClass)UastUtils.getParentOfType$default((UElement)((UElement)uReferenceExpression2), UClass.class, (boolean)false, (int)2, null);
                if (uClass == null || (uClass = uClass.getJavaPsi()) == null) {
                    return;
                }
                UClass sourcePsiClass = uClass;
                VirtualFile virtualFile = sourcePsiClass.getContainingFile().getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                if (!SpringModulithApiUsageInspection.access$isInProjectSourceFiles(this.this$0, virtualFile, this.$projectFileIndex)) {
                    return;
                }
                PsiElement $this$asSafely$iv = uReferenceExpression2.resolve();
                boolean $i$f$asSafely = false;
                PsiElement psiElement = $this$asSafely$iv;
                if (!(psiElement instanceof PsiClass)) {
                    psiElement = null;
                }
                PsiClass psiClass = (PsiClass)psiElement;
                if (psiClass == null) {
                    return;
                }
                PsiClass targetPsiClass = psiClass;
                VirtualFile virtualFile2 = targetPsiClass.getContainingFile().getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
                if (!SpringModulithApiUsageInspection.access$isInProjectSourceFiles(this.this$0, virtualFile2, this.$projectFileIndex)) {
                    return;
                }
                Pair pair = SpringModulithApiUsageInspection.access$checkApiUsage(this.this$0, (PsiClass)sourcePsiClass, targetPsiClass, this.$appModules);
                if (pair == null) {
                    return;
                }
                Pair pair2 = pair;
                String message = (String)pair2.component1();
                List quickFixes = (List)pair2.component2();
                Collection $this$toTypedArray$iv = quickFixes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
                this.$holder.registerProblem(element, message, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    private final Pair<String, List<LocalQuickFix>> checkApiUsage(PsiClass sourcePsiClass, PsiClass targetPsiClass, List<ApplicationModule> appModules) {
        result = SpringModulithVerificationKt.verifyApiAccess(sourcePsiClass, targetPsiClass, appModules);
        if (result.isAccessAllowed() || result.getSourceModule() == null || result.getTargetModule() == null) {
            return null;
        }
        var5_5 = TuplesKt.to((Object)targetPsiClass.getName(), (Object)targetPsiClass.getQualifiedName());
        targetName = (String)var5_5.component1();
        targetFqn = (String)var5_5.component2();
        if (targetName == null || targetFqn == null) {
            return null;
        }
        v0 = result.getErrorType();
        switch (v0 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
            case 1: {
                v1 = result.getDependency();
                if (v1 == null) {
                    return null;
                }
                moduleDependency = v1;
                var9_11 = new Object[]{result.getSourceModule().getId()};
                v2 = new Pair((Object)SpringModulithBundle.message("inspection.api.usage.no.allowed.dependencies", var9_11), (Object)CollectionsKt.listOf((Object)new SpringModulithAddAllowedDependencyFix(result.getSourceModule().getId(), moduleDependency)));
                v3 = v2;
                break;
            }
            case 2: {
                v4 = result.getDependency();
                if (v4 == null) {
                    return null;
                }
                moduleDependency = v4;
                var9_12 = new Object[3];
                var9_12[0] = result.getSourceModule().getId();
                var9_12[1] = moduleDependency;
                v5 = result.getSourceModule().getAllowedDependencies();
                if (v5 == null) {
                    v5 = CollectionsKt.emptyList();
                }
                var9_12[2] = CollectionsKt.joinToString$default((Iterable)v5, null, null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, checkApiUsage$lambda$0(com.intellij.spring.modulith.model.ModulithDependency ), (Lcom/intellij/spring/modulith/model/ModulithDependency;)Ljava/lang/CharSequence;)(), (int)31, null);
                v6 = new Pair((Object)SpringModulithBundle.message("inspection.api.usage.not.allowed.dependency", var9_12), (Object)CollectionsKt.listOf((Object)new SpringModulithAddAllowedDependencyFix(result.getSourceModule().getId(), moduleDependency)));
                v3 = v6;
                break;
            }
            case 3: {
                quickFixes = new ArrayList<E>();
                ((Collection)quickFixes).add(new SpringModulithMoveClassToBasePackageFix(targetFqn, result.getTargetModule().getId()));
                $this$firstOrNull$iv = result.getTargetModule().getNamedInterfaces();
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (NamedInterface)element$iv;
                    $i$a$-firstOrNull-SpringModulithApiUsageInspection$checkApiUsage$unnamedInterface$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"<<UNNAMED>>")) continue;
                    v7 = element$iv;
                    ** GOTO lbl48
                }
                v7 = null;
lbl48:
                // 2 sources

                unnamedInterface = v7;
                if (unnamedInterface != null && !unnamedInterface.getTypes().contains(targetFqn)) {
                    ((Collection)quickFixes).add(new SpringModulithMarkClassNamedInterfaceFix(targetName, targetFqn));
                }
                if (!SpringModulithUtilsKt.isNestedModule(result.getTargetModule(), appModules)) {
                    ((Collection)quickFixes).add(new SpringModulithMakeModuleOpenFix(result.getTargetModule().getId()));
                }
                var10_14 = new Object[]{result.getSourceModule().getId(), targetFqn, result.getTargetModule().getId()};
                v8 = new Pair((Object)SpringModulithBundle.message("inspection.api.usage.not.exposed.dependency", var10_14), (Object)quickFixes);
                v3 = v8;
                break;
            }
            default: {
                v3 = null;
            }
        }
        return v3;
    }

    private final boolean isInProjectSourceFiles(VirtualFile vFile, ProjectFileIndex projectFileIndex) {
        return projectFileIndex.isUnderSourceRootOfType(vFile, SetsKt.setOf((Object)JavaSourceRootType.SOURCE));
    }

    private static final CharSequence checkApiUsage$lambda$0(ModulithDependency it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.id();
    }

    public static final /* synthetic */ boolean access$isInProjectSourceFiles(SpringModulithApiUsageInspection $this, VirtualFile vFile, ProjectFileIndex projectFileIndex) {
        return $this.isInProjectSourceFiles(vFile, projectFileIndex);
    }

    public static final /* synthetic */ Pair access$checkApiUsage(SpringModulithApiUsageInspection $this, PsiClass sourcePsiClass, PsiClass targetPsiClass, List appModules) {
        return $this.checkApiUsage(sourcePsiClass, targetPsiClass, appModules);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AccessErrorType.values().length];
            try {
                nArray[AccessErrorType.NO_ALLOWED_DEPENDENCIES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AccessErrorType.DEPENDENCY_NOT_ALLOWED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AccessErrorType.INTERNAL_API_USED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

