/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config;

import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.remote.AuthType;
import com.intellij.remote.PresentableId;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshUiData;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.GroupedServersComparer;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.config.MyServerWithCredentials;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SettingsDeployable
extends Deployable {
    @Override
    @NotNull
    public SettingsDeployable clone();

    @Override
    @Nullable
    public Credentials getCredentials();

    public void eraseCredentialsFromPasswordSafe();

    public void updateCredentialsFromPasswordSafe();

    @Override
    @NlsSafe
    public String getMountedFolder();

    @NlsSafe
    public String getRootFolder();

    @Override
    public boolean isAnonymous();

    public AdvancedOptionsConfig getAdvancedOptions();

    public boolean isFtpsExplicit();

    public void setAccessType(@NotNull AccessType var1);

    public void setUrl(String var1);

    public void setIsProjectLevel(boolean var1);

    public void setHost(String var1);

    public void setLiteralPort(String var1);

    public void setAnonymous(boolean var1);

    public void setAuthType(@NotNull AuthType var1);

    public void setPort(int var1);

    public void setRootFolder(String var1);

    public void setAdvancedOptions(AdvancedOptionsConfig var1);

    public void setMountedFolder(String var1);

    public void setFtpsExplicit(boolean var1);

    @Nullable
    public String getNonBlockingWarnings();

    public void setId(String var1);

    public void setName(String var1);

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String validateFast();

    public void setInGroup(boolean var1);

    public boolean isInGroup();

    default public int compareTo(@NotNull SettingsDeployable server2, @NotNull PublishConfig config) {
        if (server2 == null) {
            SettingsDeployable.$$$reportNull$$$0(0);
        }
        if (config == null) {
            SettingsDeployable.$$$reportNull$$$0(1);
        }
        return GroupedServersComparer.compareServers(GroupedServersComparer.wrap(this.computeWebServerConfig()), GroupedServersComparer.wrap(server2.computeWebServerConfig()), config);
    }

    @Nullable
    public PresentableId getSshPresentableId();

    public void setSshUiData(@Nullable PresentableId var1, @Nullable SshUiData var2);

    public void updateSshConfig(@NotNull SshConfigManager var1);

    @Contract(value="null,_,_->null; !null,_,_->!null")
    public static SettingsDeployable create(@Nullable WebServerConfig server, boolean isFromGroup, @Nullable SshUiData data) {
        if (server == null) {
            return null;
        }
        MyServerWithCredentials serverWithCredentials = new MyServerWithCredentials(server, data);
        serverWithCredentials.setInGroup(isFromGroup);
        return serverWithCredentials;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "server2";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "config";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/plugins/webDeployment/ui/config/SettingsDeployable";
        objectArray[2] = "compareTo";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

