/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EditorTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;

public class MultilineEditor
extends JPanel {
    private final EditorModel myModel;
    private final EditorTextField myEditorTextField;

    public EditorTextField getField() {
        return this.myEditorTextField;
    }

    public MultilineEditor(Document document, Project project, FileType fileType, EditorModel model) {
        super(new BorderLayout());
        this.myModel = model;
        this.myEditorTextField = new EditorTextField(document, project, fileType){

            @NotNull
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.setHorizontalScrollbarVisible(true);
                editor.setVerticalScrollbarVisible(true);
                editor.setEmbeddedIntoDialogWrapper(true);
                editor.getComponent().setPreferredSize(null);
                EditorEx editorEx = editor;
                if (editorEx == null) {
                    1.$$$reportNull$$$0(0);
                }
                return editorEx;
            }

            protected boolean isOneLineMode() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/ui/MultilineEditor$1", "createEditor"));
            }
        };
        this.add((Component)this.myEditorTextField, "Center");
        model.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                int selectedIndex = MultilineEditor.this.myModel.getSelectedIndex();
                if (selectedIndex != -1) {
                    MultilineEditor.this.myEditorTextField.setText(MultilineEditor.this.myModel.getItemString(selectedIndex));
                }
            }
        });
        this.addHistoryPagers();
    }

    private void addHistoryPagers() {
        DefaultActionGroup pagerGroup = new DefaultActionGroup();
        pagerGroup.add((AnAction)new ItemAction("PreviousOccurence", this){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                Presentation presentation = e.getPresentation();
                presentation.setEnabled(MultilineEditor.this.myModel.getSelectedIndex() < MultilineEditor.this.myModel.getSize() - 1);
                presentation.setText(XPathBundle.message("action.previous.history.entry.text", new Object[0]));
                presentation.setDescription(XPathBundle.message("action.navigate.to.previous.history.entry.description", new Object[0]));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                MultilineEditor.this.myModel.setSelectedIndex(MultilineEditor.this.myModel.getSelectedIndex() + 1);
                MultilineEditor.this.refocus();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "org/intellij/plugins/xpathView/ui/MultilineEditor$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        pagerGroup.add((AnAction)new ItemAction("NextOccurence", this){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                Presentation presentation = e.getPresentation();
                presentation.setEnabled(MultilineEditor.this.myModel.getSelectedIndex() > 0);
                presentation.setText(XPathBundle.message("action.next.history.entry.text", new Object[0]));
                presentation.setDescription(XPathBundle.message("action.navigate.to.next.history.entry.description", new Object[0]));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                MultilineEditor.this.myModel.setSelectedIndex(MultilineEditor.this.myModel.getSelectedIndex() - 1);
                MultilineEditor.this.refocus();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "org/intellij/plugins/xpathView/ui/MultilineEditor$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("HistoryPager", (ActionGroup)pagerGroup, false);
        this.add((Component)toolbar.getComponent(), "East");
    }

    private void refocus() {
        SwingUtilities.invokeLater(() -> {
            Editor editor = this.myEditorTextField.getEditor();
            if (editor != null) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)editor.getContentComponent(), true));
            }
            this.myEditorTextField.selectAll();
        });
    }

    public static interface EditorModel
    extends ListModel {
        public int getSelectedIndex();

        public void setSelectedIndex(int var1);

        public String getItemString(int var1);

        @Override
        public int getSize();
    }

    private static abstract class ItemAction
    extends AnAction {
        ItemAction(String id, JComponent component) {
            ActionUtil.copyFrom((AnAction)this, (String)id);
            this.registerCustomShortcutSet(this.getShortcutSet(), component);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ItemAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xpathView/ui/MultilineEditor$ItemAction", "getActionUpdateThread"));
        }
    }
}

