/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.highlighting;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.hibernate.HibernateBundle;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.javaee.constants.JpaAnnotationConstants;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.compiler.util.InspectionValidatorWrapper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;

public final class HibernateFindAnnotationInspection
extends AbstractBaseUastLocalInspectionTool {
    private static final String[] EXCLUDE_PARAMS = new String[]{"org.hibernate.Session", "org.hibernate.StatelessSession", "org.hibernate.reactive.mutiny.Mutiny.Session", JpaAnnotationConstants.ENTITY_MANAGER_CLASS.javax(), JpaAnnotationConstants.ENTITY_MANAGER_CLASS.jakarta()};
    public static final String[] RETURN_TYPES = new String[]{"java.util.List", "org.hibernate.query.Query", "org.hibernate.query.SelectionQuery", "jakarta.persistence.Query", "jakarta.persistence.TypedQuery", "java.util.Optional"};

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            HibernateFindAnnotationInspection.$$$reportNull$$$0(0);
        }
        if (InspectionValidatorWrapper.isCompilationThread()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                HibernateFindAnnotationInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)holder.getFile());
        if (module == null || !JavaLibraryUtil.hasLibraryJar((Module)module, (String)"org.hibernate.orm:hibernate-core")) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                HibernateFindAnnotationInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            HibernateFindAnnotationInspection.$$$reportNull$$$0(3);
        }
        return psiElementVisitor;
    }

    public ProblemDescriptor @Nullable [] checkMethod(@NotNull UMethod uMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (uMethod == null) {
            HibernateFindAnnotationInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            HibernateFindAnnotationInspection.$$$reportNull$$$0(5);
        }
        PsiMethod method = uMethod.getJavaPsi();
        PsiElement sourcePsi = uMethod.getSourcePsi();
        if (sourcePsi == null) {
            return null;
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"org.hibernate.annotations.processing.Find"});
        if (annotation == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiElement elementToHighlight = UAnnotationKt.getNamePsiElement((UAnnotation)((UAnnotation)UastContextKt.toUElement((PsiElement)annotation, UAnnotation.class)));
        if (elementToHighlight == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, sourcePsi.getContainingFile(), isOnTheFly);
        PsiType type = method.getReturnType();
        PsiClass entityClass = HibernateFindAnnotationInspection.extractEntityClass(type);
        if (entityClass == null) {
            holder.registerProblem(elementToHighlight, HibernateBundle.message("HibernateFindAnnotationInspection.incorrect.return.type", new Object[0]), new LocalQuickFix[0]);
        } else {
            HibernateFindAnnotationInspection.checkParameters(uMethod, entityClass, holder);
        }
        return holder.getResultsArray();
    }

    private static void checkParameters(@NotNull UMethod uMethod, PsiClass entityClass, ProblemsHolder holder) {
        PersistentObject entity;
        if (uMethod == null) {
            HibernateFindAnnotationInspection.$$$reportNull$$$0(6);
        }
        if ((entity = HibernateFindAnnotationInspection.getPersistenceObject(entityClass)) != null) {
            Map<String, PsiType> attrs = HibernateFindAnnotationInspection.findPersistenceAttributes(entity);
            for (UParameter uastParameter : uMethod.getUastParameters()) {
                PsiElement identifier;
                if (HibernateFindAnnotationInspection.hasPersistenceAttribute(uastParameter, attrs) || HibernateFindAnnotationInspection.isExcludedParameter(uastParameter.getType())) continue;
                if (HibernateFindAnnotationInspection.isPageOrOrderParameter(uastParameter.getType())) {
                    if (!HibernateFindAnnotationInspection.isPersistenceEntity(uMethod.getReturnType()) || (identifier = HibernateFindAnnotationInspection.getParameterNameIdentifier(uastParameter)) == null) continue;
                    holder.registerProblem(identifier, HibernateBundle.message("HibernateFindAnnotationInspection.incorrect.page.or.order.parameter", entityClass.getName()), new LocalQuickFix[0]);
                    continue;
                }
                identifier = HibernateFindAnnotationInspection.getParameterNameIdentifier(uastParameter);
                if (identifier == null) continue;
                holder.registerProblem(identifier, HibernateBundle.message("HibernateFindAnnotationInspection.incorrect.parameter", entityClass.getName()), new LocalQuickFix[0]);
            }
        }
    }

    private static boolean isPageOrOrderParameter(@NotNull PsiType parameterType) {
        if (parameterType == null) {
            HibernateFindAnnotationInspection.$$$reportNull$$$0(7);
        }
        if (PsiTypesUtil.classNameEquals((PsiType)parameterType, (String)"org.hibernate.query.Page") || PsiTypesUtil.classNameEquals((PsiType)parameterType, (String)"org.hibernate.query.Order")) {
            return true;
        }
        if (parameterType instanceof PsiArrayType) {
            return HibernateFindAnnotationInspection.isPageOrOrderParameter(((PsiArrayType)parameterType).getComponentType());
        }
        return false;
    }

    private static boolean isExcludedParameter(@NotNull PsiType parameterType) {
        if (parameterType == null) {
            HibernateFindAnnotationInspection.$$$reportNull$$$0(8);
        }
        for (String excludeParam : EXCLUDE_PARAMS) {
            if (!PsiTypesUtil.classNameEquals((PsiType)parameterType, (String)excludeParam)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiElement getParameterNameIdentifier(@NotNull UParameter uastParameter) {
        UElement anchor;
        if (uastParameter == null) {
            HibernateFindAnnotationInspection.$$$reportNull$$$0(9);
        }
        return (anchor = uastParameter.getUastAnchor()) != null ? anchor.getSourcePsi() : null;
    }

    @NotNull
    public static Map<String, PsiType> findPersistenceAttributes(@NotNull PersistentObject persistentObject) {
        if (persistentObject == null) {
            HibernateFindAnnotationInspection.$$$reportNull$$$0(10);
        }
        HashMap<String, PsiType> attrs = new HashMap<String, PsiType>();
        for (PersistentAttribute attribute : PersistenceHelper.getHelper().createModelBrowser().queryAttributes(persistentObject).asIterable()) {
            String name = (String)attribute.getName().getValue();
            PsiType type = attribute.getPsiType();
            if (name == null || type == null) continue;
            attrs.put(name, type);
        }
        HashMap<String, PsiType> hashMap = attrs;
        if (hashMap == null) {
            HibernateFindAnnotationInspection.$$$reportNull$$$0(11);
        }
        return hashMap;
    }

    private static boolean hasPersistenceAttribute(@NotNull UParameter parameter, @NotNull Map<String, PsiType> attrs) {
        String parameterName;
        if (parameter == null) {
            HibernateFindAnnotationInspection.$$$reportNull$$$0(12);
        }
        if (attrs == null) {
            HibernateFindAnnotationInspection.$$$reportNull$$$0(13);
        }
        if ((parameterName = parameter.getName()) == null) {
            return false;
        }
        PsiType parameterType = parameter.getType();
        return HibernateFindAnnotationInspection.hasPersistenceAttribute(parameterType, attrs, parameterName);
    }

    private static boolean hasPersistenceAttribute(@NotNull PsiType parameterType, @NotNull Map<String, PsiType> attrs, @NotNull String parameterName) {
        if (parameterType == null) {
            HibernateFindAnnotationInspection.$$$reportNull$$$0(14);
        }
        if (attrs == null) {
            HibernateFindAnnotationInspection.$$$reportNull$$$0(15);
        }
        if (parameterName == null) {
            HibernateFindAnnotationInspection.$$$reportNull$$$0(16);
        }
        if (parameterName.contains("$")) {
            return HibernateFindAnnotationInspection.hasQualifiedParameter(parameterType, attrs, parameterName);
        }
        PsiType type = attrs.get(parameterName);
        if (type == null) {
            return false;
        }
        return type.isAssignableFrom(parameterType);
    }

    private static boolean hasQualifiedParameter(@NotNull PsiType parameterType, @NotNull Map<String, PsiType> attrs, @NotNull String parameterName) {
        if (parameterType == null) {
            HibernateFindAnnotationInspection.$$$reportNull$$$0(17);
        }
        if (attrs == null) {
            HibernateFindAnnotationInspection.$$$reportNull$$$0(18);
        }
        if (parameterName == null) {
            HibernateFindAnnotationInspection.$$$reportNull$$$0(19);
        }
        String firstParamName = parameterName.substring(0, parameterName.indexOf("$"));
        PsiType firstParamType = attrs.get(firstParamName);
        String nextParamName = parameterName.substring(parameterName.indexOf("$") + 1);
        if (StringUtil.isEmptyOrSpaces((String)nextParamName)) {
            return false;
        }
        if (firstParamType == null) {
            return false;
        }
        if (firstParamType instanceof PsiClassType) {
            PsiClass resolve = ((PsiClassType)firstParamType).resolve();
            if (resolve == null) {
                return false;
            }
            PersistentObject entity = HibernateFindAnnotationInspection.getPersistenceObject(resolve);
            if (entity != null) {
                return HibernateFindAnnotationInspection.hasPersistenceAttribute(parameterType, HibernateFindAnnotationInspection.findPersistenceAttributes(entity), nextParamName);
            }
        }
        return false;
    }

    @Nullable
    public static PersistentObject getPersistenceObject(@NotNull PsiClass entityClass) {
        if (entityClass == null) {
            HibernateFindAnnotationInspection.$$$reportNull$$$0(20);
        }
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles((PsiClass)entityClass)) {
            if (role.getType() != PersistenceClassRoleEnum.ENTITY && role.getType() != PersistenceClassRoleEnum.EMBEDDABLE) continue;
            return role.getPersistentObject();
        }
        return null;
    }

    @Nullable
    public static PsiClass extractEntityClass(@Nullable PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        if (HibernateFindAnnotationInspection.isReactiveType(type)) {
            return HibernateFindAnnotationInspection.extractEntityClass(PsiUtil.substituteTypeParameter((PsiType)type, (String)"io.smallrye.mutiny.Uni", (int)0, (boolean)false));
        }
        if (HibernateFindAnnotationInspection.isPersistenceEntity(type)) {
            return ((PsiClassType)type).resolve();
        }
        for (String returnType : RETURN_TYPES) {
            PsiType typeParameter = PsiUtil.substituteTypeParameter((PsiType)type, (String)returnType, (int)0, (boolean)false);
            if (!HibernateFindAnnotationInspection.isPersistenceEntity(typeParameter)) continue;
            return ((PsiClassType)typeParameter).resolve();
        }
        return null;
    }

    public static boolean isReactiveType(PsiType type) {
        return PsiTypesUtil.classNameEquals((PsiType)type, (String)"io.smallrye.mutiny.Uni");
    }

    private static boolean isPersistenceEntity(@Nullable PsiType type) {
        if (HibernateFindAnnotationInspection.isReactiveType(type)) {
            return HibernateFindAnnotationInspection.isPersistenceEntity(PsiUtil.substituteTypeParameter((PsiType)type, (String)"io.smallrye.mutiny.Uni", (int)0, (boolean)false));
        }
        return type instanceof PsiClassType && JpaUtil.isPersistentObject((PsiType)type, (PersistenceClassRoleEnum)PersistenceClassRoleEnum.ENTITY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/hibernate/highlighting/HibernateFindAnnotationInspection";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 7: 
            case 8: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uastParameter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistentObject";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/hibernate/highlighting/HibernateFindAnnotationInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findPersistenceAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkParameters";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isPageOrOrderParameter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isExcludedParameter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParameterNameIdentifier";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findPersistenceAttributes";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasPersistenceAttribute";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "hasQualifiedParameter";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPersistenceObject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 11 -> new IllegalStateException(string);
        };
    }
}

