/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.facet.ui;

import com.intellij.DynamicBundle;
import com.intellij.facet.Facet;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.hibernate.HibernateBundle;
import com.intellij.hibernate.facet.HibernateFacet;
import com.intellij.hibernate.facet.HibernateFacetConfiguration;
import com.intellij.hibernate.model.HibernateDescriptorsConstants;
import com.intellij.javaee.ui.ConfigFilesEditor;
import com.intellij.javaee.ui.DeploymentDescriptorsOwner;
import com.intellij.javaee.ui.DeploymentDescriptorsOwnerBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class HibernateGeneralEditorTab
extends FacetEditorTab {
    private JPanel myMainPanel;
    @Nullable
    private final HibernateFacet myFacet;
    private DeploymentDescriptorsOwnerBase myDescriptorsOwner;
    private ConfigFileInfoSet myFileInfoSet;
    private ConfigFilesEditor myConfigFilesEditor;
    private JPanel myDescriptorsPanel;

    public HibernateGeneralEditorTab(HibernateFacetConfiguration configuration, FacetEditorContext editorContext) {
        this.$$$setupUI$$$();
        this.myFacet = (HibernateFacet)editorContext.getFacet();
        this.createDescriptorsEditor(editorContext);
    }

    private void createDescriptorsEditor(FacetEditorContext editorContext) {
        this.myDescriptorsOwner = new DeploymentDescriptorsOwnerBase(this, editorContext){

            public boolean canBeParentForDescriptors(VirtualFile dir) {
                return true;
            }
        };
        ConfigFileMetaData[] metaData = new ConfigFileMetaData[]{HibernateDescriptorsConstants.HIBERNATE_CONFIGURATION_META_DATA};
        ConfigFileMetaDataProvider provider = ConfigFileFactory.getInstance().createMetaDataProvider(metaData);
        this.myFileInfoSet = this.myFacet == null ? ConfigFileFactory.getInstance().createConfigFileInfoSet(provider) : ((HibernateFacetConfiguration)this.myFacet.getConfiguration()).getDescriptorsConfiguration();
        Module module = editorContext.getModule();
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        List sourceRoots = rootManager.getSourceRoots(JavaModuleSourceRootTypes.RESOURCES);
        if (sourceRoots.isEmpty()) {
            sourceRoots = rootManager.getSourceRoots(JavaModuleSourceRootTypes.SOURCES);
        }
        File defaultParent = !sourceRoots.isEmpty() ? new File(((VirtualFile)sourceRoots.get(0)).getPath()) : new File(module.getModuleFilePath()).getAbsoluteFile().getParentFile();
        this.myConfigFilesEditor = new ConfigFilesEditor(metaData, this.myFileInfoSet, defaultParent, editorContext.isNewFacet(), (DeploymentDescriptorsOwner)this.myDescriptorsOwner, false);
        this.myDescriptorsPanel.setLayout(new BorderLayout());
        this.myDescriptorsPanel.add((Component)this.myConfigFilesEditor.createComponent(), "Center");
    }

    @Nls
    public String getDisplayName() {
        return HibernateBundle.message("tab.title.hibernate.general.settings", new Object[0]);
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            HibernateGeneralEditorTab.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public boolean isModified() {
        return this.myConfigFilesEditor.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myConfigFilesEditor.applyChanges();
    }

    public void onFacetInitialized(@NotNull Facet facet) {
        if (facet == null) {
            HibernateGeneralEditorTab.$$$reportNull$$$0(1);
        }
        this.myDescriptorsOwner.createAndDeleteFiles(facet.getModule().getProject());
        ((HibernateFacetConfiguration)((HibernateFacet)facet).getConfiguration()).getDescriptorsConfiguration().setConfigFileInfos((Collection)this.myFileInfoSet.getConfigFileInfos());
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.module.facet.hibernate.jpa";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/hibernate/facet/ui/HibernateGeneralEditorTab";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/hibernate/facet/ui/HibernateGeneralEditorTab";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onFacetInitialized";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDescriptorsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/HibernateBundle", HibernateGeneralEditorTab.class).getString("group.title.descriptors"), (int)0, (int)0, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

