/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.util.DasUtil;
import com.intellij.hibernate.HibernateCustomJdbcTypeMapperKt;
import com.intellij.hibernate.model.xml.types.DbTypeMapping;
import com.intellij.hibernate.model.xml.types.HibernateReverseEngineering;
import com.intellij.hibernate.model.xml.types.TableFilter;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.CustomJdbcTypeMapper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010\u0016\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\b\u0002\u0010\u001a\u001a\u00020\fH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/hibernate/HibernateCustomJdbcTypeMapper;", "Lcom/intellij/persistence/CustomJdbcTypeMapper;", "<init>", "()V", "getMappedJavaTypeFor", "", "", "column", "Lcom/intellij/database/model/DasColumn;", "project", "Lcom/intellij/openapi/project/Project;", "typeMatches", "", "actualType", "Lcom/intellij/database/model/DataType;", "mapping", "Lcom/intellij/hibernate/model/xml/types/DbTypeMapping;", "locationMatches", "actualColumn", "filter", "Lcom/intellij/hibernate/model/xml/types/TableFilter;", "locationAllowed", "matchesConditions", "actual", "", "required", "isRegexp", "intellij.hibernate"})
@SourceDebugExtension(value={"SMAP\nHibernateCustomJdbcTypeMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HibernateCustomJdbcTypeMapper.kt\ncom/intellij/hibernate/HibernateCustomJdbcTypeMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1761#2,3:82\n1617#2,9:85\n1869#2:94\n1870#2:96\n1626#2:97\n1#3:95\n*S KotlinDebug\n*F\n+ 1 HibernateCustomJdbcTypeMapper.kt\ncom/intellij/hibernate/HibernateCustomJdbcTypeMapper\n*L\n28#1:82,3\n32#1:85,9\n32#1:94\n32#1:96\n32#1:97\n32#1:95\n*E\n"})
public final class HibernateCustomJdbcTypeMapper
implements CustomJdbcTypeMapper {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getMappedJavaTypeFor(@NotNull DasColumn column, @NotNull Project project) {
        Collection collection;
        boolean isExcluded;
        TableFilter it;
        HibernateReverseEngineering mappings;
        List<DbTypeMapping> list;
        block8: {
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List list2 = DomService.getInstance().getFileElements(HibernateReverseEngineering.class, project, GlobalSearchScope.projectScope((Project)project));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getFileElements(...)");
            DomFileElement domFileElement = (DomFileElement)CollectionsKt.firstOrNull((List)list2);
            if (domFileElement == null || (list = (HibernateReverseEngineering)domFileElement.getRootElement()) == null) {
                List list3 = ContainerUtil.emptyList();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"emptyList(...)");
                return list3;
            }
            mappings = list;
            Iterable $this$any$iv = mappings.getTableFilters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (TableFilter)element$iv;
                    boolean bl = false;
                    if (!(this.locationMatches(column, it) && !this.locationAllowed(it))) continue;
                    v2 = true;
                    break block8;
                }
                v2 = isExcluded = false;
            }
        }
        if (isExcluded) {
            List list4 = ContainerUtil.emptyList();
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"emptyList(...)");
            return list4;
        }
        list = mappings.getTypeConversionMap().get(column.getDasType().toDataType().typeName);
        if (list != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = list;
            boolean $i$f$mapNotNull = false;
            it = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                DbTypeMapping it2 = (DbTypeMapping)element$iv$iv;
                boolean bl2 = false;
                DataType dataType = column.getDasType().toDataType();
                Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"toDataType(...)");
                if ((this.typeMatches(dataType, it2) && HibernateCustomJdbcTypeMapper.matchesConditions$default(this, column.isNotNull(), it2.isNotNull(), false, 4, null) ? it2.getJavaTypeName() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            List list5 = ContainerUtil.emptyList();
            Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"emptyList(...)");
            collection = list5;
        }
        return collection;
    }

    private final boolean typeMatches(DataType actualType, DbTypeMapping mapping) {
        if (!HibernateCustomJdbcTypeMapper.matchesConditions$default(this, actualType.typeName, mapping.getDbTypeName(), false, 4, null)) {
            return false;
        }
        if (!HibernateCustomJdbcTypeMapper.matchesConditions$default(this, actualType.getLength(), mapping.getSize(), false, 4, null)) {
            return false;
        }
        if (!HibernateCustomJdbcTypeMapper.matchesConditions$default(this, actualType.scale, mapping.getScale(), false, 4, null)) {
            return false;
        }
        return HibernateCustomJdbcTypeMapper.matchesConditions$default(this, actualType.getPrecision(), mapping.getPrecision(), false, 4, null);
    }

    private final boolean locationMatches(DasColumn actualColumn, TableFilter filter) {
        DasTable dasTable = actualColumn.getTable();
        if (!this.matchesConditions(dasTable != null ? dasTable.getName() : null, filter.getMatchName().getValue(), true)) {
            return false;
        }
        if (!this.matchesConditions(DasUtil.getSchema((DasObject)((DasObject)actualColumn)), filter.getMatchSchema().getValue(), true)) {
            return false;
        }
        return this.matchesConditions(DasUtil.getCatalog((DasObject)((DasObject)actualColumn)), filter.getMatchCatalog().getValue(), true);
    }

    private final boolean locationAllowed(TableFilter filter) {
        return !Intrinsics.areEqual((Object)filter.getExclude().getValue(), (Object)true);
    }

    private final boolean matchesConditions(Object actual, Object required, boolean isRegexp) {
        Object object;
        if (required == null) {
            return true;
        }
        if (actual == null) {
            return false;
        }
        return isRegexp && required instanceof String && actual instanceof String ? ((object = (Pattern)HibernateCustomJdbcTypeMapperKt.access$getMyCompiledPatterns$p().get(required)) != null && (object = ((Pattern)object).matcher((CharSequence)actual)) != null ? ((Matcher)object).matches() : true) : Intrinsics.areEqual((Object)required, (Object)actual);
    }

    static /* synthetic */ boolean matchesConditions$default(HibernateCustomJdbcTypeMapper hibernateCustomJdbcTypeMapper, Object object, Object object2, boolean bl, int n, Object object3) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return hibernateCustomJdbcTypeMapper.matchesConditions(object, object2, bl);
    }
}

