/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.common;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.common.HttpClient;
import org.jetbrains.kotlinx.jupyter.common.Request;
import org.jetbrains.kotlinx.jupyter.common.RequestBuilder;
import org.jetbrains.kotlinx.jupyter.common.RequestBuilderKt;
import org.jetbrains.kotlinx.jupyter.common.ResponseKt;
import org.jetbrains.kotlinx.jupyter.common.ResponseWrapper;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\"\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007\u001a\u001a\u0010\u000b\u001a\u00020\f*\u00020\f2\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007\u001a\u0012\u0010\u000e\u001a\u00020\f*\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0001\u001a\u001a\u0010\u0013\u001a\u0002H\u0014\"\u0006\b\u0000\u0010\u0014\u0018\u0001*\u00020\u0001H\u0086\b\u00a2\u0006\u0002\u0010\u0015\u001a\u001c\u0010 \u001a\u0004\u0018\u0001H\u0014\"\u0006\b\u0000\u0010\u0014\u0018\u0001*\u00020\u0001H\u0086\b\u00a2\u0006\u0002\u0010\u0015\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u0015\u0010\u0018\u001a\u00020\u0019*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\"\u0015\u0010\u001c\u001a\u00020\u001d*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\"\u0017\u0010!\u001a\u0004\u0018\u00010\u0010*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0017\"\u0017\u0010#\u001a\u0004\u0018\u00010\u0019*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001b\"\u0017\u0010%\u001a\u0004\u0018\u00010\u001d*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001f\u00a8\u0006'"}, d2={"httpRequest", "Lorg/jetbrains/kotlinx/jupyter/common/ResponseWrapper;", "Lorg/jetbrains/kotlinx/jupyter/common/HttpClient;", "request", "Lorg/jetbrains/kotlinx/jupyter/common/Request;", "getHttp", "url", "", "getHttpWithAuth", "username", "token", "withBasicAuth", "Lorg/jetbrains/kotlinx/jupyter/common/RequestBuilder;", "password", "withJson", "json", "Lkotlinx/serialization/json/JsonElement;", "assertSuccessful", "", "decodeJson", "T", "(Lorg/jetbrains/kotlinx/jupyter/common/ResponseWrapper;)Ljava/lang/Object;", "getJson", "(Lorg/jetbrains/kotlinx/jupyter/common/ResponseWrapper;)Lkotlinx/serialization/json/JsonElement;", "jsonObject", "Lkotlinx/serialization/json/JsonObject;", "getJsonObject", "(Lorg/jetbrains/kotlinx/jupyter/common/ResponseWrapper;)Lkotlinx/serialization/json/JsonObject;", "jsonArray", "Lkotlinx/serialization/json/JsonArray;", "getJsonArray", "(Lorg/jetbrains/kotlinx/jupyter/common/ResponseWrapper;)Lkotlinx/serialization/json/JsonArray;", "decodeJsonIfSuccessfulOrNull", "jsonOrNull", "getJsonOrNull", "jsonObjectOrNull", "getJsonObjectOrNull", "jsonArrayOrNull", "getJsonArrayOrNull", "common-dependencies"})
@SourceDebugExtension(value={"SMAP\nHttpUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpUtil.kt\norg/jetbrains/kotlinx/jupyter/common/HttpUtilKt\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,73:1\n55#1,2:76\n55#1,2:79\n55#1,2:82\n64#1,4:86\n68#1:91\n64#1,4:92\n68#1:97\n64#1,4:98\n68#1:103\n205#2:74\n222#2:75\n222#2:78\n222#2:81\n222#2:84\n222#2:85\n222#2:90\n222#2:96\n222#2:102\n*S KotlinDebug\n*F\n+ 1 HttpUtil.kt\norg/jetbrains/kotlinx/jupyter/common/HttpUtilKt\n*L\n59#1:76,2\n60#1:79,2\n61#1:82,2\n70#1:86,4\n70#1:91\n71#1:92,4\n71#1:97\n72#1:98,4\n72#1:103\n45#1:74\n56#1:75\n59#1:78\n60#1:81\n61#1:84\n67#1:85\n70#1:90\n71#1:96\n72#1:102\n*E\n"})
public final class HttpUtilKt {
    @NotNull
    public static final ResponseWrapper httpRequest(@NotNull HttpClient $this$httpRequest, @NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)$this$httpRequest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new ResponseWrapper($this$httpRequest.makeRequest(request), request.getUrl());
    }

    @NotNull
    public static final ResponseWrapper getHttp(@NotNull HttpClient $this$getHttp, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)$this$getHttp, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return HttpUtilKt.httpRequest($this$getHttp, RequestBuilderKt.buildRequest$default("GET", url, null, null, null, 28, null));
    }

    @NotNull
    public static final ResponseWrapper getHttpWithAuth(@NotNull HttpClient $this$getHttpWithAuth, @NotNull String url, @NotNull String username, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)$this$getHttpWithAuth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Request request = RequestBuilderKt.buildRequest$default("GET", url, null, null, arg_0 -> HttpUtilKt.getHttpWithAuth$lambda$0(username, token, arg_0), 12, null);
        return HttpUtilKt.httpRequest($this$getHttpWithAuth, request);
    }

    @NotNull
    public static final RequestBuilder withBasicAuth(@NotNull RequestBuilder $this$withBasicAuth, @NotNull String username, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)$this$withBasicAuth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Base64.Encoder encoder = Base64.getEncoder();
        Object object = username + ":" + password;
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = encoder.encode(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"encode(...)");
        byte[] byArray3 = byArray2;
        object = Charsets.UTF_8;
        String b64 = new String(byArray3, (Charset)object);
        return $this$withBasicAuth.header("Authorization", "Basic " + b64);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RequestBuilder withJson(@NotNull RequestBuilder $this$withJson, @NotNull JsonElement json) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$withJson, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Json json2 = (Json)Json.Default;
        JsonElement value$iv = json;
        boolean $i$f$encodeToString = false;
        SerializersModule serializersModule = this_$iv.getSerializersModule();
        KType kType = Reflection.typeOf(JsonElement.class);
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        return $this$withJson.body(this_$iv.encodeToString((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), (Object)value$iv)).header("Content-Type", "application/json");
    }

    public static final void assertSuccessful(@NotNull ResponseWrapper $this$assertSuccessful) {
        Intrinsics.checkNotNullParameter((Object)$this$assertSuccessful, (String)"<this>");
        if (!ResponseKt.getSuccessful($this$assertSuccessful.getStatus())) {
            throw new IOException("Http request failed. Url = " + $this$assertSuccessful.getUrl() + ". Response = " + $this$assertSuccessful.getText());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T> T decodeJson(ResponseWrapper $this$decodeJson) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$decodeJson, (String)"<this>");
        boolean $i$f$decodeJson = false;
        HttpUtilKt.assertSuccessful($this$decodeJson);
        Json json = (Json)Json.Default;
        String string$iv = $this$decodeJson.getText();
        boolean $i$f$decodeFromString = false;
        SerializersModule serializersModule = this_$iv.getSerializersModule();
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        return (T)this_$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), string$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsonElement getJson(@NotNull ResponseWrapper $this$json) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$json, (String)"<this>");
        ResponseWrapper $this$decodeJson$iv = $this$json;
        boolean $i$f$decodeJson = false;
        HttpUtilKt.assertSuccessful($this$decodeJson$iv);
        Json json = (Json)Json.Default;
        String string$iv$iv = $this$decodeJson$iv.getText();
        boolean $i$f$decodeFromString = false;
        SerializersModule serializersModule = this_$iv$iv.getSerializersModule();
        KType kType = Reflection.typeOf(JsonElement.class);
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        return (JsonElement)this_$iv$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), string$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsonObject getJsonObject(@NotNull ResponseWrapper $this$jsonObject) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$jsonObject, (String)"<this>");
        ResponseWrapper $this$decodeJson$iv = $this$jsonObject;
        boolean $i$f$decodeJson = false;
        HttpUtilKt.assertSuccessful($this$decodeJson$iv);
        Json json = (Json)Json.Default;
        String string$iv$iv = $this$decodeJson$iv.getText();
        boolean $i$f$decodeFromString = false;
        SerializersModule serializersModule = this_$iv$iv.getSerializersModule();
        KType kType = Reflection.typeOf(JsonObject.class);
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        return (JsonObject)this_$iv$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), string$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsonArray getJsonArray(@NotNull ResponseWrapper $this$jsonArray) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$jsonArray, (String)"<this>");
        ResponseWrapper $this$decodeJson$iv = $this$jsonArray;
        boolean $i$f$decodeJson = false;
        HttpUtilKt.assertSuccessful($this$decodeJson$iv);
        Json json = (Json)Json.Default;
        String string$iv$iv = $this$decodeJson$iv.getText();
        boolean $i$f$decodeFromString = false;
        SerializersModule serializersModule = this_$iv$iv.getSerializersModule();
        KType kType = Reflection.typeOf(JsonArray.class);
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        return (JsonArray)this_$iv$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), string$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T> T decodeJsonIfSuccessfulOrNull(ResponseWrapper $this$decodeJsonIfSuccessfulOrNull) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$decodeJsonIfSuccessfulOrNull, (String)"<this>");
        boolean $i$f$decodeJsonIfSuccessfulOrNull = false;
        if (!ResponseKt.getSuccessful($this$decodeJsonIfSuccessfulOrNull.getStatus())) {
            object = null;
        } else {
            void this_$iv;
            Json json = (Json)Json.Default;
            String string$iv = $this$decodeJsonIfSuccessfulOrNull.getText();
            boolean $i$f$decodeFromString = false;
            SerializersModule serializersModule = this_$iv.getSerializersModule();
            Intrinsics.reifiedOperationMarker((int)6, (String)"T?");
            MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
            object = this_$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), string$iv);
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final JsonElement getJsonOrNull(@NotNull ResponseWrapper $this$jsonOrNull) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$jsonOrNull, (String)"<this>");
        ResponseWrapper $this$decodeJsonIfSuccessfulOrNull$iv = $this$jsonOrNull;
        boolean $i$f$decodeJsonIfSuccessfulOrNull = false;
        if (!ResponseKt.getSuccessful($this$decodeJsonIfSuccessfulOrNull$iv.getStatus())) {
            object = null;
        } else {
            void this_$iv$iv;
            Json json = (Json)Json.Default;
            String string$iv$iv = $this$decodeJsonIfSuccessfulOrNull$iv.getText();
            boolean $i$f$decodeFromString = false;
            SerializersModule serializersModule = this_$iv$iv.getSerializersModule();
            KType kType = Reflection.nullableTypeOf(JsonElement.class);
            MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
            object = this_$iv$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), string$iv$iv);
        }
        return (JsonElement)object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final JsonObject getJsonObjectOrNull(@NotNull ResponseWrapper $this$jsonObjectOrNull) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$jsonObjectOrNull, (String)"<this>");
        ResponseWrapper $this$decodeJsonIfSuccessfulOrNull$iv = $this$jsonObjectOrNull;
        boolean $i$f$decodeJsonIfSuccessfulOrNull = false;
        if (!ResponseKt.getSuccessful($this$decodeJsonIfSuccessfulOrNull$iv.getStatus())) {
            object = null;
        } else {
            void this_$iv$iv;
            Json json = (Json)Json.Default;
            String string$iv$iv = $this$decodeJsonIfSuccessfulOrNull$iv.getText();
            boolean $i$f$decodeFromString = false;
            SerializersModule serializersModule = this_$iv$iv.getSerializersModule();
            KType kType = Reflection.nullableTypeOf(JsonObject.class);
            MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
            object = this_$iv$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), string$iv$iv);
        }
        return (JsonObject)object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final JsonArray getJsonArrayOrNull(@NotNull ResponseWrapper $this$jsonArrayOrNull) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$jsonArrayOrNull, (String)"<this>");
        ResponseWrapper $this$decodeJsonIfSuccessfulOrNull$iv = $this$jsonArrayOrNull;
        boolean $i$f$decodeJsonIfSuccessfulOrNull = false;
        if (!ResponseKt.getSuccessful($this$decodeJsonIfSuccessfulOrNull$iv.getStatus())) {
            object = null;
        } else {
            void this_$iv$iv;
            Json json = (Json)Json.Default;
            String string$iv$iv = $this$decodeJsonIfSuccessfulOrNull$iv.getText();
            boolean $i$f$decodeFromString = false;
            SerializersModule serializersModule = this_$iv$iv.getSerializersModule();
            KType kType = Reflection.nullableTypeOf(JsonArray.class);
            MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
            object = this_$iv$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), string$iv$iv);
        }
        return (JsonArray)object;
    }

    private static final Unit getHttpWithAuth$lambda$0(String $username, String $token, RequestBuilder $this$buildRequest) {
        Intrinsics.checkNotNullParameter((Object)$this$buildRequest, (String)"$this$buildRequest");
        HttpUtilKt.withBasicAuth($this$buildRequest, $username, $token);
        return Unit.INSTANCE;
    }
}

