/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.presentable;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.presentable.Capitalization;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.presentable.JSNamedElementKind;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.stubs.JSIndexableImplicitElement;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class JSNamedElementPresenter {
    private final JSNamedElementKind myKind;
    private final Capitalization myCapitalization;
    private final boolean myAddElementKind;
    @NlsSafe
    private String myShortName;
    @NlsSafe
    private String myQualifiedName;
    private final PsiElement myElement;

    public JSNamedElementPresenter(@NotNull PsiElement element) {
        if (element == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(0);
        }
        this(element, Capitalization.LowerCase);
    }

    public JSNamedElementPresenter(@NotNull PsiElement element, @NotNull Capitalization capitalization) {
        if (element == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(1);
        }
        if (capitalization == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(2);
        }
        this(element, capitalization, true);
    }

    public JSNamedElementPresenter(@NotNull PsiElement element, @NotNull Capitalization capitalization, boolean addElementKind) {
        if (element == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(3);
        }
        if (capitalization == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(4);
        }
        this.myKind = JSNamedElementKind.kind(element);
        this.myCapitalization = capitalization;
        this.myAddElementKind = addElementKind;
        this.myElement = element;
    }

    void overrideShortName(@NotNull String name) {
        if (name == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(5);
        }
        this.myShortName = name;
    }

    @NotNull
    @NlsSafe
    public String getQualifiedName() {
        if (this.myQualifiedName != null) {
            String string = this.myQualifiedName;
            if (string == null) {
                JSNamedElementPresenter.$$$reportNull$$$0(6);
            }
            return string;
        }
        this.myQualifiedName = this.computePresentableName(true);
        if (this.myQualifiedName == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(7);
        }
        return this.myQualifiedName;
    }

    @NotNull
    @NlsSafe
    public String getShortName() {
        if (this.myShortName != null) {
            String string = this.myShortName;
            if (string == null) {
                JSNamedElementPresenter.$$$reportNull$$$0(8);
            }
            return string;
        }
        this.myShortName = this.computePresentableName(false);
        if (this.myShortName == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(9);
        }
        return this.myShortName;
    }

    @NotNull
    @Nls
    public String describeElementKind() {
        String message = JavaScriptBundle.message(this.myKind.humanReadableKey(), new Object[0]);
        String string = switch (this.myCapitalization) {
            case Capitalization.UpperCase -> StringUtil.capitalize((String)message);
            case Capitalization.LowerCase -> message;
            default -> StringUtil.capitalizeWords((String)message, (boolean)true);
        };
        if (string == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    @Nls
    private String computePresentableName(boolean qualified) {
        if (qualified) {
            String name;
            if (this.myElement instanceof JSQualifiedNamedElement && (name = ((JSQualifiedNamedElement)this.myElement).getQualifiedName()) != null) {
                String string = name;
                if (string == null) {
                    JSNamedElementPresenter.$$$reportNull$$$0(11);
                }
                return string;
            }
            String string = this.getShortName();
            if (string == null) {
                JSNamedElementPresenter.$$$reportNull$$$0(12);
            }
            return string;
        }
        String name = null;
        if (this.myElement instanceof JSPsiNamedElementBase) {
            name = this.myElement instanceof JSIndexableImplicitElement ? ((JSIndexableImplicitElement)this.myElement).getName() : JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)this.myElement, true);
        } else if (this.myElement instanceof PsiNamedElement) {
            name = ((PsiNamedElement)this.myElement).getName();
        }
        String string = name != null ? name : JSFormatUtil.getAnonymousName(this.myElement);
        if (string == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    @Nls
    public String describeWithShortName() {
        String string = this.describeWithShortName(false);
        if (string == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    @Nls
    public String describeWithShortName(boolean htmlEmphasize) {
        String elementKind = this.describeElementKind();
        if (this.myKind == JSNamedElementKind.ES6_DEFAULT_EXPORT) {
            return this.myAddElementKind ? elementKind : "";
        }
        @Nls String name = this.getShortName();
        if (this.myKind == JSNamedElementKind.CONSTRUCTOR && "constructor".equals(name)) {
            return this.myAddElementKind ? elementKind : "";
        }
        if (htmlEmphasize) {
            Object result = StringUtil.htmlEmphasize((String)name);
            if (this.myAddElementKind) {
                result = elementKind + " " + (String)result;
            }
            String string = result;
            if (string == null) {
                JSNamedElementPresenter.$$$reportNull$$$0(15);
            }
            return string;
        }
        Object object = this.myAddElementKind ? elementKind + " '" + name + "'" : name;
        if (object == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(16);
        }
        return object;
    }

    @NotNull
    public String describeWithQualifiedName() {
        if (this.myKind == JSNamedElementKind.ES6_DEFAULT_EXPORT) {
            return this.myAddElementKind ? this.describeElementKind() : "";
        }
        Object object = this.myAddElementKind ? this.describeElementKind() + " " + this.getQualifiedName() : this.getQualifiedName();
        if (object == null) {
            JSNamedElementPresenter.$$$reportNull$$$0(17);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capitalization";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/presentable/JSNamedElementPresenter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/presentable/JSNamedElementPresenter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "describeElementKind";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "computePresentableName";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "describeWithShortName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "describeWithQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "overrideShortName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> new IllegalStateException(string);
        };
    }
}

