/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.mongodb.json.codeinsight;

import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.persistence.mongodb.json.codeinsight.MongoDBJsonLiteralChecksKt;
import com.intellij.persistence.mongodb.json.highlighting.MongoDBJsonSyntaxHighlighterFactoryKt;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonNumberLiteral;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonPsiUtilKt;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonReferenceExpression;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonStringLiteral;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/persistence/mongodb/json/codeinsight/MongoDBJsonLiteralAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "<init>", "()V", "DEBUG", "", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "highlightPropertyKey", "intellij.javaee.persistence.impl"})
public final class MongoDBJsonLiteralAnnotator
implements Annotator {
    private final boolean DEBUG = ApplicationManager.getApplication().isUnitTestMode();

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (element instanceof MongoDBJsonReferenceExpression) {
            this.highlightPropertyKey(element, holder);
        } else if (element instanceof MongoDBJsonStringLiteral) {
            List<Pair<TextRange, String>> fragments;
            int elementOffset = element.getTextOffset();
            this.highlightPropertyKey(element, holder);
            String string = JsonPsiUtil.getElementTextWithoutHostEscaping((PsiElement)element);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getElementTextWithoutHostEscaping(...)");
            String text = string;
            int length = text.length();
            if (length <= 1 || text.charAt(0) != text.charAt(length - 1) || JsonPsiUtil.isEscapedChar((String)text, (int)(length - 1))) {
                holder.newAnnotation(HighlightSeverity.ERROR, JsonBundle.message((String)"syntax.error.missing.closing.quote", (Object[])new Object[0])).create();
            }
            if ((fragments = ((MongoDBJsonStringLiteral)element).getTextFragments()) != null) {
                for (Pair<TextRange, String> fragment : fragments) {
                    Intrinsics.checkNotNull(fragment);
                    Pair<TextRange, String> error = MongoDBJsonLiteralChecksKt.getErrorForStringFragment(fragment, (MongoDBJsonStringLiteral)element);
                    if (error == null) continue;
                    AnnotationBuilder annotationBuilder = holder.newAnnotation(HighlightSeverity.ERROR, (String)error.second);
                    Object object = error.getFirst();
                    Intrinsics.checkNotNull((Object)object);
                    annotationBuilder.range(((TextRange)object).shiftRight(elementOffset)).create();
                }
            }
        } else if (element instanceof MongoDBJsonNumberLiteral) {
            String string = JsonPsiUtil.getElementTextWithoutHostEscaping((PsiElement)element);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getElementTextWithoutHostEscaping(...)");
            String text = string;
            String error = MongoDBJsonLiteralChecksKt.getErrorForNumericLiteral(text);
            if (error != null) {
                holder.newAnnotation(HighlightSeverity.ERROR, error).create();
            }
        }
    }

    private final void highlightPropertyKey(PsiElement element, AnnotationHolder holder) {
        if (MongoDBJsonPsiUtilKt.isPropertyKey(element)) {
            if (this.DEBUG) {
                holder.newAnnotation(HighlightSeverity.INFORMATION, JsonBundle.message((String)"annotation.property.key", (Object[])new Object[0])).textAttributes(MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_PROPERTY_KEY()).create();
            } else {
                holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_PROPERTY_KEY()).create();
            }
        }
    }
}

