/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.CommandToken;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.ManipulatorsRegistryImpl;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.manipulators.ManipulatorsRegistry;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.persistence.util.PersistenceModelBrowserImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PersistenceHelperImpl
extends PersistenceHelper {
    private static final Logger LOG = Logger.getInstance(PersistenceHelperImpl.class);
    private final ManipulatorsRegistry myManipulatorsRegistry = new ManipulatorsRegistryImpl();

    @Override
    @NotNull
    public ManipulatorsRegistry getManipulatorsRegistry() {
        ManipulatorsRegistry manipulatorsRegistry = this.myManipulatorsRegistry;
        if (manipulatorsRegistry == null) {
            PersistenceHelperImpl.$$$reportNull$$$0(0);
        }
        return manipulatorsRegistry;
    }

    @Override
    @NotNull
    public PersistenceModelBrowser createModelBrowser() {
        return new PersistenceModelBrowserImpl();
    }

    @Override
    public PersistenceModelBrowser getSharedModelBrowser() {
        return PersistenceModelBrowserImpl.INSTANCE;
    }

    @Override
    public void runCompositeWriteCommandAction(final @NotNull Project project, final @Nls @NotNull String actionName, @NotNull Collection<PsiElement> affectedElements, final @NotNull Ref<ProgressIndicator> indicatorRef, final Runnable ... runnables) {
        if (project == null) {
            PersistenceHelperImpl.$$$reportNull$$$0(1);
        }
        if (actionName == null) {
            PersistenceHelperImpl.$$$reportNull$$$0(2);
        }
        if (affectedElements == null) {
            PersistenceHelperImpl.$$$reportNull$$$0(3);
        }
        if (indicatorRef == null) {
            PersistenceHelperImpl.$$$reportNull$$$0(4);
        }
        if (runnables == null) {
            PersistenceHelperImpl.$$$reportNull$$$0(5);
        }
        if (runnables.length == 0) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(affectedElements)) {
            return;
        }
        final Ref commandRef = Ref.create(null);
        final CommandProcessorEx commandProcessorEx = (CommandProcessorEx)CommandProcessor.getInstance();
        commandRef.set((Object)commandProcessorEx.startCommand(project, actionName, (Object)actionName, UndoConfirmationPolicy.REQUEST_CONFIRMATION));
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
        ProgressManager.getInstance().run((Task)new Task.Modal(this, project, actionName, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicatorRef.set((Object)indicator);
                Ref ex = Ref.create(null);
                try {
                    PersistenceHelperImpl.runInner(project, indicator, runnables);
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Exception e) {
                    Throwable reason = e.getCause() != null ? e.getCause() : e;
                    LOG.error(reason);
                    ex.set((Object)reason);
                }
                finally {
                    PersistenceHelperImpl.runInDispatchThread(() -> {
                        String message;
                        try {
                            FileDocumentManager.getInstance().saveAllDocuments();
                        }
                        finally {
                            CommandToken command = (CommandToken)commandRef.get();
                            if (command != null) {
                                commandProcessorEx.finishCommand(command, (Throwable)ex.get());
                            }
                        }
                        if (!ex.isNull() && StringUtil.isNotEmpty((String)(message = StringUtil.getMessage((Throwable)((Throwable)ex.get()))))) {
                            Messages.showMessageDialog((Project)project, (String)message, (String)actionName, (Icon)Messages.getErrorIcon());
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/persistence/PersistenceHelperImpl$1", "run"));
            }
        });
    }

    private static void runInner(Project project, ProgressIndicator indicator, Runnable ... runnables) throws Exception {
        Ref throwableRef;
        block4: {
            throwableRef = Ref.create(null);
            try {
                indicator.setIndeterminate(false);
                indicator.setFraction(0.0);
                Runnable[] clone = (Runnable[])runnables.clone();
                int i = 0;
                while (i < runnables.length && throwableRef.isNull()) {
                    Thread.yield();
                    int index = i++;
                    indicator.setFraction((double)index * 1.0 / (double)runnables.length);
                    indicator.checkCanceled();
                    PersistenceHelperImpl.runInDispatchThread(() -> {
                        try {
                            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                            ApplicationManager.getApplication().runWriteAction(clone[index]);
                        }
                        catch (Exception e) {
                            if (throwableRef.isNull()) {
                                throwableRef.set((Object)e);
                            }
                        }
                        finally {
                            clone[index] = null;
                        }
                    });
                }
            }
            catch (Exception e) {
                if (!throwableRef.isNull()) break block4;
                throwableRef.set((Object)e);
            }
        }
        if (!throwableRef.isNull()) {
            throw (Exception)throwableRef.get();
        }
    }

    private static void runInDispatchThread(Runnable runnable) {
        ApplicationManager.getApplication().invokeAndWait(runnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/persistence/PersistenceHelperImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedElements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicatorRef";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getManipulatorsRegistry";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/persistence/PersistenceHelperImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runCompositeWriteCommandAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

