/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.javaee.web.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.jsp.JavaeeJspBundle;
import com.intellij.jsp.impl.CustomTagDescriptorBase;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.jsp.jspXml.JspScriptlet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.CollapseTagIntention;
import org.jetbrains.annotations.NotNull;

public final class JspTagBodyContentInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JspTagBodyContentInspection.$$$reportNull$$$0(0);
        }
        return new XmlElementVisitor(this){

            public void visitXmlTag(@NotNull XmlTag tag) {
                XmlElementDescriptor descriptor;
                if (tag == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((descriptor = tag.getDescriptor()) instanceof CustomTagDescriptorBase) {
                    int type = descriptor.getContentType();
                    switch (type) {
                        case 0: {
                            if (tag.isEmpty() || ContainerUtil.find((Object[])tag.getValue().getChildren(), tag1 -> {
                                if (tag1 instanceof XmlText && !StringUtil.isEmptyOrSpaces((String)((XmlText)tag1).getValue())) {
                                    return true;
                                }
                                return tag1 instanceof XmlTag && !"http://java.sun.com/JSP/Page".equals(((XmlTag)tag1).getNamespace());
                            }) == null) break;
                            holder.registerProblem((PsiElement)tag, JavaeeJspBundle.message("inspection.message.no.content.allowed.inside.tags.with.empty.content.type", new Object[0]), new LocalQuickFix[]{new CollapseTagIntention(this){

                                public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
                                    if (project == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    return true;
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jsp/javaee/web/inspections/JspTagBodyContentInspection$1$1", "isAvailable"));
                                }
                            }});
                            break;
                        }
                        case 101: {
                            JspScriptlet[] scriptlets = (JspScriptlet[])PsiTreeUtil.getChildrenOfType((PsiElement)tag, JspScriptlet.class);
                            if (scriptlets == null) break;
                            for (JspScriptlet scriptlet : scriptlets) {
                                holder.registerProblem((PsiElement)scriptlet, JavaeeJspBundle.message("inspection.message.scripting.not.allowed.inside.tags.with.scriptless.content.type", new Object[0]), new LocalQuickFix[]{new RemoveScriptletsFix()});
                            }
                            break;
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/jsp/javaee/web/inspections/JspTagBodyContentInspection$1", "visitXmlTag"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/jsp/javaee/web/inspections/JspTagBodyContentInspection", "buildVisitor"));
    }

    private static class RemoveScriptletsFix
    implements LocalQuickFix {
        private RemoveScriptletsFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaeeJspBundle.message("intention.family.name.remove.scriptlet.s", new Object[0]);
            if (string == null) {
                RemoveScriptletsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RemoveScriptletsFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveScriptletsFix.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor.getPsiElement();
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{element.getContainingFile()}).run(() -> {
                JspScriptlet[] scriptlets = (JspScriptlet[])PsiTreeUtil.getChildrenOfType((PsiElement)element.getParent(), JspScriptlet.class);
                assert (scriptlets != null);
                for (JspScriptlet scriptlet : scriptlets) {
                    scriptlet.delete();
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jsp/javaee/web/inspections/JspTagBodyContentInspection$RemoveScriptletsFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jsp/javaee/web/inspections/JspTagBodyContentInspection$RemoveScriptletsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

