/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.util.BuildNumber;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"getQodanaProductName", "", "splitProgressText", "Lkotlin/Pair;", "text", "isInteractiveOutput", "", "intellij.qodana"})
public final class QodanaKt {
    @NotNull
    public static final String getQodanaProductName() {
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getBuild(...)");
        BuildNumber buildNumber2 = buildNumber;
        return switch (buildNumber2.getProductCode()) {
            case "QDJVM" -> "Qodana for JVM";
            case "QDJVMC" -> "Qodana Community for JVM";
            case "QDJVME" -> "Qodana Enterprise for JVM";
            case "QDPY" -> "Qodana for Python";
            case "QDPYC" -> "Qodana Community for Python";
            case "QDANDC" -> "Qodana Community for Android";
            case "QDAND" -> "Qodana for Android";
            case "QDJS" -> "Qodana for JS";
            case "QDPHP" -> "Qodana for PHP";
            case "QDGO" -> "Qodana for Go";
            case "QDRST" -> "Qodana for Rust";
            case "QDRUBY" -> "Qodana for Ruby";
            case "QDNET" -> "Qodana for .NET";
            case "QDCPP" -> "Qodana for C/C++";
            case "IJCA" -> "Qodana Deprecated common";
            default -> "Qodana";
        };
    }

    @NotNull
    public static final Pair<String, String> splitProgressText(@NotNull String text2) {
        String string;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        CharSequence charSequence = text2;
        String[] stringArray2 = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)File.separator, (String)"separator");
        List splitByFileSeparator = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        if (splitByFileSeparator.size() >= 2) {
            stringArray = new String[]{" "};
            List splitForFile = StringsKt.split$default((CharSequence)((CharSequence)splitByFileSeparator.get(splitByFileSeparator.size() - 1)), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            string = (String)splitForFile.get(0);
        } else {
            string = null;
        }
        String file2 = string;
        stringArray = new String[]{" in "};
        List forPrefix = StringsKt.split$default((CharSequence)((CharSequence)splitByFileSeparator.get(0)), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (forPrefix.size() < 2) {
            stringArray = new String[]{" of "};
            forPrefix = StringsKt.split$default((CharSequence)((CharSequence)splitByFileSeparator.get(0)), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        }
        String prefix = (String)forPrefix.get(0);
        return TuplesKt.to((Object)prefix, (Object)file2);
    }

    public static final boolean isInteractiveOutput() {
        return System.console() != null;
    }
}

