/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.component;

import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.ui.component.ChangeLogFileTextField;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u0014J\u001c\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J\u0014\u0010\u001a\u001a\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0006\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/jpa/jpb/model/ui/component/AbstractProjectBrowseFileField;", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "myProject", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "chooserChangeLogDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "getModule", "()Lcom/intellij/openapi/module/Module;", "listeners", "", "Ljava/util/function/Consumer;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDefaultIcon", "Ljavax/swing/Icon;", "safelyInit", "", "installPathCompletion", "fileChooserDescriptor", "parent", "Lcom/intellij/openapi/Disposable;", "addFileChosenListener", "listener", "createFileTextField", "Lcom/intellij/jpa/jpb/model/ui/component/ChangeLogFileTextField;", "ChangeLogBrowseFolderListener", "Companion", "intellij.javaee.jpa.jpb.model.ui"})
public abstract class AbstractProjectBrowseFileField
extends TextFieldWithBrowseButton {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @Nullable
    private final Module module;
    @NotNull
    private final FileChooserDescriptor chooserChangeLogDescriptor;
    @NotNull
    private final List<Consumer<VirtualFile>> listeners;

    public AbstractProjectBrowseFileField(@NotNull Project myProject, @Nullable Module module, @NotNull FileChooserDescriptor chooserChangeLogDescriptor) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)chooserChangeLogDescriptor, (String)"chooserChangeLogDescriptor");
        this.myProject = myProject;
        this.module = module;
        this.chooserChangeLogDescriptor = chooserChangeLogDescriptor;
        this.listeners = new ArrayList();
        this.safelyInit();
    }

    @NotNull
    public final Project getMyProject() {
        return this.myProject;
    }

    @Nullable
    public final Module getModule() {
        return this.module;
    }

    @NotNull
    protected Icon getDefaultIcon() {
        Icon icon = AllIcons.General.OpenDiskHover;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"OpenDiskHover");
        return icon;
    }

    private final void safelyInit() {
        this.addBrowseFolderListener(new ChangeLogBrowseFolderListener(this.chooserChangeLogDescriptor));
        this.setButtonIcon(AllIcons.General.OpenDiskHover);
    }

    protected void installPathCompletion(@Nullable FileChooserDescriptor fileChooserDescriptor) {
    }

    protected void installPathCompletion(@Nullable FileChooserDescriptor fileChooserDescriptor, @Nullable Disposable parent) {
    }

    public final void addFileChosenListener(@NotNull Consumer<VirtualFile> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.listeners.add(listener);
    }

    @NotNull
    public final ChangeLogFileTextField createFileTextField() {
        LocalFsFinder finder = new LocalFsFinder();
        Object object = ProjectUtil.guessProjectDir((Project)this.myProject);
        if (object == null || (object = object.getPath()) == null) {
            object = "";
        }
        finder.setBaseDir(new File((String)object));
        FileLookup.Finder finder2 = (FileLookup.Finder)finder;
        JTextField jTextField = this.getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getTextField(...)");
        return new ChangeLogFileTextField(this.myProject, finder2, this.chooserChangeLogDescriptor, jTextField, this);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\n\u0010\n\u001a\u0004\u0018\u00010\tH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/jpa/jpb/model/ui/component/AbstractProjectBrowseFileField$ChangeLogBrowseFolderListener;", "Lcom/intellij/openapi/ui/TextBrowseFolderListener;", "chooserChangeLogDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "<init>", "(Lcom/intellij/jpa/jpb/model/ui/component/AbstractProjectBrowseFileField;Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;)V", "chosenFileToResultingText", "", "chosenFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getInitialFile", "onFileChosen", "", "intellij.javaee.jpa.jpb.model.ui"})
    @SourceDebugExtension(value={"SMAP\nAbstractProjectBrowseFileField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractProjectBrowseFileField.kt\ncom/intellij/jpa/jpb/model/ui/component/AbstractProjectBrowseFileField$ChangeLogBrowseFolderListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1869#2,2:133\n*S KotlinDebug\n*F\n+ 1 AbstractProjectBrowseFileField.kt\ncom/intellij/jpa/jpb/model/ui/component/AbstractProjectBrowseFileField$ChangeLogBrowseFolderListener\n*L\n88#1:133,2\n*E\n"})
    public final class ChangeLogBrowseFolderListener
    extends TextBrowseFolderListener {
        public ChangeLogBrowseFolderListener(FileChooserDescriptor chooserChangeLogDescriptor) {
            Intrinsics.checkNotNullParameter((Object)chooserChangeLogDescriptor, (String)"chooserChangeLogDescriptor");
            super(chooserChangeLogDescriptor, AbstractProjectBrowseFileField.this.getMyProject());
        }

        @NotNull
        protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
            String relativePath;
            String string;
            String string2;
            Intrinsics.checkNotNullParameter((Object)chosenFile, (String)"chosenFile");
            VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)AbstractProjectBrowseFileField.this.getMyProject());
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                string2 = VfsUtilCore.getRelativePath((VirtualFile)chosenFile, (VirtualFile)it);
            } else {
                string2 = null;
            }
            if ((string = (relativePath = string2)) == null) {
                String string3 = chosenFile.getPath();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
            }
            return string;
        }

        @Nullable
        protected VirtualFile getInitialFile() {
            String string = AbstractProjectBrowseFileField.this.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String fieldText = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (StringsKt.isBlank((CharSequence)fieldText)) {
                return null;
            }
            String string2 = FileUtil.toSystemIndependentName((String)fieldText);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
            fieldText = string2;
            Module module = AbstractProjectBrowseFileField.this.getModule();
            if ((module == null || (module = ProjectUtil.guessModuleDir((Module)module)) == null) && (module = ProjectUtil.guessProjectDir((Project)AbstractProjectBrowseFileField.this.getMyProject())) == null) {
                return null;
            }
            Module rootDie = module;
            for (int i = 0; i < 11; ++i) {
                VirtualFile file;
                VirtualFile virtualFile = file = VfsUtil.findRelativeFile((String)fieldText, (VirtualFile)rootDie);
                if (virtualFile != null) {
                    return virtualFile;
                }
                if (!StringsKt.contains$default((CharSequence)fieldText, (char)'/', (boolean)false, (int)2, null)) {
                    return null;
                }
                fieldText = StringsKt.substringBeforeLast$default((String)fieldText, (char)'/', null, (int)2, null);
            }
            return null;
        }

        protected void onFileChosen(@NotNull VirtualFile chosenFile) {
            Intrinsics.checkNotNullParameter((Object)chosenFile, (String)"chosenFile");
            super.onFileChosen(chosenFile);
            Iterable $this$forEach$iv = AbstractProjectBrowseFileField.this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Consumer it = (Consumer)element$iv;
                boolean bl = false;
                it.accept(chosenFile);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jpa/jpb/model/ui/component/AbstractProjectBrowseFileField$Companion;", "", "<init>", "()V", "getAbsolutePath", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "path", "intellij.javaee.jpa.jpb.model.ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getAbsolutePath(@NotNull Project project, @Nullable Module module, @NotNull String path) {
            Object object;
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    Module module2 = module;
                    if (module2 == null || (module2 = ProjectUtil.guessModuleDir((Module)module2)) == null) {
                        module2 = object = ProjectUtil.guessProjectDir((Project)project);
                    }
                    if (module2 == null) break block6;
                    Module it = object;
                    boolean bl = false;
                    String pathPrepared = path;
                    if (StringsKt.startsWith$default((String)pathPrepared, (String)"src/main/", (boolean)false, (int)2, null)) {
                        String string = it.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        if (StringsKt.endsWith$default((String)string, (String)"/src/main", (boolean)false, (int)2, null)) {
                            pathPrepared = StringsKt.removePrefix((String)pathPrepared, (CharSequence)"src/main/");
                        }
                    }
                    File file = VfsUtil.virtualToIoFile((VirtualFile)it);
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"virtualToIoFile(...)");
                    String absolutePath = FilesKt.resolve((File)file, (String)pathPrepared).getAbsolutePath();
                    String string = FileUtil.toSystemIndependentName((String)absolutePath);
                    object = string;
                    if (string != null) break block7;
                }
                object = path;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

