/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.util;

import com.intellij.codeInsight.highlighting.BraceHighlightingHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class JpbXmlUtil {
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String unescape(@Nullable String text) {
        return text != null ? StringUtil.unescapeXmlEntities((String)text) : null;
    }

    @Nullable
    public static XmlTag findTag(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        if (element instanceof XmlTag) {
            return (XmlTag)element;
        }
        if (element.getParent() instanceof XmlTag) {
            return (XmlTag)element.getParent();
        }
        PsiElement correctTagChild = null;
        if (element instanceof XmlElement) {
            correctTagChild = element;
        } else if (offset > 0 && element instanceof PsiWhiteSpace) {
            correctTagChild = JpbXmlUtil.findTagForWhiteSpaceCase(editor, file, offset);
        }
        return correctTagChild == null ? null : (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)correctTagChild, XmlTag.class);
    }

    @Nullable
    public static PsiElement findTagForWhiteSpaceCase(Editor editor, PsiFile file, int offset) {
        EditorHighlighter highlighter = BraceHighlightingHandler.getLazyParsableHighlighterIfAny((Project)file.getProject(), (Editor)editor, (PsiFile)file);
        HighlighterIterator iterator = highlighter.createIterator(offset);
        if (iterator.atEnd()) {
            return null;
        }
        int startIdx = iterator.getStart() - 1;
        int endIdx = iterator.getEnd();
        Document document = editor.getDocument();
        if (startIdx < 0 || endIdx >= document.getTextLength()) {
            return null;
        }
        int currentLine = document.getLineNumber(offset);
        int endLine = document.getLineNumber(endIdx);
        int startLine = document.getLineNumber(startIdx);
        PsiElement endElement = file.findElementAt(endIdx);
        PsiElement startElement = file.findElementAt(startIdx);
        if (currentLine == startLine && currentLine == endLine && endElement instanceof PsiWhiteSpace) {
            return startElement;
        }
        if (currentLine == endLine) {
            return endElement;
        }
        if (currentLine == startLine) {
            return startElement;
        }
        return file.findElementAt(offset);
    }

    public static XmlTag addSubTag(XmlTag ancestorTag, String localName) {
        return JpbXmlUtil.addSubTag(ancestorTag, localName, false);
    }

    public static XmlTag addSubTag(XmlTag ancestorTag, String localName, boolean isFirst) {
        return ancestorTag.addSubTag(ancestorTag.createChildTag(localName, null, null, false), isFirst);
    }
}

