/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import java.awt.event.ActionListener;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StateConfigurable<State>
implements Configurable {
    protected final ActionListener modifyListener = event -> {
        this.isModified = true;
    };
    protected final DocumentListener documentListener = e -> {
        this.isModified = true;
    };
    protected final ChangeListener changeListener = event -> {
        this.isModified = true;
    };
    protected boolean isModified = false;

    @Nullable
    protected abstract State getState();

    protected void validate() throws ConfigurationException {
    }

    protected abstract void saveToState(@NotNull State var1);

    protected abstract void loadFromState(@NotNull State var1);

    public boolean isModified() {
        return this.isModified;
    }

    public void apply() throws ConfigurationException {
        this.validate();
        State state = this.getState();
        if (state != null) {
            this.saveToState(state);
        }
        this.isModified = false;
    }

    public void reset() {
        State state = this.getState();
        if (state != null) {
            this.loadFromState(state);
        }
        this.isModified = false;
    }
}

