/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.target.vagrant;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.target.BrowsableTargetEnvironmentType;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurationKt;
import com.intellij.execution.target.TargetEnvironmentWizard;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.VagrantSupport;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.StatusPanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.target.vagrant.VagrantEnvironmentConfiguration;
import com.jetbrains.plugins.remotesdk.target.vagrant.VagrantTargetConfigurable;
import com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkUIUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 B2\u00020\u00012\u00020\u0002:\u0001BB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#J\b\u0010$\u001a\u00020%H\u0016J\u001a\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00192\b\u0010)\u001a\u0004\u0018\u00010\u0019H\u0002J.\u0010*\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00192\b\u0010)\u001a\u0004\u0018\u00010\u00192\n\u0010+\u001a\u00060,R\u00020\u00122\u0006\u0010-\u001a\u00020.H\u0002J\u001a\u0010/\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u00192\b\u0010)\u001a\u0004\u0018\u00010\u0019H\u0002J-\u00100\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00192\r\u0010)\u001a\t\u0018\u00010\u0019\u00a2\u0006\u0002\b12\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001903H\u0002J\n\u00104\u001a\u0004\u0018\u00010\u0019H\u0002J\u0010\u00105\u001a\u00020'2\u0006\u00106\u001a\u00020\"H\u0002J\b\u00107\u001a\u00020\"H\u0002J)\u00108\u001a\u00020'2\b\u00109\u001a\u0004\u0018\u00010:2\u000b\u0010;\u001a\u00070\u0019\u00a2\u0006\u0002\b12\b\u0010)\u001a\u0004\u0018\u00010\u0019H\u0002J\u001a\u0010<\u001a\u00020'2\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010=\u001a\u00020'2\u0006\u0010>\u001a\u00020 J\b\u0010?\u001a\u00020'H\u0002J\b\u0010@\u001a\u00020AH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/vagrant/VagrantTargetConfigurable;", "Lcom/intellij/openapi/options/BoundConfigurable;", "Lcom/intellij/execution/target/BrowsableTargetEnvironmentType$ConfigurableCurrentConfigurationProvider;", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lcom/jetbrains/plugins/remotesdk/target/vagrant/VagrantEnvironmentConfiguration;", "primaryLanguage", "Lcom/intellij/execution/target/LanguageRuntimeType;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/plugins/remotesdk/target/vagrant/VagrantEnvironmentConfiguration;Lcom/intellij/execution/target/LanguageRuntimeType;)V", "getPrimaryLanguage$intellij_remoteRun", "()Lcom/intellij/execution/target/LanguageRuntimeType;", "setPrimaryLanguage$intellij_remoteRun", "(Lcom/intellij/execution/target/LanguageRuntimeType;)V", "vagrantCredentials", "Lcom/intellij/remote/VagrantBasedCredentialsHolder;", "statusPanel", "Lcom/intellij/ui/StatusPanel;", "vagrantInstanceTextField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "machineNameRow", "Lcom/intellij/ui/dsl/builder/Row;", "machineNameComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "", "vagrantHostUrl", "Ljavax/swing/JLabel;", "vagrantSupport", "Lcom/intellij/remote/VagrantSupport;", "connectionParametersRetrievedListeners", "", "Ljava/awt/event/ActionListener;", "isComplete", "", "isComplete$intellij_remoteRun", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "vagrantSelected", "", "vagrantFolder", "machineName", "updateStatus", "loadConfigAction", "Lcom/intellij/ui/StatusPanel$Action;", "recursion", "", "initVagrantMachineSelection", "setMultipleMachinesMode", "Lcom/intellij/openapi/util/NlsSafe;", "machineNames", "", "getVagrantMachineName", "setVagrantMachineSelectionVisible", "value", "isVagrantMultipleMachines", "useVagrantSettings", "credentials", "Lcom/intellij/remote/RemoteCredentials;", "instanceFolder", "setVagrantCredentials", "addConnectionParametersRetrievedListener", "listener", "fireConnectionParametersRetrievedListeners", "getCurrentConfiguration", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "Companion", "intellij.remoteRun"})
@SourceDebugExtension(value={"SMAP\nVagrantTargetConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VagrantTargetConfigurable.kt\ncom/jetbrains/plugins/remotesdk/target/vagrant/VagrantTargetConfigurable\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,255:1\n42#2,3:256\n1869#3,2:259\n*S KotlinDebug\n*F\n+ 1 VagrantTargetConfigurable.kt\ncom/jetbrains/plugins/remotesdk/target/vagrant/VagrantTargetConfigurable\n*L\n54#1:256,3\n242#1:259,2\n*E\n"})
public final class VagrantTargetConfigurable
extends BoundConfigurable
implements BrowsableTargetEnvironmentType.ConfigurableCurrentConfigurationProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VagrantEnvironmentConfiguration config;
    @Nullable
    private LanguageRuntimeType<?> primaryLanguage;
    @Nullable
    private VagrantBasedCredentialsHolder vagrantCredentials;
    @NotNull
    private final StatusPanel statusPanel;
    private TextFieldWithBrowseButton vagrantInstanceTextField;
    private Row machineNameRow;
    private ComboBox<String> machineNameComboBox;
    private JLabel vagrantHostUrl;
    @NotNull
    private final VagrantSupport vagrantSupport;
    @NotNull
    private final List<ActionListener> connectionParametersRetrievedListeners;
    @NotNull
    private static final String CONNECTION_PARAMETERS_RETRIEVED = "connectionParametersRetrieved";

    /*
     * WARNING - void declaration
     */
    public VagrantTargetConfigurable(@NotNull Project project, @NotNull VagrantEnvironmentConfiguration config, @Nullable LanguageRuntimeType<?> primaryLanguage) {
        void $this$statusPanel_u24lambda_u240;
        StatusPanel statusPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        super(config.getDisplayName(), TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)config).getHelpTopic());
        this.project = project;
        this.config = config;
        this.primaryLanguage = primaryLanguage;
        StatusPanel statusPanel2 = statusPanel = new StatusPanel();
        VagrantTargetConfigurable vagrantTargetConfigurable = this;
        boolean bl = false;
        $this$statusPanel_u24lambda_u240.withPreferredWidth(JBUI.scale((int)400));
        vagrantTargetConfigurable.statusPanel = statusPanel;
        boolean $i$f$service = false;
        Class<VagrantSupport> serviceClass$iv = VagrantSupport.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.vagrantSupport = (VagrantSupport)object;
        this.connectionParametersRetrievedListeners = new ArrayList();
    }

    @Nullable
    public final LanguageRuntimeType<?> getPrimaryLanguage$intellij_remoteRun() {
        return this.primaryLanguage;
    }

    public final void setPrimaryLanguage$intellij_remoteRun(@Nullable LanguageRuntimeType<?> languageRuntimeType) {
        this.primaryLanguage = languageRuntimeType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isComplete$intellij_remoteRun() {
        JLabel jLabel = this.vagrantHostUrl;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vagrantHostUrl");
            jLabel = null;
        }
        String string = jLabel.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string)) return false;
        boolean bl = true;
        if (!bl) return false;
        ComboBox<String> comboBox = this.machineNameComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"machineNameComboBox");
            comboBox = null;
        }
        if (!comboBox.isVisible()) return true;
        ComboBox<String> comboBox2 = this.machineNameComboBox;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"machineNameComboBox");
            comboBox2 = null;
        }
        if (comboBox2.getSelectedItem() == null) return false;
        return true;
    }

    @NotNull
    public DialogPanel createPanel() {
        String defaultVagrantFolder;
        CharSequence charSequence = this.config.getVagrantFolder();
        if ((charSequence == null || charSequence.length() == 0) && (defaultVagrantFolder = this.vagrantSupport.findVagrantFolder(this.project)) != null) {
            this.config.setVagrantFolder(FileUtil.toSystemDependentName((String)defaultVagrantFolder));
        }
        String initialVagrantFolder = this.config.getVagrantFolder();
        DialogPanel panel2 = BuilderKt.panel(arg_0 -> VagrantTargetConfigurable.createPanel$lambda$0(this, arg_0));
        panel2.setBorder((Border)JBUI.Borders.empty((int)12, (int)TargetEnvironmentWizard.Companion.defaultDialogInsets().right));
        this.setVagrantMachineSelectionVisible(false);
        if (initialVagrantFolder != null) {
            this.vagrantSelected(initialVagrantFolder, null);
        }
        return panel2;
    }

    private final void vagrantSelected(String vagrantFolder, String machineName) {
        StatusPanel.Action action = this.statusPanel.progress(RemoteSdkBundle.message("loading.vagrant.config", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)action, (String)"progress(...)");
        StatusPanel.Action loadConfigAction = action;
        JLabel jLabel = this.vagrantHostUrl;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vagrantHostUrl");
            jLabel = null;
        }
        jLabel.setText("");
        if (StringUtil.isNotEmpty((String)machineName)) {
            if (!this.isVagrantMultipleMachines()) {
                this.initVagrantMachineSelection(vagrantFolder, machineName);
            }
        } else {
            if (!this.isVagrantMultipleMachines()) {
                List list = this.vagrantSupport.getMachineNames(vagrantFolder);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMachineNames(...)");
                List machineNames = list;
                if (machineNames.size() > 1) {
                    this.setMultipleMachinesMode(vagrantFolder, machineName, machineNames);
                }
            }
            if (this.isVagrantMultipleMachines()) {
                loadConfigAction.failed(RemoteSdkBundle.message("dialog.message.multiple.machine.configuration.detected.please.select.machine.name", new Object[0]));
                return;
            }
        }
        this.updateStatus(vagrantFolder, machineName, loadConfigAction, 0);
    }

    private final void updateStatus(String vagrantFolder, String machineName, StatusPanel.Action loadConfigAction, int recursion) {
        if (recursion > 5) {
            loadConfigAction.failed(RemoteSdkBundle.message("dialog.message.couldn.t.connect.to.vagrant", new Object[0]));
            return;
        }
        Futures.addCallback((ListenableFuture)this.vagrantSupport.computeVagrantSettings(this.project, vagrantFolder, machineName), (FutureCallback)((FutureCallback)new FutureCallback<RemoteCredentials>(loadConfigAction, this, vagrantFolder, machineName, recursion){
            final /* synthetic */ StatusPanel.Action $loadConfigAction;
            final /* synthetic */ VagrantTargetConfigurable this$0;
            final /* synthetic */ String $vagrantFolder;
            final /* synthetic */ String $machineName;
            final /* synthetic */ int $recursion;
            {
                this.$loadConfigAction = $loadConfigAction;
                this.this$0 = $receiver;
                this.$vagrantFolder = $vagrantFolder;
                this.$machineName = $machineName;
                this.$recursion = $recursion;
            }

            public void onSuccess(RemoteCredentials credentials) {
                UIUtil.invokeLaterIfNeeded(() -> updateStatus.1.onSuccess$lambda$0(this.$loadConfigAction, this.this$0, credentials, this.$vagrantFolder, this.$machineName));
            }

            public void onFailure(Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                if (t instanceof VagrantSupport.MultipleMachinesException) {
                    if (VagrantTargetConfigurable.access$initVagrantMachineSelection(this.this$0, this.$vagrantFolder, this.$machineName)) {
                        VagrantTargetConfigurable.access$vagrantSelected(this.this$0, this.$vagrantFolder, this.$machineName);
                        this.$loadConfigAction.done();
                        return;
                    }
                } else if (VagrantTargetConfigurable.access$getVagrantSupport$p(this.this$0).isNotReadyForSsh(t) && VagrantTargetConfigurable.access$getVagrantSupport$p(this.this$0).checkVagrantRunning(this.$vagrantFolder, this.$machineName, true)) {
                    VagrantTargetConfigurable.access$updateStatus(this.this$0, this.$vagrantFolder, this.$machineName, this.$loadConfigAction, this.$recursion + 1);
                    return;
                }
                UIUtil.invokeLaterIfNeeded(() -> updateStatus.1.onFailure$lambda$1(this.this$0, this.$loadConfigAction, t));
            }

            private static final void onSuccess$lambda$0(StatusPanel.Action $loadConfigAction, VagrantTargetConfigurable this$0, RemoteCredentials $credentials, String $vagrantFolder, String $machineName) {
                $loadConfigAction.done();
                VagrantTargetConfigurable.access$useVagrantSettings(this$0, $credentials, $vagrantFolder, $machineName);
            }

            private static final void onFailure$lambda$1(VagrantTargetConfigurable this$0, StatusPanel.Action $loadConfigAction, Throwable $t) {
                JLabel jLabel = VagrantTargetConfigurable.access$getVagrantHostUrl$p(this$0);
                if (jLabel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"vagrantHostUrl");
                    jLabel = null;
                }
                jLabel.setText("");
                Object[] objectArray = new Object[]{$t.getMessage()};
                $loadConfigAction.failed(RemoteSdkBundle.message("dialog.message.can.t.get.vagrant.settings", objectArray));
            }
        }), (Executor)AppExecutorUtil.getAppExecutorService());
    }

    private final boolean initVagrantMachineSelection(String vagrantFolder, String machineName) {
        boolean bl;
        List list = this.vagrantSupport.getMachineNames(vagrantFolder);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMachineNames(...)");
        List machineNames = list;
        if (machineNames.size() > 1) {
            this.setMultipleMachinesMode(vagrantFolder, machineName, machineNames);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void setMultipleMachinesMode(String vagrantFolder, String machineName, List<String> machineNames) {
        ComboBox<String> comboBox = this.machineNameComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"machineNameComboBox");
            comboBox = null;
        }
        ItemListener[] itemListenerArray = comboBox.getItemListeners();
        Intrinsics.checkNotNullExpressionValue((Object)itemListenerArray, (String)"getItemListeners(...)");
        for (ItemListener l : itemListenerArray) {
            ComboBox<String> comboBox2 = this.machineNameComboBox;
            if (comboBox2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"machineNameComboBox");
                comboBox2 = null;
            }
            comboBox2.removeItemListener(l);
        }
        ComboBox<String> comboBox3 = this.machineNameComboBox;
        if (comboBox3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"machineNameComboBox");
            comboBox3 = null;
        }
        comboBox3.setModel((ComboBoxModel)new CollectionComboBoxModel((List)Lists.newArrayList((Iterable)Iterables.concat((Iterable)CollectionsKt.listOf(null), (Iterable)machineNames))));
        ComboBox<String> comboBox4 = this.machineNameComboBox;
        if (comboBox4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"machineNameComboBox");
            comboBox4 = null;
        }
        comboBox4.setSelectedItem((Object)machineName);
        ComboBox<String> comboBox5 = this.machineNameComboBox;
        if (comboBox5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"machineNameComboBox");
            comboBox5 = null;
        }
        comboBox5.addItemListener(arg_0 -> VagrantTargetConfigurable.setMultipleMachinesMode$lambda$0(this, vagrantFolder, arg_0));
        UIUtil.invokeLaterIfNeeded(() -> VagrantTargetConfigurable.setMultipleMachinesMode$lambda$1(this));
    }

    private final String getVagrantMachineName() {
        if (!this.isVagrantMultipleMachines()) {
            return null;
        }
        ComboBox<String> comboBox = this.machineNameComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"machineNameComboBox");
            comboBox = null;
        }
        Object object = comboBox.getSelectedItem();
        return object != null ? object.toString() : null;
    }

    private final void setVagrantMachineSelectionVisible(boolean value) {
        Row row = this.machineNameRow;
        if (row == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"machineNameRow");
            row = null;
        }
        row.visible(value);
        ComboBox<String> comboBox = this.machineNameComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"machineNameComboBox");
            comboBox = null;
        }
        comboBox.setVisible(value);
    }

    private final boolean isVagrantMultipleMachines() {
        ComboBox<String> comboBox = this.machineNameComboBox;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"machineNameComboBox");
            comboBox = null;
        }
        return comboBox.isVisible();
    }

    private final void useVagrantSettings(RemoteCredentials credentials, String instanceFolder, String machineName) {
        this.setVagrantCredentials(credentials, new VagrantBasedCredentialsHolder(instanceFolder, machineName));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.vagrantInstanceTextField;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vagrantInstanceTextField");
            textFieldWithBrowseButton = null;
        }
        textFieldWithBrowseButton.setText(instanceFolder);
        if (StringUtil.isNotEmpty((String)machineName) && !this.isVagrantMultipleMachines()) {
            this.initVagrantMachineSelection(instanceFolder, machineName);
        }
    }

    private final void setVagrantCredentials(RemoteCredentials credentials, VagrantBasedCredentialsHolder vagrantCredentials) {
        JLabel jLabel;
        this.vagrantCredentials = vagrantCredentials;
        Runnable validator = null;
        JLabel jLabel2 = this.vagrantHostUrl;
        if (jLabel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vagrantHostUrl");
            jLabel2 = null;
        }
        if ((jLabel = this.vagrantHostUrl) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"vagrantHostUrl");
            jLabel = null;
        }
        CreateRemoteSdkUIUtil.useReferencedCredentials(this.project, this.statusPanel, validator, credentials, jLabel2, jLabel, () -> VagrantTargetConfigurable.setVagrantCredentials$lambda$0(this, vagrantCredentials, validator));
        if (credentials != null) {
            this.fireConnectionParametersRetrievedListeners();
        }
    }

    public final void addConnectionParametersRetrievedListener(@NotNull ActionListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ((Collection)this.connectionParametersRetrievedListeners).add(listener);
    }

    private final void fireConnectionParametersRetrievedListeners() {
        Iterable $this$forEach$iv = this.connectionParametersRetrievedListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ActionListener it = (ActionListener)element$iv;
            boolean bl = false;
            it.actionPerformed(new ActionEvent((Object)this, 1001, CONNECTION_PARAMETERS_RETRIEVED));
        }
    }

    @NotNull
    public TargetEnvironmentConfiguration getCurrentConfiguration() {
        return this.config;
    }

    private static final Unit createPanel$lambda$0(VagrantTargetConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = RemoteSdkBundle.message("vagrant.instance.folder.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> VagrantTargetConfigurable.createPanel$lambda$0$0(this$0, arg_0));
        String string2 = RemoteSdkBundle.message("vagrant.machine.name.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this$0.machineNameRow = $this$panel.row(string2, arg_0 -> VagrantTargetConfigurable.createPanel$lambda$0$1(this$0, arg_0));
        String string3 = RemoteSdkBundle.message("vagrant.host.url.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$panel.row(string3, arg_0 -> VagrantTargetConfigurable.createPanel$lambda$0$2(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> VagrantTargetConfigurable.createPanel$lambda$0$3(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0(VagrantTargetConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(RemoteSdkBundle.message("vagrant.host.url.label", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"withTitle(...)");
        this$0.vagrantInstanceTextField = (TextFieldWithBrowseButton)TextFieldWithBrowseButtonKt.bindText((Cell)$this$row.textFieldWithBrowseButton(fileChooserDescriptor, this$0.project, arg_0 -> VagrantTargetConfigurable.createPanel$lambda$0$0$0(this$0, arg_0)), () -> VagrantTargetConfigurable.createPanel$lambda$0$0$1(this$0), arg_0 -> VagrantTargetConfigurable.createPanel$lambda$0$0$2(this$0, arg_0)).align((Align)AlignX.FILL.INSTANCE).getComponent();
        return Unit.INSTANCE;
    }

    private static final String createPanel$lambda$0$0$0(VagrantTargetConfigurable this$0, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String vagrantFolderPath = string;
        this$0.setVagrantMachineSelectionVisible(false);
        this$0.vagrantSelected(vagrantFolderPath, null);
        return vagrantFolderPath;
    }

    private static final String createPanel$lambda$0$0$1(VagrantTargetConfigurable this$0) {
        String string = this$0.config.getVagrantFolder();
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static final Unit createPanel$lambda$0$0$2(VagrantTargetConfigurable this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.config.setVagrantFolder(it);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1(VagrantTargetConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.machineNameComboBox = (ComboBox)ComboBoxKt.bindItem((Cell)Row.comboBox$default((Row)$this$row, (ComboBoxModel)new DefaultComboBoxModel(), null, (int)2, null), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0.config){

            public Object get() {
                return ((VagrantEnvironmentConfiguration)((Object)this.receiver)).getMachineName();
            }

            public void set(Object value) {
                ((VagrantEnvironmentConfiguration)((Object)this.receiver)).setMachineName((String)value);
            }
        })).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2(VagrantTargetConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.vagrantHostUrl = (JLabel)$this$row.label("").getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3(VagrantTargetConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.statusPanel).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final void setMultipleMachinesMode$lambda$0(VagrantTargetConfigurable this$0, String $vagrantFolder, ItemEvent it) {
        this$0.vagrantSelected($vagrantFolder, this$0.getVagrantMachineName());
    }

    private static final void setMultipleMachinesMode$lambda$1(VagrantTargetConfigurable this$0) {
        this$0.setVagrantMachineSelectionVisible(true);
    }

    private static final void setVagrantCredentials$lambda$0(VagrantTargetConfigurable this$0, VagrantBasedCredentialsHolder $vagrantCredentials, Runnable $validator) {
        block1: {
            if (this$0.vagrantSupport.checkVagrantRunning($vagrantCredentials.getVagrantFolder(), $vagrantCredentials.getMachineName(), true)) break block1;
            Runnable runnable = $validator;
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public static final /* synthetic */ boolean access$initVagrantMachineSelection(VagrantTargetConfigurable $this, String vagrantFolder, String machineName) {
        return $this.initVagrantMachineSelection(vagrantFolder, machineName);
    }

    public static final /* synthetic */ void access$vagrantSelected(VagrantTargetConfigurable $this, String vagrantFolder, String machineName) {
        $this.vagrantSelected(vagrantFolder, machineName);
    }

    public static final /* synthetic */ VagrantSupport access$getVagrantSupport$p(VagrantTargetConfigurable $this) {
        return $this.vagrantSupport;
    }

    public static final /* synthetic */ void access$updateStatus(VagrantTargetConfigurable $this, String vagrantFolder, String machineName, StatusPanel.Action loadConfigAction, int recursion) {
        $this.updateStatus(vagrantFolder, machineName, loadConfigAction, recursion);
    }

    public static final /* synthetic */ void access$useVagrantSettings(VagrantTargetConfigurable $this, RemoteCredentials credentials, String instanceFolder, String machineName) {
        $this.useVagrantSettings(credentials, instanceFolder, machineName);
    }

    public static final /* synthetic */ JLabel access$getVagrantHostUrl$p(VagrantTargetConfigurable $this) {
        return $this.vagrantHostUrl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/vagrant/VagrantTargetConfigurable$Companion;", "", "<init>", "()V", "CONNECTION_PARAMETERS_RETRIEVED", "", "intellij.remoteRun"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

