/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.directives.FtlAssignmentType;
import com.intellij.freemarker.psi.directives.FtlMacro;
import com.intellij.freemarker.psi.variables.FtlTemplateType;
import com.intellij.psi.ResolveState;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

class ResolveStateParameters {
    final boolean honorAssigns;
    final boolean resolvingMacro;
    final boolean processingNamespace;
    final EnumSet<FtlAssignmentType> allowedAssignments;
    @Nullable
    private final Set<FtlMacro> macroStack;

    ResolveStateParameters(boolean honorAssigns, ResolveState state) {
        this.honorAssigns = honorAssigns;
        this.resolvingMacro = state.get(FtlQualifiedReference.RESOLVING_MACRO) == Boolean.TRUE;
        this.processingNamespace = state.get(FtlTemplateType.PROCESSING_NAMESPACE) == Boolean.TRUE;
        this.allowedAssignments = (EnumSet)state.get(FtlAssignmentType.TYPE_KEY);
        this.macroStack = ResolveStateParameters.cloneOrNull((Set)state.get(FtlMacro.MACRO_STACK));
    }

    @Nullable
    private static Set<FtlMacro> cloneOrNull(@Nullable Set<FtlMacro> stack) {
        return stack == null ? null : new HashSet<FtlMacro>(stack);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResolveStateParameters)) {
            return false;
        }
        ResolveStateParameters that = (ResolveStateParameters)o;
        if (this.honorAssigns != that.honorAssigns) {
            return false;
        }
        if (this.processingNamespace != that.processingNamespace) {
            return false;
        }
        if (this.resolvingMacro != that.resolvingMacro) {
            return false;
        }
        return Objects.equals(this.allowedAssignments, that.allowedAssignments) && Objects.equals(this.macroStack, that.macroStack);
    }

    public int hashCode() {
        return Objects.hash(this.honorAssigns, this.resolvingMacro, this.processingNamespace, this.allowedAssignments, this.macroStack);
    }

    ResolveState createState() {
        ResolveState state = ResolveState.initial().put(FtlQualifiedReference.RESOLVING_MACRO, (Object)this.resolvingMacro).put(FtlTemplateType.PROCESSING_NAMESPACE, (Object)this.processingNamespace).put(FtlMacro.MACRO_STACK, ResolveStateParameters.cloneOrNull(this.macroStack));
        if (this.allowedAssignments != null) {
            state = state.put(FtlAssignmentType.TYPE_KEY, this.allowedAssignments);
        }
        return state;
    }
}

