/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.references.extensions;

import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.spring.security.references.extensions.SpringSecurityRolesProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UExpression;

public abstract class SpringSecurityRoleConstructor
implements SpringSecurityRolesProvider {
    @Override
    @NotNull
    public UExpressionPattern<UExpression, ?> getUastPattern() {
        UExpressionPattern uExpressionPattern = UastPatterns.injectionHostOrReferenceExpression().constructorParameter(this.getConstructorParameterIndex(), this.getClassName());
        if (uExpressionPattern == null) {
            SpringSecurityRoleConstructor.$$$reportNull$$$0(0);
        }
        return uExpressionPattern;
    }

    protected int getConstructorParameterIndex() {
        return 0;
    }

    @NotNull
    protected String getClassName() {
        return "org.springframework.security.core.authority.GrantedAuthorityImpl";
    }

    @Override
    public boolean isAvailable(@NotNull Project project) {
        if (project == null) {
            SpringSecurityRoleConstructor.$$$reportNull$$$0(1);
        }
        return JavaLibraryUtil.hasLibraryClass((Project)project, (String)this.getClassName());
    }

    @Override
    @NotNull
    public Set<String> getRoles(@NotNull Module module) {
        if (module == null) {
            SpringSecurityRoleConstructor.$$$reportNull$$$0(2);
        }
        HashSet<String> roles = new HashSet<String>();
        GlobalSearchScope scope = SpringGlobalSearchScopes.runtime((Module)module);
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(this.getClassName(), scope);
        if (psiClass != null) {
            for (PsiMethod constructor : psiClass.getConstructors()) {
                PsiParameter[] parameters = constructor.getParameterList().getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    if (!this.acceptParameter(parameters[i])) continue;
                    Set places = StringExpressionHelper.searchStringExpressions((PsiMethod)constructor, (SearchScope)scope, (int)i);
                    roles.addAll(places.stream().map(pair -> (String)pair.second).filter(s -> StringUtil.isNotEmpty((String)s)).collect(Collectors.toSet()));
                }
            }
        }
        HashSet<String> hashSet = roles;
        if (hashSet == null) {
            SpringSecurityRoleConstructor.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    protected boolean acceptParameter(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            SpringSecurityRoleConstructor.$$$reportNull$$$0(4);
        }
        String paramName = parameter.getName();
        return paramName.startsWith("role");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/references/extensions/SpringSecurityRoleConstructor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUastPattern";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/references/extensions/SpringSecurityRoleConstructor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRoles";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "acceptParameter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4 -> new IllegalArgumentException(string);
        };
    }
}

