/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.execution.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.execution.util.JacksonJsonConversionException;
import com.intellij.jupyter.execution.util.NotebookSerializationConversionException;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonArrayBuilder;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001c\u0010\u0013\u001a\u0004\u0018\u0001H\u0014\"\u0006\b\u0000\u0010\u0014\u0018\u0001*\u00020\u0006H\u0086\b\u00a2\u0006\u0002\u0010\u0015\u001a\n\u0010\u0016\u001a\u00020\u0006*\u00020\u0005\u001a\u0010\u0010\u0007\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0017"}, d2={"jsonConfig", "Lkotlinx/serialization/json/Json;", "getJsonConfig", "()Lkotlinx/serialization/json/Json;", "toNotebookSerializationJson", "Lkotlinx/serialization/json/JsonElement;", "Lcom/fasterxml/jackson/databind/JsonNode;", "convertPrimitive", "Lkotlinx/serialization/json/JsonPrimitive;", "value", "Lcom/fasterxml/jackson/databind/node/ValueNode;", "convertArray", "Lkotlinx/serialization/json/JsonArray;", "array", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "convertObject", "Lkotlinx/serialization/json/JsonObject;", "objectNode", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "deserialize", "T", "(Lcom/fasterxml/jackson/databind/JsonNode;)Ljava/lang/Object;", "toJacksonJson", "intellij.jupyter.execution"})
@SourceDebugExtension(value={"SMAP\njson.kt\nKotlin\n*S Kotlin\n*F\n+ 1 json.kt\ncom/intellij/jupyter/execution/util/JsonKt\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Json.kt\nkotlinx/serialization/json/JsonKt\n*L\n1#1,115:1\n52#2,3:116\n29#2,2:119\n31#2:123\n1869#3,2:121\n335#4:124\n*S KotlinDebug\n*F\n+ 1 json.kt\ncom/intellij/jupyter/execution/util/JsonKt\n*L\n52#1:116,3\n60#1:119,2\n60#1:123\n61#1:121,2\n70#1:124\n*E\n"})
public final class JsonKt {
    @NotNull
    private static final Json jsonConfig = kotlinx.serialization.json.JsonKt.Json$default(null, JsonKt::jsonConfig$lambda$0, (int)1, null);

    @NotNull
    public static final Json getJsonConfig() {
        return jsonConfig;
    }

    @NotNull
    public static final JsonElement toNotebookSerializationJson(@NotNull JsonNode $this$toNotebookSerializationJson) {
        JsonElement jsonElement;
        Intrinsics.checkNotNullParameter((Object)$this$toNotebookSerializationJson, (String)"<this>");
        JsonNode jsonNode = $this$toNotebookSerializationJson;
        if (jsonNode instanceof ValueNode) {
            jsonElement = (JsonElement)JsonKt.convertPrimitive((ValueNode)$this$toNotebookSerializationJson);
        } else if (jsonNode instanceof ArrayNode) {
            jsonElement = (JsonElement)JsonKt.convertArray((ArrayNode)$this$toNotebookSerializationJson);
        } else if (jsonNode instanceof ObjectNode) {
            jsonElement = (JsonElement)JsonKt.convertObject((ObjectNode)$this$toNotebookSerializationJson);
        } else {
            throw new JacksonJsonConversionException($this$toNotebookSerializationJson);
        }
        return jsonElement;
    }

    private static final JsonPrimitive convertPrimitive(ValueNode value) {
        JsonPrimitive jsonPrimitive;
        ValueNode valueNode = value;
        if (valueNode instanceof NullNode || valueNode instanceof MissingNode) {
            jsonPrimitive = (JsonPrimitive)JsonNull.INSTANCE;
        } else if (valueNode instanceof NumericNode) {
            jsonPrimitive = JsonElementKt.JsonPrimitive((Number)((NumericNode)value).numberValue());
        } else if (valueNode instanceof BooleanNode) {
            jsonPrimitive = JsonElementKt.JsonPrimitive((Boolean)((BooleanNode)value).booleanValue());
        } else if (valueNode instanceof TextNode || valueNode instanceof BinaryNode || valueNode instanceof POJONode) {
            jsonPrimitive = JsonElementKt.JsonPrimitive((String)value.textValue());
        } else {
            throw new JacksonJsonConversionException((JsonNode)value);
        }
        return jsonPrimitive;
    }

    private static final JsonArray convertArray(ArrayNode array) {
        JsonArrayBuilder builder$iv;
        boolean $i$f$buildJsonArray = false;
        JsonArrayBuilder $this$convertArray_u24lambda_u240 = builder$iv = new JsonArrayBuilder();
        boolean bl = false;
        array.elements().forEachRemaining(arg_0 -> JsonKt.convertArray$lambda$0$1(arg_0 -> JsonKt.convertArray$lambda$0$0($this$convertArray_u24lambda_u240, arg_0), arg_0));
        return builder$iv.build();
    }

    @NotNull
    public static final JsonObject convertObject(@NotNull ObjectNode objectNode) {
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)objectNode, (String)"objectNode");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$convertObject_u24lambda_u240 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        Set set = objectNode.properties();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"properties(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl2 = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            String string = (String)k;
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            $this$convertObject_u24lambda_u240.put(string, JsonKt.toNotebookSerializationJson((JsonNode)v));
        }
        return builder$iv.build();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T> T deserialize(JsonNode $this$deserialize) {
        void $this$decodeFromJsonElement$iv;
        Intrinsics.checkNotNullParameter((Object)$this$deserialize, (String)"<this>");
        boolean $i$f$deserialize = false;
        JsonElement json = JsonKt.toNotebookSerializationJson($this$deserialize);
        if (json instanceof JsonNull) {
            return null;
        }
        Json json2 = JsonKt.getJsonConfig();
        JsonElement json$iv = json;
        boolean $i$f$decodeFromJsonElement = false;
        SerializersModule serializersModule = $this$decodeFromJsonElement$iv.getSerializersModule();
        Intrinsics.reifiedOperationMarker((int)6, (String)"T?");
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        return (T)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), json$iv);
    }

    @NotNull
    public static final JsonNode toJacksonJson(@NotNull JsonElement $this$toJacksonJson) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)$this$toJacksonJson, (String)"<this>");
        JsonElement jsonElement = $this$toJacksonJson;
        if (Intrinsics.areEqual((Object)jsonElement, (Object)JsonNull.INSTANCE)) {
            NullNode nullNode = NullNode.instance;
            Intrinsics.checkNotNullExpressionValue((Object)nullNode, (String)"instance");
            jsonNode = (JsonNode)nullNode;
        } else if (jsonElement instanceof JsonPrimitive) {
            jsonNode = (JsonNode)JsonKt.convertPrimitive((JsonPrimitive)$this$toJacksonJson);
        } else if (jsonElement instanceof JsonObject) {
            jsonNode = (JsonNode)JsonKt.convertObject((JsonObject)$this$toJacksonJson);
        } else if (jsonElement instanceof JsonArray) {
            jsonNode = (JsonNode)JsonKt.convertArray((JsonArray)$this$toJacksonJson);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jsonNode;
    }

    private static final ValueNode convertPrimitive(JsonPrimitive value) {
        ValueNode valueNode;
        if (value.isString()) {
            valueNode = (ValueNode)new TextNode(value.getContent());
        } else {
            ValueNode valueNode2;
            try {
                valueNode2 = (ValueNode)JupyterJsonKt.getJackson().readValue(value.getContent(), ValueNode.class);
            }
            catch (JsonProcessingException e) {
                throw new NotebookSerializationConversionException((JsonElement)value, (Throwable)e);
            }
            ValueNode valueNode3 = valueNode2;
            Intrinsics.checkNotNull((Object)valueNode3);
            valueNode = valueNode3;
        }
        return valueNode;
    }

    private static final ArrayNode convertArray(JsonArray array) {
        ArrayNode arrayNode;
        ArrayNode $this$convertArray_u24lambda_u241 = arrayNode = JupyterJsonKt.getJackson().createArrayNode();
        boolean bl = false;
        for (JsonElement element : array) {
            $this$convertArray_u24lambda_u241.add(JsonKt.toJacksonJson(element));
        }
        ArrayNode arrayNode2 = arrayNode;
        Intrinsics.checkNotNullExpressionValue((Object)arrayNode2, (String)"apply(...)");
        return arrayNode2;
    }

    private static final ObjectNode convertObject(JsonObject objectNode) {
        ObjectNode objectNode2;
        ObjectNode $this$convertObject_u24lambda_u241 = objectNode2 = JupyterJsonKt.getJackson().createObjectNode();
        boolean bl = false;
        for (Map.Entry entry : ((Map)objectNode).entrySet()) {
            $this$convertObject_u24lambda_u241.set((String)entry.getKey(), JsonKt.toJacksonJson((JsonElement)entry.getValue()));
        }
        ObjectNode objectNode3 = objectNode2;
        Intrinsics.checkNotNullExpressionValue((Object)objectNode3, (String)"apply(...)");
        return objectNode3;
    }

    private static final Unit jsonConfig$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    private static final Unit convertArray$lambda$0$0(JsonArrayBuilder $this_buildJsonArray, JsonNode it) {
        Intrinsics.checkNotNull((Object)it);
        $this_buildJsonArray.add(JsonKt.toNotebookSerializationJson(it));
        return Unit.INSTANCE;
    }

    private static final void convertArray$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

