/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.settings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.protobuf.ide.settings.PbImportPathsConfiguration;
import com.intellij.protobuf.ide.settings.PbProjectSettings;
import com.intellij.protobuf.lang.resolve.FileResolveProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SettingsFileResolveProvider
implements FileResolveProvider {
    @Override
    @Nullable
    public VirtualFile findFile(@NotNull String path, @NotNull Project project) {
        if (path == null) {
            SettingsFileResolveProvider.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SettingsFileResolveProvider.$$$reportNull$$$0(1);
        }
        return SettingsFileResolveProvider.findFileWithSettings(path, project, PbProjectSettings.getInstance(project));
    }

    @Override
    @NotNull
    public Collection<FileResolveProvider.ChildEntry> getChildEntries(@NotNull String path, @NotNull Project project) {
        if (path == null) {
            SettingsFileResolveProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            SettingsFileResolveProvider.$$$reportNull$$$0(3);
        }
        HashSet<FileResolveProvider.ChildEntry> results = new HashSet<FileResolveProvider.ChildEntry>();
        for (PbProjectSettings.ImportPathEntry entry : SettingsFileResolveProvider.getImportPaths(project, PbProjectSettings.getInstance(project))) {
            VirtualFile[] children;
            String unprefixedPath;
            VirtualFile pathFile;
            VirtualFile location;
            String prefix = SettingsFileResolveProvider.normalizePath(entry.getPrefix());
            if (prefix.startsWith(path = SettingsFileResolveProvider.normalizePath(path)) && !prefix.equals(path)) {
                String nextPrefixComponent = prefix.substring(path.length()).split("/")[0];
                results.add(FileResolveProvider.ChildEntry.directory(nextPrefixComponent));
                continue;
            }
            if (!path.startsWith(prefix) || (location = VirtualFileManager.getInstance().findFileByUrl(entry.getLocation())) == null || (pathFile = location.findFileByRelativePath(unprefixedPath = path.substring(prefix.length()))) == null || (children = pathFile.getChildren()) == null) continue;
            for (VirtualFile child : children) {
                if (!PROTO_AND_DIRECTORY_FILTER.accept(child)) continue;
                results.add(new FileResolveProvider.ChildEntry(child.getName(), child.isDirectory()));
            }
        }
        HashSet<FileResolveProvider.ChildEntry> hashSet = results;
        if (hashSet == null) {
            SettingsFileResolveProvider.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    @Override
    @Nullable
    public VirtualFile getDescriptorFile(@NotNull Project project) {
        String configuredDescriptorPath;
        if (project == null) {
            SettingsFileResolveProvider.$$$reportNull$$$0(5);
        }
        if (StringUtil.isNotEmpty((String)(configuredDescriptorPath = PbProjectSettings.getInstance(project).getDescriptorPath()))) {
            return this.findFile(configuredDescriptorPath, project);
        }
        Logger.getInstance(SettingsFileResolveProvider.class).warn("No proto descriptor path provided, using bundled descriptor as fallback");
        return this.findFile("google/protobuf/descriptor.proto", project);
    }

    @Override
    @NotNull
    public GlobalSearchScope getSearchScope(@NotNull Project project) {
        if (project == null) {
            SettingsFileResolveProvider.$$$reportNull$$$0(6);
        }
        VirtualFile[] roots = (VirtualFile[])PbImportPathsConfiguration.computeDeterministicImportPathsStream(project, PbProjectSettings.getInstance(project)).map(PbProjectSettings.ImportPathEntry::getLocation).map(arg_0 -> ((VirtualFileManager)VirtualFileManager.getInstance()).findFileByUrl(arg_0)).filter(Objects::nonNull).toArray(VirtualFile[]::new);
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoriesScope((Project)project, (boolean)true, (VirtualFile[])roots);
        if (globalSearchScope == null) {
            SettingsFileResolveProvider.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    private static List<PbProjectSettings.ImportPathEntry> getImportPaths(Project project, PbProjectSettings pbSettings) {
        return PbImportPathsConfiguration.computeDeterministicImportPathsStream(project, pbSettings).toList();
    }

    static VirtualFile findFileWithSettings(String path, Project project, PbProjectSettings settings) {
        for (PbProjectSettings.ImportPathEntry entry : SettingsFileResolveProvider.getImportPaths(project, settings)) {
            String unprefixedPath;
            VirtualFile imported;
            VirtualFile location;
            String prefix;
            if (entry == null || !path.startsWith(prefix = SettingsFileResolveProvider.normalizePath(entry.getPrefix())) || (location = VirtualFileManager.getInstance().findFileByUrl(entry.getLocation())) == null || (imported = location.findFileByRelativePath(unprefixedPath = path.substring(prefix.length()))) == null || !PROTO_FILTER.accept(imported)) continue;
            return imported;
        }
        return SettingsFileResolveProvider.tryFindFileByAbsolutePath(path);
    }

    @Nullable
    private static VirtualFile tryFindFileByAbsolutePath(@NotNull String maybeAbsolutePath) {
        Path parsedAbsolutePath;
        if (maybeAbsolutePath == null) {
            SettingsFileResolveProvider.$$$reportNull$$$0(8);
        }
        try {
            parsedAbsolutePath = Path.of(maybeAbsolutePath, new String[0]);
        }
        catch (InvalidPathException e) {
            Logger.getInstance(SettingsFileResolveProvider.class).warn("Attempt to parse given path as an absolute path failed", (Throwable)e);
            return null;
        }
        return VirtualFileManager.getInstance().findFileByNioPath(parsedAbsolutePath);
    }

    private static String normalizePath(@Nullable String path) {
        if (path == null) {
            return "";
        }
        if (!path.isEmpty() && !path.endsWith("/")) {
            return path + "/";
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/ide/settings/SettingsFileResolveProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeAbsolutePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/ide/settings/SettingsFileResolveProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildEntries";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChildEntries";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSearchScope";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryFindFileByAbsolutePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7 -> new IllegalStateException(string);
        };
    }
}

