/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.netbeans.junit.NbTestCase;

final class MethodOrder {
    private static final List<Method[]> allDeclaredMethods = new LinkedList<Method[]>();
    private static final String DEFAULT_METHOD_ORDER = "natural";
    private static Long shuffleSeed;

    MethodOrder() {
    }

    static void initialize() {
        String string = MethodOrder.findOrder();
        if (!DEFAULT_METHOD_ORDER.equals(string)) {
            try {
                Field field = ClassLoader.class.getDeclaredField("classes");
                field.setAccessible(true);
                ArrayList arrayList = new ArrayList((Collection)field.get(NbTestCase.class.getClassLoader()));
                for (Class clazz : arrayList) {
                    if (!NbTestCase.class.isAssignableFrom(clazz) || clazz == NbTestCase.class) continue;
                    MethodOrder.orderMethods(clazz, string);
                }
            }
            catch (Exception exception) {
                System.err.println("WARNING: test method ordering disabled");
                exception.printStackTrace();
            }
        }
    }

    static void orderMethods(Class<?> clazz, String string) throws Exception {
        if (string == null) {
            string = MethodOrder.findOrder();
        }
        if (DEFAULT_METHOD_ORDER.equals(string)) {
            return;
        }
        Method[] methodArray = null;
        try {
            Field field = Class.class.getDeclaredField("declaredMethods");
            field.setAccessible(true);
            while (methodArray == null) {
                clazz.getDeclaredMethods();
                methodArray = (Method[])((Reference)field.get(clazz)).get();
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Field field = Class.class.getDeclaredField("reflectionData");
            field.setAccessible(true);
            clazz.getDeclaredMethods();
            Reference reference = (Reference)field.get(clazz);
            Object t = reference.get();
            Field field2 = t.getClass().getDeclaredField("declaredMethods");
            field2.setAccessible(true);
            methodArray = (Method[])field2.get(t);
        }
        allDeclaredMethods.add(methodArray);
        if (string.equals("a-z")) {
            MethodOrder.abcSort(methodArray, true);
        } else if (string.equals("z-a")) {
            MethodOrder.abcSort(methodArray, false);
        } else if (string.equals("shuffle")) {
            if (shuffleSeed == null) {
                shuffleSeed = System.currentTimeMillis();
            }
            MethodOrder.shuffle(methodArray, shuffleSeed);
        } else {
            try {
                long l = Long.parseLong(string);
                MethodOrder.shuffle(methodArray, l);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("Specify -DNbTestCase.order=a-z or =z-a or =shuffle or =<number>");
            }
        }
    }

    private static void abcSort(Method[] methodArray, boolean bl) {
        final int n = bl ? 1 : -1;
        Arrays.sort(methodArray, new Comparator<Method>(){

            @Override
            public int compare(Method method, Method method2) {
                return n * method.toString().compareTo(method2.toString());
            }
        });
    }

    private static void shuffle(Method[] methodArray, long l) {
        MethodOrder.abcSort(methodArray, true);
        Random random = new Random(l);
        for (int i = 0; i < methodArray.length; ++i) {
            int n = i + random.nextInt(methodArray.length - i);
            if (i == n) continue;
            Method method = methodArray[i];
            methodArray[i] = methodArray[n];
            methodArray[n] = method;
        }
    }

    private static String findOrder() {
        String string = System.getProperty("NbTestCase.order");
        if (string == null) {
            string = DEFAULT_METHOD_ORDER;
        }
        return string;
    }

    static boolean isShuffled() {
        return shuffleSeed != null;
    }

    static long getSeed() {
        assert (shuffleSeed != null);
        return shuffleSeed;
    }
}

