# Copyright 2016 The Chromium Authors
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

import time
import unittest

from form_classification_test import FormClassificationTest
"""Unittest class for testing signup forms.

The test methods were generated by the form annotation extension
(components/test/data/password_manager/form_annotation_extension)
"""


class SignUpFormsTest(FormClassificationTest):

  def test_yandex_ru(self):
    self.GoTo("https://passport.yandex.ru/registration/mail")
    self.CheckPwdField("#password")

  def test_mail_ru(self):
    self.GoTo("https://e.mail.ru/signup")
    self.CheckPwdField("span.sig2 > input[type='password']")

  def test_linkedin_com(self):
    self.GoTo("https://www.linkedin.com/")
    self.CheckPwdField("#join-password")

  def test_yahoo_com(self):
    self.GoTo("https://edit.yahoo.com/registration")
    self.CheckPwdField("#usernamereg-password")

  def test_amazon_com(self):
    self.GoTo(
        "https://www.amazon.com/ap/register?_encoding=UTF8&openid.assoc_handle"
        "=usflex&openid.claimed_id=http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0"
        "%2Fidentifier_select&openid.identity=http%3A%2F%2Fspecs.openid.net%2F"
        "auth%2F2.0%2Fidentifier_select&openid.mode=checkid_setup&openid.ns="
        "http%3A%2F%2Fspecs.openid.net%2Fauth%2F2.0&openid.ns.pape=http%3A%2F%"
        "2Fspecs.openid.net%2Fextensions%2Fpape%2F1.0&openid.pape.max_auth_age"
        "=0&openid.return_to=https%3A%2F%2Fwww.amazon.com%2Fgp%2Fyourstore%2F"
        "home%3Fie%3DUTF8%26ref_%3Dnav_newcust")
    self.CheckPwdField("#ap_password")

  def test_google_com(self):
    self.GoTo("https://accounts.google.com/signup")
    self.CheckPwdField("#Passwd")

  def test_baidu_com(self):
    self.GoTo("https://passport.baidu.com/v2/?reg")
    self.CheckPwdField("#TANGRAM__PSP_4__password")

  def test_wikipedia_org(self):
    self.GoTo(
        "https://en.wikipedia.org/w/index.php?"
        "title=Special:UserLogin&signup&type=signup")
    self.CheckPwdField("#wpPassword2")

  def test_qq_com(self):
    self.GoTo("http://zc.qq.com/en/index.html")
    self.CheckPwdField("#password")

  def test_twitter_com(self):
    self.GoTo("https://twitter.com/")
    self.CheckPwdField("input[name='user[user_password]']")

  def test_live_com(self):
    self.GoTo("https://signup.live.com/")
    self.CheckPwdField("#Password")

  def test_sina_com(self):
    self.GoTo("https://login.sina.com.cn/signup/signup")
    self.CheckPwdField("input[class='reg_ipt'][type='password']")

  def test_weibo_com(self):
    self.GoTo("http://weibo.com/signup/signup.php")
    self.CheckPwdField("input[name='passwd']")

  def test_instagram_com(self):
    self.GoTo("https://www.instagram.com/")
    self.CheckPwdField("input[name='password']")

  def test_reddit_com(self):
    self.GoTo("https://www.reddit.com/")
    self.Click("span.user > a")
    self.CheckPwdField("#passwd_reg")

  def test_360_cn(self):
    self.GoTo("http://i.360.cn/reg/")
    self.CheckPwdField("input[class~='quc-input-password']")

  def test_pinterest_com(self):
    self.GoTo("https://www.pinterest.com/")
    self.CheckPwdField("#userPassword")

  def test_netflix_com(self):
    self.GoTo(
        "https://www.netflix.com/getstarted?locale=en-GB&action=startAction")
    FormClassificationTest.driver.delete_all_cookies()
    self.Click("button")
    self.CheckPwdField("input[name='password'][type='password']")

  def test_apple_com(self):
    self.GoTo("https://appleid.apple.com/account")
    self.CheckPwdField("#password")

  def test_stackoverflow_com(self):
    self.GoTo("https://stackoverflow.com/users/signup")
    self.CheckPwdField("#password")

  def test_paypal_com(self):
    self.GoTo("https://www.paypal.com/de/signup/account")
    time.sleep(2)
    self.Click("#personalSignUpForm")
    self.CheckPwdField("#password")

  def test_sohu_com(self):
    self.GoTo("https://passport.sohu.com/signup")
    self.CheckPwdField("input[name='password']")

  def test_tumblr_com(self):
    self.GoTo("https://www.tumblr.com/")
    self.Click("span[class~='signup_get_started_btn']")
    self.CheckPwdField(
        "#signup_password",
        "We shouldn't skip disabled elements "
        "if ignore_invisible_usernames==false")

  def test_www_linkedin_com(self):
    self.GoTo("https://www.linkedin.com/")
    self.CheckPwdField(
        "INPUT#join-password[name=password][type=password]"
        ".cell-body-textinput")

  def test_imgur_com(self):
    self.GoTo("https://imgur.com")
    self.Click("LI#register > A")
    self.SwitchTo("IFRAME.cboxIframe")
    self.SwitchTo("IFRAME#f[name='f']")
    self.CheckPwdField("DIV#part-one > INPUT[name='password']"
                       "[type='password']")

  def test_naver_com(self):
    self.GoTo("https://nid.naver.com/user2/joinGlobal.nhn?m=init&lang=en_US")
    self.Click("LABEL#chk_allLb")
    self.Click("A.btn_agree")
    self.CheckPwdField("INPUT#pswd1[name='pswd1'][type='password'].int")
    self.CheckPwdField("INPUT#pswd1[name='pswd1'][type='password'].int")

  def test_imdb_com(self):
    self.GoTo("https://secure.imdb.com/register-imdb/form-v2")
    self.CheckPwdField(
        "INPUT#password1[name='password1'][type='password'].reg_thick")

  def test_github_com(self):
    self.GoTo("https://github.com/")
    self.CheckPwdField(
        "INPUT[name='user[password]'][type='password'].form-control-lg")

  def test_rakuten_co_jp(self):
    self.GoTo("http://www.rakuten.co.jp/")
    self.Click("A.mr-new-entry-btn")
    self.CheckPwdField("INPUT#p_id[name='p'][type='password']")

  def test_signup_live_com(self):
    self.GoTo("https://signup.live.com/signup")
    self.CheckPwdField(
        "INPUT#Password[name='Password'][type='password'].form-control")

  def test_www_tianya_cn(self):
    self.GoTo("http://www.tianya.cn/")
    self.CheckPwdField(
        "INPUT#password1[name='vpassword'][type='password'].text-ipt")

  def test_pixnet_cc(self):
    self.GoTo("https://www.pixnet.net/")
    self.Click("A#switch-openid.switch-openid")
    self.Click("DIV#login-1.login > DIV.box-title > A")
    self.CheckPwdField(
        "INPUT#user_password[name='user_password'][type='password'].text_field")

  def test_jd_com(self):
    self.GoTo("http://www.jd.com/")
    self.Click("A.link-regist")
    self.Click("IMG#imgAuthCode.img-code")
    self.CheckPwdField("INPUT#form-pwd[name='pwd'][type='password'].field")

  def test_kat_cr(self):
    self.GoTo("https://kat.cr/")
    self.Click("DIV.land-login > A.ajaxLink > SPAN")
    self.Click("A#register_link.darkButton > SPAN")
    self.CheckPwdField(
        "INPUT#password[name='password'][type='password'].botmarg5px")

  def test_my_outbrain_com(self):
    self.GoTo("http://www.outbrain.com/")
    self.Click("LI.register > A")
    self.CheckPwdField(
        "INPUT[name='password'][type='password']._am_core-input."
        "ng-valid-password-rules")

  def test_www_dropbox_com(self):
    self.GoTo("https://www.dropbox.com/register")
    self.CheckPwdField("INPUT[name='password'][type='password']"
                       ".password-input")

  def test_i_360_cn(self):
    self.GoTo("http://i.360.cn/reg/?src=pcw_home")
    self.CheckPwdField(
        "INPUT[name='password'][type='password'].quc-input-password")

  def test_adobe_com(self):
    self.GoTo("http://www.adobe.com/")
    self.Click("I.ui-close")
    self.Click(
        "LI.globalnav__js__menu-bar__item__signin > "
        "BUTTON.globalnav__menu-bar__button > "
        "SPAN.globalnav__menu-bar__item__title")
    self.Click("A#create_account.nowrap")
    self.CheckPwdField("INPUT#password[name='password'][type='password']",
                       "fake visible password field outside of screen")

  def test_email_163_com(self):
    self.GoTo("http://reg.email.163.com/unireg/call.do?cmd=register.entrance")
    self.CheckPwdField(
        "INPUT#mobilePwdIpt[name='mobilePassword'][type='password']"
        ".norWidthIpt")

  def test_passport_china_com(self):
    self.GoTo("http://passport.china.com/logon.do?processID=engRegister")
    self.CheckPwdField("INPUT#password[name='password'][type='password']")

  def test_adf_ly(self):
    self.GoTo("http://adf.ly/")
    self.Click("A#joinNow.button")
    self.CheckPwdField("INPUT#password[name='password'][type='password']")

  def test_www_booking_com(self):
    self.GoTo("http://www.booking.com/index.ru.html")
    self.Click(
        "A.remove_padding_register_btn_right > DIV.sign_in_wrapper > SPAN")
    self.CheckPwdField(
        "INPUT[name='password'][type='password'].user_signup_password")

  def test_passport_twitch_tv(self):
    self.GoTo("https://www.twitch.tv/")
    self.Click("A#header_signup.button.last > SPAN")
    self.SwitchTo("IFRAME[name='passport']")
    self.CheckPwdField("INPUT#password[name='password'][type='password'].text")

  def test_nytimes_com(self):
    self.GoTo("https://myaccount.nytimes.com/register")
    self.CheckPwdField(
        "INPUT[id='password1'][name='password1'][type='password'].password")

  def test_www_quora_com(self):
    self.GoTo("https://www.quora.com/")
    self.Click("A.signup_email_link")
    self.CheckPwdField(
        "INPUT[name='password'][type='password'][id*=password].text")

  def test_member_livedoor_com(self):
    self.GoTo("http://www.livedoor.com/")
    self.Click("DIV#member > UL > LI > A")
    self.CheckPwdField("INPUT#password[name='password'][type='password'].pw")

  def test_www_popads_net(self):
    self.GoTo("https://www.popads.net/")
    self.Click("IMG.right")
    self.Click(
        "FORM#UserRegisterForm > DIV.pad > DIV > DIV.input_wrapper > "
        "DIV.password > LABEL")
    self.CheckPwdField(
        "INPUT#UserPass1[name='data[User][pass1]'][type='password']")

  def test_ebay_com(self):
    self.GoTo("https://signin.ebay.com/ws/eBayISAPI.dll?SignIn&pos=1")
    self.SwitchTo("#regFrame")
    self.CheckPwdField("#PASSWORD")

  def test_ssl_bbc_com(self):
    self.GoTo("http://www.bbc.com/")
    self.Click("A#idcta-link")
    self.Click("P.bbcid-pre-form > A")
    self.CheckPwdField(
        "INPUT#bbcid_createpassword[name='confirmpassword'][type='password']"
        ".password")

  def test_passport_bilibili_com(self):
    self.GoTo("https://passport.bilibili.com/register/phone")
    self.CheckPwdField(
        "INPUT#password[name='userpwd'][type='password'].user_id_password")

  def test_tudou_com(self):
    self.GoTo("http://login.tudou.com/reg.do")
    self.CheckPwdField("INPUT#passwd[name='passwd'][type='password'].passwd")

  def test_www_buzzfeed_com(self):
    self.GoTo("http://www.buzzfeed.com/")
    self.Click(
        "DIV.page-nav__utilities > DIV#nav-signin.nav-signin > "
        "DIV#usernav-signin > A#header-signin.nav-signin-icon")
    self.Click("DIV.modal__tab--right")
    self.CheckPwdField("INPUT[type='password'].js-user-password")

  def test_www_dailymail_co_uk(self):
    self.GoTo("http://www.dailymail.co.uk/home/index.html")
    self.Click("A.js-login")
    self.Click("A.reg-btn-join")
    self.CheckPwdField(
        "INPUT#reg-password[name='password'][type='password'].js-val")

  def test_www_zillow_com(self):
    self.GoTo("http://www.zillow.com/")
    self.Click("DIV.nav-top-auth-links > A#register_opener.register")
    self.SwitchTo("DIV#register_content > iframe")
    self.CheckPwdField("INPUT#password[name='password'][type='password']")

  def test_soundcloud_com(self):
    self.GoTo(
        "https://soundcloud.com/connect?client_id=02gUJC0hH2ct1EGOcYXQIz"
        "RFU91c72Ea&response_type=token&scope=non-expiring%20fast-connect"
        "%20purchase%20upload&display=next&redirect_uri=https%3A//"
        "soundcloud.com/soundcloud-callback.html&highlight=signup")
    self.CheckPwdField(
        "INPUT#user_password[name='user[password]'][type='password'].sc-input")

  def test_indeed_com(self):
    self.GoTo("http://de.indeed.com/")
    self.Click("A#userOptionsLabel")
    self.Click("P.sign_up_prompt > A")
    self.CheckPwdField(
        "INPUT#register_password[name='password'][type='password']"
        ".input_password")

  def test_www_so_com(self):
    self.GoTo("https://www.so.com/")
    self.Click("A#user-reg")
    self.CheckPwdField(
        "INPUT[name='password'][type='password'].quc-input-password")

  def test_www_etsy_com(self):
    self.GoTo("https://www.etsy.com/")
    self.Click("A#register.register-header-action")
    self.CheckPwdField("INPUT#password[name='password'][type='password'].text")

  def test_www_avito_ru(self):
    self.GoTo("https://www.avito.ru/registration")
    self.CheckPwdField(
        "INPUT#password[name='password'][type='password'].password-field")

  def test_www_yelp_com(self):
    self.GoTo("http://www.yelp.com/m%C3%BCnchen")
    self.Click("A#header-sign-up.header-nav_button--sign-up")
    self.CheckPwdField(
        "FORM#signup-form.signup-form > "
        "INPUT#password[name='password'][type='password']")

  def test_globo_com(self):
    self.GoTo("https://login.globo.com/cadastro/4728")
    self.CheckPwdField(
        "INPUT#senha[name='senha'][type='password'].ng-valid-maxlength")

  def test_www_slideshare_net(self):
    self.GoTo("http://www.slideshare.net/")
    self.Click("A#signup.void_redirect_link")
    self.Click("A.alternate-cta")
    self.CheckPwdField(
        "INPUT#j-user-password[name='user_password'][type='password']")

  def test_detik_com(self):
    self.GoTo("http://www.detik.com/")
    self.Click("A.daftar")
    self.SwitchTo("#box_login_iframe")
    self.CheckPwdField(
        "INPUT#password[name='password'][type='password'].input1")

  def test_aol_com(self):
    self.GoTo("http://www.aol.com/")
    self.Click("UL.m-side-nav__list > LI > A.m-side-nav__link")
    self.Click("A#getSn")
    self.CheckPwdField("INPUT#password[name='password'][type='password']")

  def test_www_mediafire_com(self):
    self.GoTo("https://www.mediafire.com/upgrade/registration.php?pid=66")
    self.CheckPwdField(
        "INPUT#reg_pass[name='reg_pass'][type='password'].inspectletIgnore")

  def test_cnet_com(self):
    self.GoTo("http://www.cnet.com/uk/")
    self.Click("DIV.menuHead > DIV.user-avatar")
    self.Click("UL.logged-out > LI:nth-child(3)")
    self.SwitchTo("iframe[id*=easyXDM_fly_]")
    self.CheckPwdField(
        "INPUT#user_password[name='user[password]'][type='password']")

  def test_stackexchange_com(self):
    self.GoTo("http://stackexchange.com/")
    self.Click("SPAN.topbar-menu-links > A")
    self.SwitchTo("#affiliate-iframe")
    self.CheckPwdField(
        "INPUT#password[name='password'][type='password'].signup-text-field")

  def test_theguardian_com(self):
    self.GoTo("http://www.theguardian.com/international")
    self.Click("DIV.brand-bar__item--profile > A.popup__toggle")
    self.Click("A#register_cta.signin__cta-link--signup")
    self.CheckPwdField(
        "INPUT#register_field_password[name='password'][type='password']"
        ".register-form__field--password")

  def test_www_wittyfeed_com(self):
    self.GoTo("http://www.wittyfeed.com/")
    self.Click("A.express")
    self.Click("A#signUp_btn.btn.btn-default")
    self.CheckPwdField(
        "DIV.signUp_passwrdDiv > "
        "INPUT[name='password'][type='password'].form-control")

  def test_www_tribunnews_com(self):
    SignUpFormsTest.driver.maximize_window()
    self.GoTo("http://www.tribunnews.com/")
    self.Click("A#login.blue")
    self.Click("A.fbo")
    self.CheckPwdField(
        "DIV.al.pa10 > DIV.mb10 > INPUT[name='password'][type='password']"
        ".input")

  def test_naver_jp(self):
    self.GoTo("http://matome.naver.jp/")
    self.Click("UL.MdHeadUtil01 > LI.mdHeadUtil01Li:nth-child(2) > A")
    self.CheckPwdField(
        "INPUT#_passwd[name='kodamaUser.password'][type='password']"
        ".mdInputTxt01Input")

  def test_steampowered_com(self):
    self.GoTo("https://store.steampowered.com/join/")
    self.CheckPwdField("INPUT#password[name='password'][type='password']")

  def test_kakaku_com(self):
    self.GoTo("http://kakaku.com/auth/inc_idcore_top_v2.asp")
    self.Click("A.register")
    self.CheckPwdField("INPUT[name='Password1'][type='password'].secPwFrm")

  def test_gfycat_com(self):
    self.GoTo("https://gfycat.com/signup")
    self.CheckPwdField("INPUT[name='password'][type='password']")

  def test_www_tripadvisor_com(self):
    self.GoTo("https://www.tripadvisor.com/")
    self.Click("LI#register")
    self.SwitchTo("IFRAME#overlayRegFrame.overlayRegFrame")
    self.Click("SPAN.regTaEmail")
    self.CheckPwdField(
        "DIV#regSignUp.regSignUp > INPUT[type='password'].text.regInputText")

  def test_flickr_com(self):
    self.GoTo("https://www.flickr.com/")
    self.Click("A.gn-title.butt")
    self.CheckPwdField(
        "INPUT#usernamereg-password[name='password'][type='password']")

  def test_feedly_com(self):
    self.GoTo("https://feedly.com/v3/auth/login?newUser=true")
    self.CheckPwdField("INPUT[name='password'][type='password'].input-bottom")

  def test_zol_com_cn(self):
    self.GoTo("http://service.zol.com.cn/user/login.php?type=reg")
    self.CheckPwdField(
        "INPUT#J_RegistPsw[name='J_RegistPsw'][type='password'].txt.tabInput")

  def test_www_iqiyi_com(self):
    self.GoTo("http://www.iqiyi.com/")
    self.Click("A.register0201")
    self.CheckPwdField("DIV.acountIn > INPUT[type='password'].in-txt")

  def test_vimeo_com(self):
    self.GoTo("https://vimeo.com/")
    self.CheckPwdField(
        "INPUT#signup_password[name='password'][type='password']"
        ".js-join_password")

  def test_torrentz_eu(self):
    self.GoTo("http://torrentz.eu/profile")
    self.CheckPwdField("INPUT#rpass[name='pass'][type='password'].i")

  def test_9gag_com(self):
    self.GoTo("http://9gag.com/")
    self.Click("A.badge-signup-button")
    self.Click("A.badge-signup-email-link")
    self.CheckPwdField(
        "INPUT#signup-email-password[name='password'][type='password']")

  def test_blogs_forbes_com(self):
    self.GoTo("http://blogs.forbes.com/account/register")
    self.CheckPwdField(
        "INPUT#signup_form_password[name='password'][type='password']")

  def test_en_softonic_com(self):
    self.GoTo("http://en.softonic.com/linux")
    self.Click("A#login_link.nav-item-icons")
    self.Click("A#standard-register.button-standard-m")
    self.CheckPwdField(
        "INPUT#reg-password[name='password'][type='password'].field-m")

  def test_store_steampowered_com(self):
    self.GoTo("http://store.steampowered.com/")
    self.Click("A.global_action_link")
    self.Click("A.btnv6_blue_hoverfade.btn_medium")
    self.CheckPwdField("INPUT#password[name='password'][type='password']")

  def test_godaddy_com(self):
    self.GoTo("https://uk.godaddy.com/")
    self.Click("DIV#sign-in.pc-menu-item.ux-tray > A.ux-tray-toggle.menu-title")
    self.Click("A#ux-ub-create-account.btn-primary.btn-sm")
    self.CheckPwdField(
        "INPUT#create_password[name='create_password'][type='password']"
        ".sf-tipper-target")

  def test_web_de(self):
    self.GoTo("http://web.de/")
    self.Click("A.icon-freemail")
    self.Click(
        "FORM#formFreemailLogin[name='fm'].form-login > FIELDSET > "
        "DIV.login-username > SPAN > A")
    self.CheckPwdField(
        "INPUT#id1f[name='passwordPanel:password-form:password:textfield']"
        "[type='password'].password")

  def test_eui_orange_fr(self):
    self.GoTo(
        "http://www.orange.fr/bin/frame.cgi?u=https%3A//eui.orange.fr/signup/"
        "bin/signup.cgi%3F")
    self.SwitchTo("FRAME[name~=w_contenu]")
    self.CheckPwdField("INPUT#f_password")

  def test_www_foxnews_com(self):
    self.GoTo("http://www.foxnews.com/")
    self.Click("A.login")
    self.Click("A.capture_fox_marginTop")
    self.CheckPwdField(
        "INPUT#capture_traditionalRegistration_traditionalRegistration_password"
        "[name='traditionalRegistration_password'][type='password']"
        ".capture_traditionalRegistration_password")

  def test_www_homedepot_com(self):
    self.GoTo("http://www.homedepot.com/")
    self.Click("A#headerMyAccount.headerMyAccount__button")
    self.Click("A.button.dual-sign-in-pop-up")
    self.CheckPwdField(
        "INPUT#dualSignIn-registrationPassword[name='logonPassword']"
        "[type='password'].width_295px")

  def test_www_livejournal_com(self):
    self.GoTo("http://www.livejournal.com/")
    self.Click("LI.s-nav-item-signup > A.b-flatbutton-simple")
    self.CheckPwdField(
        "INPUT#password[name='password'][type='password'].b-passview-realpass")

  def test_www_babytree_com(self):
    self.GoTo("http://www.babytree.com/reg/register.php")
    self.CheckPwdField(
        "INPUT[name='password'][type='password'].login-input-text")

  def test_www_wikihow_com(self):
    self.GoTo(
        "https://www.wikihow.com/index.php?title=Special:UserLogin&type=signup"
        "&fromhttp=1")
    self.CheckPwdField(
        "INPUT#wpPassword2[name='wpPassword'][type='password'].mw-input"
        ".loginPassword")

  def test_www_facebook_com(self):
    self.GoTo("https://www.facebook.com/")
    self.CheckPwdField(
        "INPUT#u_0_b[name='reg_passwd__'][type='password']._58mg")

  def test_youku_com(self):
    self.GoTo("http://login.youku.com/user_signup?from=header")
    self.CheckPwdField(
        "INPUT#password[name='password'][type='password'].form_input")

  def test_www_wikia_com(self):
    self.GoTo("https://www.wikia.com/register")
    self.CheckPwdField(
        "INPUT#signupPassword[name='password'][type='password']"
        ".input-password")

  def test_www_walmart_com(self):
    self.GoTo("https://www.walmart.com/account/signup")
    self.CheckPwdField(
        "INPUT#password[name='signup-password'][type='password']"
        ".js-signup-password")

  def test_uptodown_com(self):
    SignUpFormsTest.driver.maximize_window()
    self.GoTo("http://en.uptodown.com/ubuntu")
    self.Click("A.button > SPAN")
    self.Click("NAV > UL > LI:nth-child(2) > A")
    self.CheckPwdField("INPUT#reg_password[type='password']")

  def test_www_dmm_com(self):
    self.GoTo("https://www.dmm.com/en/my/-/register/")
    self.CheckPwdField("INPUT#password[name='password'][type='password']")

  def test_id_ifeng_com(self):
    self.GoTo("https://id.ifeng.com/user/register")
    self.CheckPwdField("INPUT#js-email-password[type='password'].txt_270")

  def test_udn_com(self):
    self.GoTo("https://member.udn.com/member/rule.jsp")
    self.Click("INPUT#accept[type='button']")
    self.CheckPwdField("INPUT#password[name='password'][type='password']")

  def test_thepiratebay_se(self):
    self.GoTo("https://thepiratebay.se/register")
    self.CheckPwdField("INPUT#password[name='password'][type='password']")

  def test_www_sunmaker_com(self):
    self.GoTo("https://www.sunmaker.com/de/register")
    self.CheckPwdField(
        "INPUT[name='password'][type='password'].form-control.ng-valid-pattern")

  def test_csdn_net(self):
    self.GoTo("http://passport.csdn.net/account/register")
    self.CheckPwdField(
        "INPUT#password[name='password'][type='password'].main-password")

  def test_gmx_net(self):
    self.GoTo("https://registrierung.gmx.net/")
    self.CheckPwdField(
        "INPUT[type='password'][name='passwordPanel:password-form:"
        "password:textfield'].password")

  def test_www_deviantart_com(self):
    self.GoTo("https://www.deviantart.com/join/")
    self.CheckPwdField(
        "INPUT#password1[name='password1'][type='password'].text")

  def test_bet365_com(self):
    self.GoTo("https://members.bet365.com/Members/OpenAccount/")
    self.CheckPwdField(
        "INPUT#ctl00_main_OA_tPwd[name='ctl00$main$OA$tPwd']"
        "[type='password'].tbx")

  def test_www_douyu_com(self):
    SignUpFormsTest.driver.maximize_window()
    self.GoTo("http://www.douyu.com/")
    self.Click("A.u-reg")
    self.CheckPwdField(
        "DIV.login-pop-cont > DIV.c-item[data-type~='reg'] > FORM > P > "
        "INPUT[name='password'][type='password'].ipt")

  def test_allegro_pl(self):
    SignUpFormsTest.driver.maximize_window()
    self.GoTo("http://allegro.pl/")
    self.Click(
        "DIV.header-namespace > DIV.user-links-wrapper > DIV.wrapper-fluid > "
        "UL.user-nav > LI.register:nth-child(8) > A")
    self.CheckPwdField(
        "INPUT#signup-password[name='password'][type='password']")

  def test_mega_nz(self):
    self.GoTo("https://mega.nz/")
    self.Click("A.create-account-button")
    self.CheckPwdField(
        "INPUT#register-password[name='login-password'][type='password']")

  def test_skype_com(self):
    self.GoTo("https://login.skype.com/registration")
    self.CheckPwdField(
        "INPUT#password[name='password'][type='password'].password")

  def test_adsterra_com(self):
    self.GoTo("http://publishers.adsterra.com/signup/")
    self.CheckPwdField("INPUT[name='password'][type='password']")


if __name__ == "__main__":
  unittest.main()
