/*
 * Decompiled with CFR 0.152.
 */
package org.openjfx.gradle.metadatarule;

import java.io.Serializable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.CacheableRule;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.ComponentMetadataRule;
import org.gradle.api.model.ObjectFactory;
import org.gradle.nativeplatform.MachineArchitecture;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.openjfx.gradle.JavaFXPlatform;

@CacheableRule
public abstract class JavaFXComponentMetadataRule
implements ComponentMetadataRule {
    @Inject
    protected abstract ObjectFactory getObjects();

    public void execute(ComponentMetadataContext context) {
        ComponentMetadataDetails details = context.getDetails();
        for (JavaFXPlatform javaFXPlatform : JavaFXPlatform.values()) {
            this.addJavaFXPlatformVariant(javaFXPlatform, details, "Compile", "compile");
            this.addJavaFXPlatformVariant(javaFXPlatform, details, "Runtime", "runtime");
        }
    }

    private void addJavaFXPlatformVariant(JavaFXPlatform javaFXPlatform, ComponentMetadataDetails details, String nameSuffix, String baseVariant) {
        String name = details.getId().getName();
        String version = details.getId().getVersion();
        details.maybeAddVariant(javaFXPlatform.getClassifier() + nameSuffix, baseVariant, (Action & Serializable)variant -> {
            variant.attributes((Action & Serializable)attributes -> {
                attributes.attribute(OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE, (Object)((OperatingSystemFamily)this.getObjects().named(OperatingSystemFamily.class, javaFXPlatform.getOsFamily())));
                attributes.attribute(MachineArchitecture.ARCHITECTURE_ATTRIBUTE, (Object)((MachineArchitecture)this.getObjects().named(MachineArchitecture.class, javaFXPlatform.getArch())));
            });
            variant.withFiles((Action & Serializable)files -> {
                files.removeAllFiles();
                files.addFile(name + "-" + version + "-" + javaFXPlatform.getClassifier() + ".jar");
            });
        });
    }
}

