/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.util;

import java.text.MessageFormat;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.geometry.Rectangle2D;
import javafx.stage.Screen;
import javafx.stage.Stage;

public class StageManager {
    private final Logger LOG = Logger.getLogger(StageManager.class.getSimpleName());
    private final Stage stage;
    private final Preferences preferences;
    private double minWidth;
    private double minHeight;
    private boolean supportFullScreenAndMaximized;

    public static StageManager install(Stage stage, String preferencesPath) {
        return StageManager.install(stage, Preferences.userRoot().node(preferencesPath));
    }

    public static StageManager install(Stage stage, Preferences preferences) {
        return StageManager.install(stage, preferences, 850.0, 600.0);
    }

    public static StageManager install(Stage stage, String preferencesPath, double minWidth, double minHeight) {
        return StageManager.install(stage, Preferences.userRoot().node(preferencesPath), minWidth, minHeight);
    }

    public static StageManager install(Stage stage, Preferences preferences, double minWidth, double minHeight) {
        return new StageManager(stage, preferences, minWidth, minHeight);
    }

    private StageManager(Stage stage, Preferences preferences, double minWidth, double minHeight) {
        if (minWidth <= 0.0) {
            throw new IllegalArgumentException("min width must be larger than 0");
        }
        if (minHeight <= 0.0) {
            throw new IllegalArgumentException("min height must be larger than 0");
        }
        this.stage = stage;
        this.preferences = preferences;
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.restoreStage();
        InvalidationListener stageListener = it -> {
            try {
                this.saveStage();
            }
            catch (SecurityException ex) {
                this.LOG.throwing(StageManager.class.getName(), "init", ex);
            }
        };
        stage.xProperty().addListener(stageListener);
        stage.yProperty().addListener(stageListener);
        stage.widthProperty().addListener(stageListener);
        stage.heightProperty().addListener(stageListener);
        stage.iconifiedProperty().addListener(stageListener);
        stage.maximizedProperty().addListener(stageListener);
    }

    public final void setSupportFullScreenAndMaximized(boolean supportFullScreenAndMaximized) {
        this.supportFullScreenAndMaximized = supportFullScreenAndMaximized;
    }

    public final boolean isSupportFullScreenAndMaximized() {
        return this.supportFullScreenAndMaximized;
    }

    private void saveStage() throws SecurityException {
        if (this.supportFullScreenAndMaximized && this.stage.isMaximized()) {
            this.LOG.fine(MessageFormat.format("saving stage, iconified = {0}, maximized = {1}, fullscreen = {2}", this.stage.isIconified(), this.stage.isMaximized(), this.stage.isFullScreen()));
        } else {
            this.LOG.fine(MessageFormat.format("saving stage, x = {0}, y = {1}, width = {2}, height = {3}, iconified = {4}, maximized = {5}, fullscreen = {6}", this.stage.getX(), this.stage.getY(), this.stage.getWidth(), this.stage.getHeight(), this.stage.isIconified(), this.stage.isMaximized(), this.stage.isFullScreen()));
        }
        if (!this.supportFullScreenAndMaximized || !this.stage.isMaximized() && !this.stage.isFullScreen()) {
            this.preferences.putDouble("x", this.stage.getX());
            this.preferences.putDouble("y", this.stage.getY());
            this.preferences.putDouble("width", this.stage.getWidth());
            this.preferences.putDouble("height", this.stage.getHeight());
        }
        this.preferences.putBoolean("iconified", this.stage.isIconified());
        this.preferences.putBoolean("maximized", this.stage.isMaximized());
        this.preferences.putBoolean("fullscreen", this.stage.isFullScreen());
    }

    private void restoreStage() throws SecurityException {
        double x = this.preferences.getDouble("x", -1.0);
        double y = this.preferences.getDouble("y", -1.0);
        double w = this.preferences.getDouble("width", this.stage.getWidth());
        double h = this.preferences.getDouble("height", this.stage.getHeight());
        boolean iconified = this.preferences.getBoolean("iconified", false);
        boolean maximized = this.preferences.getBoolean("maximized", false);
        boolean fullscreen = this.preferences.getBoolean("fullscreen", false);
        if (this.supportFullScreenAndMaximized) {
            this.LOG.fine(MessageFormat.format("loading stage, x = {0}, y = {1}, width = {2}, height = {3}, iconified = {4}, maximized = {5}, fullscreen = {6}", x, y, w, h, iconified, maximized, fullscreen));
        } else {
            this.LOG.fine(MessageFormat.format("loading stage, x = {0}, y = {1}, width = {2}, height = {3}, iconified = {4}", x, y, w, h, iconified));
        }
        if (x == -1.0 && y == -1.0) {
            this.stage.centerOnScreen();
        } else {
            this.stage.setX(x);
            this.stage.setY(y);
        }
        this.stage.setWidth(Math.max(this.minWidth, w));
        this.stage.setHeight(Math.max(this.minHeight, h));
        Platform.runLater(() -> {
            this.stage.setIconified(iconified);
            if (this.supportFullScreenAndMaximized) {
                this.stage.setMaximized(maximized);
                this.stage.setFullScreen(fullscreen);
            }
            if (this.isWindowIsOutOfBounds()) {
                this.LOG.fine("stage is out of bounds, moving it to primary screen");
                this.moveToPrimaryScreen();
            }
        });
    }

    private boolean isWindowIsOutOfBounds() {
        for (Screen screen : Screen.getScreens()) {
            Rectangle2D bounds = screen.getVisualBounds();
            if (!(this.stage.getX() + this.stage.getWidth() - this.minWidth >= bounds.getMinX()) || !(this.stage.getX() + this.minWidth <= bounds.getMaxX()) || !(bounds.getMinY() <= this.stage.getY()) || !(this.stage.getY() + this.minHeight <= bounds.getMaxY())) continue;
            return false;
        }
        return true;
    }

    private void moveToPrimaryScreen() {
        Rectangle2D bounds = Screen.getPrimary().getVisualBounds();
        double centerX = bounds.getMinX() + (bounds.getWidth() - this.minWidth) / 2.0;
        double centerY = bounds.getMinY() + (bounds.getHeight() - this.minHeight) / 2.0;
        this.stage.setX(centerX);
        this.stage.setY(centerY);
        this.stage.setWidth(this.minWidth);
        this.stage.setHeight(this.minHeight);
    }
}

