/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.MaskedView;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;

public class MaskedViewSkin
extends SkinBase<MaskedView> {
    private final Rectangle leftClip;
    private final Rectangle rightClip;
    private final Rectangle centerClip;
    private final StackPane stackPane;
    private final InvalidationListener translateXListener = it -> this.updateClip();
    private final WeakInvalidationListener weakTranslateXListener = new WeakInvalidationListener(this.translateXListener);

    public MaskedViewSkin(MaskedView view) {
        super((Control)view);
        this.leftClip = new Rectangle();
        this.rightClip = new Rectangle();
        this.centerClip = new Rectangle();
        this.centerClip.setFill((Paint)Color.BLACK);
        this.leftClip.setManaged(false);
        this.centerClip.setManaged(false);
        this.rightClip.setManaged(false);
        Group group = new Group(new Node[]{this.leftClip, this.centerClip, this.rightClip});
        this.stackPane = new StackPane();
        this.stackPane.getStyleClass().add((Object)"container");
        this.stackPane.setManaged(false);
        this.stackPane.setClip((Node)group);
        this.getChildren().add((Object)this.stackPane);
        view.contentProperty().addListener((observable, oldContent, newContent) -> this.buildView((Node)oldContent, (Node)newContent));
        this.buildView(null, view.getContent());
        view.widthProperty().addListener(it -> this.updateClip());
        view.fadingSizeProperty().addListener(it -> this.updateClip());
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.stackPane.prefHeight(width);
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.stackPane.minHeight(width);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.stackPane.maxHeight(width);
    }

    private void buildView(Node oldContent, Node newContent) {
        if (oldContent != null) {
            this.stackPane.getChildren().clear();
            oldContent.translateXProperty().removeListener((InvalidationListener)this.weakTranslateXListener);
        }
        if (newContent != null) {
            this.stackPane.getChildren().setAll((Object[])new Node[]{newContent});
            newContent.translateXProperty().addListener((InvalidationListener)this.weakTranslateXListener);
        }
        this.updateClip();
    }

    private void updateClip() {
        MaskedView view = (MaskedView)this.getSkinnable();
        Node content = view.getContent();
        if (content != null) {
            double fadingSize = view.getFadingSize();
            if (content.getTranslateX() < 0.0) {
                this.leftClip.setFill((Paint)new LinearGradient(0.0, 0.0, fadingSize, 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(1.0, Color.BLACK)}));
            } else {
                this.leftClip.setFill((Paint)Color.BLACK);
            }
            if (content.getTranslateX() + content.prefWidth(-1.0) > view.getWidth()) {
                this.rightClip.setFill((Paint)new LinearGradient(0.0, 0.0, fadingSize, 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.BLACK), new Stop(1.0, Color.TRANSPARENT)}));
            } else {
                this.rightClip.setFill((Paint)Color.BLACK);
            }
        }
        view.requestLayout();
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        double fadingSize = Math.min(contentWidth / 2.0, ((MaskedView)this.getSkinnable()).getFadingSize());
        this.stackPane.resizeRelocate(this.snapPositionX(contentX), this.snapPositionY(contentY), this.snapSpaceX(contentWidth), this.snapSpaceY(contentHeight));
        this.resizeRelocate(this.leftClip, this.snapPositionX(contentX), this.snapPositionY(contentY), this.snapSpaceX(fadingSize), this.snapSpaceY(contentHeight));
        this.resizeRelocate(this.centerClip, this.snapPositionX(contentX + fadingSize), this.snapPositionY(contentY), this.snapSpaceX(contentWidth - 2.0 * fadingSize), this.snapSpaceY(contentHeight));
        this.resizeRelocate(this.rightClip, this.snapPositionX(contentX + contentWidth - fadingSize), this.snapPositionY(contentY), this.snapSpaceX(fadingSize), this.snapSpaceY(contentHeight));
    }

    private void resizeRelocate(Rectangle rect, double x, double y, double w, double h) {
        rect.setLayoutX(x);
        rect.setLayoutY(y);
        rect.setWidth(w);
        rect.setHeight(h);
    }
}

