/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.tasks;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Sync;
import org.javamodularity.moduleplugin.tasks.AbstractModulePluginTask;

public class MergeClassesTask
extends AbstractModulePluginTask {
    private static final Logger LOGGER = Logging.getLogger(MergeClassesTask.class);

    public MergeClassesTask(Project project) {
        super(project);
    }

    public void configureMergeClasses() {
        this.project.afterEvaluate(p -> this.configureMergeClassesAfterEvaluate());
    }

    public void configureMergeClassesAfterEvaluate() {
        Sync mergeClasses = this.mergeClassesHelper().createMergeClassesTask();
        this.mergeClassesHelper().allCompileTaskStream().forEach(taskWrapper -> {
            List<String> modularTasks = List.of("compileJava", "compileModuleInfoJava");
            if (modularTasks.contains(taskWrapper.getTask().getName())) {
                mergeClasses.from(new Object[]{taskWrapper.getDestinationDir()});
            } else {
                mergeClasses.from((Object)taskWrapper.getDestinationDir(), copySpec -> copySpec.exclude(new String[]{"**/module-info.class"}));
            }
            mergeClasses.dependsOn(new Object[]{taskWrapper.getTask()});
        });
        mergeClasses.into((Object)this.helper().getMergedDir());
        mergeClasses.onlyIf(task -> this.mergeClassesHelper().isMergeRequired());
        Stream.of("run", "test", "compileTestJava", "compileTestFixturesJava").map(this.helper()::findTask).flatMap(Optional::stream).forEach(task -> task.dependsOn(new Object[]{mergeClasses}));
    }
}

