/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.ast.body;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.javamodularity.moduleplugin.shadow.javaparser.TokenRange;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.AllFieldsConstructor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Modifier;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.Node;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.NodeList;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.BodyDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.ClassOrInterfaceDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.EnumDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.MethodDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.Parameter;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.TypeDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.body.VariableDeclarator;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.AnnotationExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.AssignExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.expr.NameExpr;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.NodeWithJavadoc;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.NodeWithVariables;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.modifiers.NodeWithAccessModifiers;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.modifiers.NodeWithFinalModifier;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.nodeTypes.modifiers.NodeWithStaticModifier;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.observer.ObservableProperty;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.BlockStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.stmt.ReturnStmt;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.Type;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.type.VoidType;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.visitor.CloneVisitor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.visitor.GenericVisitor;
import org.javamodularity.moduleplugin.shadow.javaparser.ast.visitor.VoidVisitor;
import org.javamodularity.moduleplugin.shadow.javaparser.metamodel.FieldDeclarationMetaModel;
import org.javamodularity.moduleplugin.shadow.javaparser.metamodel.JavaParserMetaModel;
import org.javamodularity.moduleplugin.shadow.javaparser.metamodel.NonEmptyProperty;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.Resolvable;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import org.javamodularity.moduleplugin.shadow.javaparser.utils.Utils;

public class FieldDeclaration
extends BodyDeclaration<FieldDeclaration>
implements NodeWithJavadoc<FieldDeclaration>,
NodeWithVariables<FieldDeclaration>,
NodeWithAccessModifiers<FieldDeclaration>,
NodeWithStaticModifier<FieldDeclaration>,
NodeWithFinalModifier<FieldDeclaration>,
Resolvable<ResolvedFieldDeclaration> {
    private NodeList<Modifier> modifiers;
    @NonEmptyProperty
    private NodeList<VariableDeclarator> variables;

    public FieldDeclaration() {
        this(null, new NodeList<Modifier>(), new NodeList<AnnotationExpr>(), new NodeList<VariableDeclarator>());
    }

    public FieldDeclaration(NodeList<Modifier> modifiers, VariableDeclarator variable) {
        this(null, modifiers, new NodeList<AnnotationExpr>(), NodeList.nodeList((Node[])new VariableDeclarator[]{variable}));
    }

    public FieldDeclaration(NodeList<Modifier> modifiers, NodeList<VariableDeclarator> variables) {
        this(null, modifiers, new NodeList<AnnotationExpr>(), variables);
    }

    @AllFieldsConstructor
    public FieldDeclaration(NodeList<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<VariableDeclarator> variables) {
        this(null, modifiers, annotations, variables);
    }

    public FieldDeclaration(TokenRange tokenRange, NodeList<Modifier> modifiers, NodeList<AnnotationExpr> annotations, NodeList<VariableDeclarator> variables) {
        super(tokenRange, annotations);
        this.setModifiers((NodeList)modifiers);
        this.setVariables((NodeList)variables);
        this.customInitialization();
    }

    public FieldDeclaration(NodeList<Modifier> modifiers, Type type, String name) {
        this(Utils.assertNotNull(modifiers), new VariableDeclarator(type, Utils.assertNotNull(name)));
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public NodeList<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public NodeList<VariableDeclarator> getVariables() {
        return this.variables;
    }

    @Override
    public FieldDeclaration setModifiers(NodeList<Modifier> modifiers) {
        Utils.assertNotNull(modifiers);
        if (modifiers == this.modifiers) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.MODIFIERS, this.modifiers, modifiers);
        if (this.modifiers != null) {
            this.modifiers.setParentNode(null);
        }
        this.modifiers = modifiers;
        this.setAsParentNodeOf(modifiers);
        return this;
    }

    @Override
    public FieldDeclaration setVariables(NodeList<VariableDeclarator> variables) {
        Utils.assertNotNull(variables);
        if (variables == this.variables) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.VARIABLES, this.variables, variables);
        if (this.variables != null) {
            this.variables.setParentNode(null);
        }
        this.variables = variables;
        this.setAsParentNodeOf(variables);
        return this;
    }

    public MethodDeclaration createGetter() {
        if (this.getVariables().size() != 1) {
            throw new IllegalStateException("You can use this only when the field declares only 1 variable name");
        }
        Optional parentClass = this.findAncestor(ClassOrInterfaceDeclaration.class);
        Optional parentEnum = this.findAncestor(EnumDeclaration.class);
        if (!parentClass.isPresent() && !parentEnum.isPresent() || parentClass.isPresent() && ((ClassOrInterfaceDeclaration)parentClass.get()).isInterface()) {
            throw new IllegalStateException("You can use this only when the field is attached to a class or an enum");
        }
        VariableDeclarator variable = this.getVariable(0);
        String fieldName = variable.getNameAsString();
        String fieldNameUpper = fieldName.toUpperCase().substring(0, 1) + fieldName.substring(1, fieldName.length());
        MethodDeclaration getter = (MethodDeclaration)parentClass.map((Function<ClassOrInterfaceDeclaration, MethodDeclaration> & Serializable)clazz -> clazz.addMethod("get" + fieldNameUpper, Modifier.Keyword.PUBLIC)).orElseGet((Supplier<MethodDeclaration> & Serializable)() -> ((EnumDeclaration)parentEnum.get()).addMethod("get" + fieldNameUpper, Modifier.Keyword.PUBLIC));
        getter.setType(variable.getType());
        BlockStmt blockStmt = new BlockStmt();
        getter.setBody(blockStmt);
        blockStmt.addStatement(new ReturnStmt(fieldName));
        return getter;
    }

    public MethodDeclaration createSetter() {
        if (this.getVariables().size() != 1) {
            throw new IllegalStateException("You can use this only when the field declares only 1 variable name");
        }
        Optional parentClass = this.findAncestor(ClassOrInterfaceDeclaration.class);
        Optional parentEnum = this.findAncestor(EnumDeclaration.class);
        if (!parentClass.isPresent() && !parentEnum.isPresent() || parentClass.isPresent() && ((ClassOrInterfaceDeclaration)parentClass.get()).isInterface()) {
            throw new IllegalStateException("You can use this only when the field is attached to a class or an enum");
        }
        VariableDeclarator variable = this.getVariable(0);
        String fieldName = variable.getNameAsString();
        String fieldNameUpper = fieldName.toUpperCase().substring(0, 1) + fieldName.substring(1, fieldName.length());
        MethodDeclaration setter = (MethodDeclaration)parentClass.map((Function<ClassOrInterfaceDeclaration, MethodDeclaration> & Serializable)clazz -> clazz.addMethod("set" + fieldNameUpper, Modifier.Keyword.PUBLIC)).orElseGet((Supplier<MethodDeclaration> & Serializable)() -> ((EnumDeclaration)parentEnum.get()).addMethod("set" + fieldNameUpper, Modifier.Keyword.PUBLIC));
        setter.setType(new VoidType());
        setter.getParameters().add(new Parameter(variable.getType(), fieldName));
        BlockStmt blockStmt2 = new BlockStmt();
        setter.setBody(blockStmt2);
        blockStmt2.addStatement(new AssignExpr(new NameExpr("this." + fieldName), new NameExpr(fieldName), AssignExpr.Operator.ASSIGN));
        return setter;
    }

    public boolean isTransient() {
        return this.hasModifier(Modifier.Keyword.TRANSIENT);
    }

    public boolean isVolatile() {
        return this.hasModifier(Modifier.Keyword.VOLATILE);
    }

    public FieldDeclaration setTransient(boolean set) {
        return (FieldDeclaration)this.setModifier(Modifier.Keyword.TRANSIENT, set);
    }

    public FieldDeclaration setVolatile(boolean set) {
        return (FieldDeclaration)this.setModifier(Modifier.Keyword.VOLATILE, set);
    }

    @Override
    public boolean isStatic() {
        return this.hasModifier(Modifier.Keyword.STATIC) || this.isDeclaredInInterface();
    }

    @Override
    public boolean isFinal() {
        return this.hasModifier(Modifier.Keyword.FINAL) || this.isDeclaredInInterface();
    }

    @Override
    public boolean isPublic() {
        return this.hasModifier(Modifier.Keyword.PUBLIC) || this.isDeclaredInInterface();
    }

    private boolean isDeclaredInInterface() {
        Optional parentType = this.findAncestor(TypeDeclaration.class);
        return parentType.filter(BodyDeclaration::isClassOrInterfaceDeclaration).map(BodyDeclaration::asClassOrInterfaceDeclaration).map(ClassOrInterfaceDeclaration::isInterface).orElse(false);
    }

    @Override
    public boolean remove(Node node) {
        int i;
        if (node == null) {
            return false;
        }
        for (i = 0; i < this.modifiers.size(); ++i) {
            if (this.modifiers.get(i) != node) continue;
            this.modifiers.remove(i);
            return true;
        }
        for (i = 0; i < this.variables.size(); ++i) {
            if (this.variables.get(i) != node) continue;
            this.variables.remove(i);
            return true;
        }
        return super.remove(node);
    }

    @Override
    public FieldDeclaration clone() {
        return (FieldDeclaration)this.accept(new CloneVisitor(), null);
    }

    @Override
    public FieldDeclarationMetaModel getMetaModel() {
        return JavaParserMetaModel.fieldDeclarationMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        int i;
        if (node == null) {
            return false;
        }
        for (i = 0; i < this.modifiers.size(); ++i) {
            if (this.modifiers.get(i) != node) continue;
            this.modifiers.set(i, (Modifier)replacementNode);
            return true;
        }
        for (i = 0; i < this.variables.size(); ++i) {
            if (this.variables.get(i) != node) continue;
            this.variables.set(i, (VariableDeclarator)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isFieldDeclaration() {
        return true;
    }

    @Override
    public FieldDeclaration asFieldDeclaration() {
        return this;
    }

    @Override
    public void ifFieldDeclaration(Consumer<FieldDeclaration> action) {
        action.accept(this);
    }

    @Override
    public ResolvedFieldDeclaration resolve() {
        return this.getSymbolResolver().resolveDeclaration(this, ResolvedFieldDeclaration.class);
    }

    @Override
    public Optional<FieldDeclaration> toFieldDeclaration() {
        return Optional.of(this);
    }
}

