\page ExampleTestEm18 Example TestEm18

 This example allows to study the various contributions of the energy lost 
 by a charged particle in a single layer of an homogeneous material.
 See any textbook of interactions of charged particles with matter, in particular :
 - 1- geant4.web.cern.ch --> UserSupport --> Physics Reference Manual
 - 2- lappweb.in2p3.fr/~maire/tutorials/index.html
	
## GEOMETRY DEFINITION
 
 It is a simple cubic box of homogeneous material.
 Two parameters define the geometry :
     - the material of the box,
     - the thickness of the box.
 
 The default geometry (1 cm of water) is constructed in DetectorConstruction,
 but the above parameters can be changed interactively via the commands
 defined in DetectorMessenger.
 	
## PHYSICS
 
 The physics list, PhysicsList, contains the 'standard' electromagnetic processes.
 However the MultipleScattering is not registered, in order to focuse on
 fluctuations of to energy loss alone.
	 	 
## BEAM
 
 The primary kinematic is a single particle starting at the edge
 of the box. The type of the particle and its energy are set in 
 PrimaryGeneratorAction (e- 10 MeV), and can be changed via the G4 
 build-in commands of G4ParticleGun class.
 	
## RUN

 During the tracking of the incident particle, by default, the secondary 
 particles are immediately killed, after that their energy has been registered
 (see SteppingAction and StackingAction).
 Therefore, we study here the various components of the total energy lost
 by the incident particle, not the energy deposited in a layer of finite
 thickness.
 With the option /testEm/trackSecondaries one can compute and plot the energy
 deposited in the layer. See edep.mac

 At EndOfRun, the above results are compared with 'reference' values,
 i.e. the input data read from EnergyLoss and Range tables.
 See reference 2 : Energy-Range relation, slide 4.

## HISTOGRAMS
         
 The test contains 13 built-in 1D histograms, which are managed by
 G4AnalysisManager and its messenger.

 -  1:  step size of primary track
 -  2:  energy locally deposited along primary track
 -  3:  energy transfered to secondaries by ionisation
 -  4:  energy transfered to secondaries by Bremsstrahlung
 -  5:  energy transfered to secondaries by (e+,e-) production
 -  6:  total energy transfered to secondaries
 -  7:  total energy lost by primary track
 -  8:  total energy lost by primary track from energy balance
 -  9:  energy continuously deposited along secondary tracks
 - 10:  total energy deposited
 - 11:  energy spectrum of gamma
 - 12:  energy spectrum of e-
 - 13:  energy spectrum of e+

 The histograms are defined in HistoManager.
     
 The histos can be activated individually with the command :
```
/analysis/h1/set id nbBins valMin valMax unit
```
 where 'unit' is the desired unit for the histo (MeV or KeV, cm or mm, etc..)
								  
 One can control the name of the histograms file with the command:
```
/analysis/setFileName  name  (default testem18)
```
 
 It is possible to choose the format of the histogram file : root (default),
 xml, csv, by changing the default file type in HistoManager.cc     
 For convenience, few simple Root macros are provided : plotHisto.C pixe.C
    
 It is also possible to print selected histograms on an ascii file:
```
/analysis/h1/sweAscii id
```
 All selected histos will be written on a file name.ascii  (default testem18)
 	 				
## VISUALIZATION
 
 The Visualization Manager is set in the main().
 The initialisation of the drawing is done via the commands
 /vis/... in the macro vis.mac. To get visualisation:
```
> /control/execute vis.mac
```
 	
 The detector has a default view which is a longitudinal view of the box.
 The tracks are drawn at the end of event, and erased at the end of run.
	
## HOW TO START ?
 
 - Execute TestEm18 in 'batch' mode from macro files :
```
% ./TestEm18   electron.mac
```
 		
 - Execute TestEm18 in 'interactive mode' with visualization :
```
% ./TestEm18
Idle> control/execute vis.mac
....
Idle> type your commands
....
Idle> exit
```
	
 Macros provided in this example:
  - csda.mac: test independance of user step max
  - edep.mac: track secondary particles and plot energy deposited
  - electron.mac: e- (10 MeV) on 1 cm of water
  - ion.mac: ion C12 (4 GeV) on 1 cm of water
  - muon.mac: mu+ (1 TeV) on 1 m of water 
  - pixe.mac: proton (20 MeV) on 50 um of gold. Plot gamma pixe
  - proton.mac: proton (1 GeV) on 10 cm of water
  - plotHisto.C, pixe.C: Root macros
  
  Macros to be run interactively:
  - vis.mac: To activate visualization  